<?php
/**
 * @package     Joomla.Site
 * @subpackage  Templates.protostar
 *
 * @copyright   Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/** @var JDocumentHtml $this */

$app  = JFactory::getApplication();
$user = JFactory::getUser();

// Output as HTML5
$this->setHtml5(true);

// Getting params from template
$params = $app->getTemplate(true)->params;

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');

if ($task === 'edit' || $layout === 'form')
{
	$fullWidth = 1;
}
else
{
	$fullWidth = 0;
}

// Add JavaScript Frameworks
#JHtml::_('bootstrap.framework');

// Add template js
JHtml::_('script', 'bootstrap4.1.3.min.js', array('version' => 'auto', 'relative' => true));
JHtml::_('script', 'houper.js', array('version' => 'auto', 'relative' => true));

// Add html5 shiv
JHtml::_('script', 'jui/html5.js', array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));

// Add Stylesheets
JHtml::_('stylesheet', 'bootstrap4.1.3.min.css', array('version' => 'auto', 'relative' => true));
JHtml::_('stylesheet', 'houper.css', array('version' => 'auto', 'relative' => true));
// Load optional RTL Bootstrap CSS
if($this->direction == 'ltr') {
JHtml::_('stylesheet', 'houper-ltr.css', array('version' => 'auto', 'relative' => true));
}


// Template color
if ($this->params->get('templateColor'))
{
	$this->addStyleDeclaration('
	body.site {
		background-color: ' . $this->params->get('templateBackgroundColor') . ';
	}
	header {
		background-color: ' . $this->params->get('templateColor') . ';
		border-top:5px solid ' . $this->params->get('templateBackgroundColorAlt') . ';
	}
	.collapse-top {
		background-color: ' . $this->params->get('templateBackgroundColorAlt') . ';

	}
	hr{
		border-color:' . $this->params->get('templateBackgroundColorAlt') . ';
	}
    #mega-menu{
    	background-color: ' . $this->params->get('templateColor') . ';
    }
	menu a{
		color: ' . $this->params->get('fontColorAlt') . ';
	}
	#investigate{
		background-color: ' . $this->params->get('templateColorAlt') . ';
	}
	.uk-button{
		background-color: ' . $this->params->get('templateColor') . ';
		color: ' . $this->params->get('fontColorAlt') . ';
	}
    .bg-houper{
    	background: ' . $this->params->get('templateColor') . ';
    }
    .txt-houper h1,.txt-houper h2,.txt-houper h3{
		color: ' . $this->params->get('templateColor') . ';
    }
    #midel h3و#license h2,#document h2{
    	color: ' . $this->params->get('templateColor') . ';
    }
    #midel .bg-houper h3{
    	color: ' . $this->params->get('templateBackgroundColor') . ';
    }
	#media,#license {
		background-color: ' . $this->params->get('templateColorAlt') . ';
		color: ' . $this->params->get('fontColor') . ';
	}
	#customer,footer {
		background-color: ' . $this->params->get('templateBackgroundColorAlt') . ';
		color: ' . $this->params->get('fontColor') . ';
	}
    footer h1,footer h2,footer h3,footer h4{
    	color: ' . $this->params->get('templateColor') . ';
    }
    .uk-dotnav>li>a {
        border: 2px solid ' . $this->params->get('templateColor') . ' !important;
  	}
    .uk-dotnav>.uk-active>* {
        background: ' . $this->params->get('templateColor') . ';
  	}
    .bt-inner .readmore a,#media  a.ns2-readmore {
        background: ' . $this->params->get('templateColor') . ';
        color: ' . $this->params->get('templateBackgroundColor') . ';
    }
    #media .uk-border-rounded {
      border: 1px solid ' . $this->params->get('templateColor') . ' !important;
  	}
    #media .bt-cs .bt-inner img {
        outline: 1px solid ' . $this->params->get('templateColor') . ';
        border: 1px solid ' . $this->params->get('templateColor') . ';
    }
    #media img.ns2-image{
    	border: 2px solid ' . $this->params->get('templateColor') . ';
    }
    #document .ns2-inner {
        border: 1px solid ' . $this->params->get('templateColor') . ';
    }

    #document .ns2-inner a.ns2-readmore {
        
        color: ' . $this->params->get('templateBackgroundColor') . ';
    }
	');
}

// Check for a custom CSS file
JHtml::_('stylesheet', 'user.css', array('version' => 'auto', 'relative' => true));

// Check for a custom js file
JHtml::_('script', 'user.js', array('version' => 'auto', 'relative' => true));



// Adjusting content width
$right = $this->countModules('right');
$left = $this->countModules('left');

if ($right && $left)
{
	$span = 'span6';
}
elseif ($right && !$left)
{
	$span = 'span9';
}
elseif (!$right && $left)
{
	$span = 'span9';
}
else
{
	$span = 'span12';
}

// Logo file or site title param
if ($this->params->get('logoFile'))
{
	$logo = '<img src="' . JUri::root() . $this->params->get('logoFile') . '" alt="' . $sitename . '" />';
}
elseif ($this->params->get('sitetitle'))
{
	$logo = '<span class="site-title" title="' . $sitename . '">' . htmlspecialchars($this->params->get('sitetitle'), ENT_COMPAT, 'UTF-8') . '</span>';
}
else
{
	$logo = '<span class="site-title" title="' . $sitename . '">' . $sitename . '</span>';
}
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<jdoc:include type="head" />
</head>
<body class="site <?php echo $option
	. ' view-' . $view
	. ($layout ? ' layout-' . $layout : ' no-layout')
	. ($task ? ' task-' . $task : ' no-task')
	. ($itemid ? ' itemid-' . $itemid : '')
	. ($params->get('fluidContainer') ? ' fluid' : '')
	. ($this->direction === 'rtl' ? ' rtl' : '');
?>">
	<!-- Body -->
<?php #if ($this->countModules('top')||$this->countModules('menu')) : ?>

    <?php if ($this->countModules('collapse-top')||$this->countModules('top')) : ?>
	<div class="collapse" id="collapse-top">
		<div class="card card-body">
			<jdoc:include type="modules" name="top" style="xhtml" />
		</div>
	</div>
	<?php endif; ?>
  

<header class="clearfix">
	<div class="header container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
        	
            
                
            <div class="col-8 col-sm-9 clearfix">
            
            	<div class="row clearfix">
					
                    <?php if ($this->countModules('collapse-top')||$this->countModules('lang')) : ?>
                    	
                        <jdoc:include type="modules" name="lang" style="xhtml" /><? // col-6 col-md-2 ?>
                        
                        
                        <a class="col-6 col-md-2 collapse-top" data-toggle="collapse" href="#collapse-top">
                        	<?php #echo JText::_('TPL_HOUPER_COLLAPSETOP'); ?>
							<jdoc:include type="modules" name="collapse-top" style="xhtml" />                      
                        </a>
					<?php endif; ?>
                    
                    <?php if ($this->countModules('contact')) : ?>
                        <jdoc:include type="modules" name="contact" style="xhtml" />
                    <?php endif; ?>
                    
                </div>
                
                      
                <?php if ($this->countModules('menu')) : ?> 
                <hr/>
                <menu class="sticky-top navbar navbar-expand-lg navbar-light clearfix">
                
                    <button class="navbar-toggler ml-auto" type="button" 
                            data-toggle="collapse" data-target="#menu" 
                            >
                        <span class="navbar-toggler-icon"></span>
                    </button>
                        
                    
                    <div id="menu" class="collapse navbar-collapse">
                        <jdoc:include type="modules" name="menu" style="xhtml" />	<!--navbar-nav-->
                    </div>
                    
                    
                </menu>
                <?php endif; ?>
                  
            </div>
            
            <a class="col-4 col-sm-3 navbar-brand d-none mr-auto" href="<?php echo $this->baseurl; ?>/">
				<?php echo $logo; ?>
                <?php if ($this->params->get('sitedescription')) : ?>
                    <?php echo '<div class="site-description">' . htmlspecialchars($this->params->get('sitedescription'), ENT_COMPAT, 'UTF-8') . '</div>'; ?>
                <?php endif; ?>
            </a>
                  
            
        </div>
    </div>
</header> 
<?php #endif; ?>
   
            
<?php if ($this->countModules('mega-menu')) : ?> 
<div id="mega-menu" class="sticky-top clearfix">
	<div id="menu" class="row">
  		<div class="col-12 menu clearfix">
  			<jdoc:include type="modules" name="mega-menu" style="xhtml" />
		</div>
    </div>
</div>
<?php endif; ?>

  
<div id="mega-logo" class="container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?>">
	<div id="" class="row mega-logo"> 
       <a class="col-4 col-sm-3 navbar-brand mr-auto" href="<?php echo $this->baseurl; ?>/">
          <?php echo $logo; ?>
          <?php if ($this->params->get('sitedescription')) : ?>
          <?php echo '<div class="site-description">' . htmlspecialchars($this->params->get('sitedescription'), ENT_COMPAT, 'UTF-8') . '</div>'; ?>
          <?php endif; ?>
      </a>
     </div>
</div>
                  
<?php if ($this->countModules('slider')) : ?>           
<div id="slider" class="mb-3 pb-3 clearfix">            
	<div class="slider <?php //echo ($params->get('fluidContainer') ? 'container-fluid' : ''); ?> clearfix">
        <!--div class="row clearfix">
            <div class="col-sm-12 clarfix"-->            
                <jdoc:include type="modules" name="slider" style="xhtml" />
            <!--/div>
        </div-->
    </div>
</div>    
<?php endif; ?>

  
  
<?php if ($this->countModules('introduction')) : ?>           
<div id="introduction" class="clearfix">            
	<div class="introduction container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="introduction" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>
  


<?php if ($this->countModules('investigate')) : ?>           
<div id="investigate" class="clearfix">            
	<div class="investigate container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="investigate" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>

  

<?php if ($this->countModules('document')) : ?>           
<div id="document" class="clearfix">            
	<div class="document container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="document" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>
  
  
<?php if ($this->countModules('midel')) : ?>           
<div id="midel" class="clearfix">            
	<div class="midel container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
                <jdoc:include type="modules" name="midel" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>

    

<main id="content" class="clearfix"> 
	<div class="content container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">   
        <div class="row clearfix">
        
            <?php if ($right) : ?>
                <aside id="right" class="col-sm-12 col-md-2 clearfix">
                    <div class="sidebar-nav">
                        <jdoc:include type="modules" name="right" style="xhtml" />
                    </div>
                </aside>
            <?php endif; ?>
            
            <article id="content" role="main" class="<?php echo $span; ?>" class="clearfix">
            
                <?php if ($this->countModules('lead')) : ?>
                <div class="col-sm-12 clearfix">
                    <jdoc:include type="modules" name="lead" style="xhtml" />
                </div>
                <?php endif; ?>
                
                <jdoc:include type="message" />
                <jdoc:include type="component" />
                
                <?php if ($this->countModules('bottom')) : ?>
                <div class="col-sm-12 clearfix">
                    <jdoc:include type="modules" name="bottom" style="none" />
                </div>
                <?php endif; ?>
                
            </article>
            
            
            <?php if ($left) : ?>
                <aside id="left" class="col-sm-12 col-md-2 clearfix">
                    <jdoc:include type="modules" name="left" style="xhtml" />
                </aside>
            <?php endif; ?>
        </div>
    </div>
</main>




<?php if ($this->countModules('media')) : ?>           
<div id="media" class="pt-4 clearfix">            
	<div class="media container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="media" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>



<?php if ($this->countModules('service')) : ?>           
<div id="service" class="clearfix">            
	<div class="service container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="service" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>



<?php if ($this->countModules('customer')) : ?>           
<div id="customer" class="clearfix">            
	<div class="customer container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="customer" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>



<?php if ($this->countModules('license')) : ?>           
<div id="license" class="clearfix">            
	<div class="license container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?> clearfix">
        <div class="row clearfix">
			<jdoc:include type="modules" name="license" style="xhtml" />
        </div>
    </div>
</div>    
<?php endif; ?>
    
    
<footer class="footer py-3" role="contentinfo" class="clearfix">
	<div class="container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?>">
        
        <div class="row clearfix">
        
            <a id="scrollup">
                <?php echo JText::_('TPL_HOUPER_BACKTOTOP'); ?>
            </a>
        
        	<?php if ($this->countModules('footer')) : ?>  
				<jdoc:include type="modules" name="footer" style="xhtml" />
			<?php endif; ?>
            
            
            <?php if ($this->countModules('copyright')) : ?> 
            <hr class="w-100 clearfix" />
            <div id="copyright" class="col clearfix">
                
                <jdoc:include type="modules" name="copyright" style="xhtml" />
            </div>
            <?php endif; ?>
            
        </div>
    </div>
</footer>
   
	<jdoc:include type="modules" name="debug" style="none" />

</body>
</html>
