<?php
/**
* @package RSForm!Pro
* @copyright (C) 2014 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-2.0.html
*/

defined('_JEXEC') or die('Restricted access');

class plgSystemRSFPPayPal extends JPlugin
{
	protected $componentId 	= 500;
	protected $componentValue = 'paypal';
	protected $log = array();
	public function __construct( &$subject, $config )
	{
		parent::__construct( $subject, $config );
		$this->newComponents = array(500);
	}

	public function rsfp_bk_onAfterShowComponents()
	{
		JFactory::getLanguage()->load( 'plg_system_rsfppaypal' );

		$formId 	= JFactory::getApplication()->input->getInt('formId');

		$link = "displayTemplate('".$this->componentId."')";
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId))
			$link = "displayTemplate('".$this->componentId."', '".$components[0]."')";
		?>
		<li><a href="javascript: void(0);" onclick="<?php echo $link;?>;return false;" id="rsfpc<?php echo $this->componentId; ?>"><span class="rsficon rsficon-paypal"></span><span class="inner-text"><?php echo JText::_('RSFP_PAYPAL_COMPONENT'); ?></span></a></li>
		<?php
	}

	/**
	 * Add a grand total and tax placeholder
	 * @param $args
	 */
	public function rsfp_onAfterCreatePlaceholders($args)
	{
		$choosePayment = RSFormProHelper::componentExists($args['form']->FormId, 27);
		$hasPaypal	   = RSFormProHelper::componentExists($args['form']->FormId, $this->componentId);
		if ($choosePayment || $hasPaypal)
		{
			if ($choosePayment)
			{
				$properties = RSFormProHelper::getComponentProperties($choosePayment[0]);
				$fieldName  = $properties['NAME'];

				if (!isset($args['submission']->values[$fieldName]))
				{
					return;
				}

				if ($args['submission']->values[$fieldName] != 'paypal')
				{
					return;
				}
			}

			$grandTotal = $this->calcTax($args['submission']->values['rsfp_Total'], RSFormProHelper::getConfig('paypal.tax.value'), RSFormProHelper::getConfig('paypal.tax.type'));

			$placeholders = &$args['placeholders'];
			$values = &$args['values'];

			$placeholders[] = '{grandtotal}';
			$values[] = $grandTotal;

			$placeholders[] = '{tax}';
			$values[] = $grandTotal - $args['submission']->values['rsfp_Total'];
		}
	}

	public function rsfp_getPayment(&$items, $formId)
	{
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId))
		{
			$data = RSFormProHelper::getComponentProperties($components[0]);

			$item 			= new stdClass();
			$item->value 	= $this->componentValue;
			$item->text 	= $data['LABEL'];

			// add to array
			$items[] = $item;
		}
	}

	public function rsfp_doPayment($payValue, $formId, $SubmissionId, $price, $products, $code)
	{
		// execute only for our plugin
		if ($payValue != $this->componentValue) return;

		if ($price > 0) {
			list($replace, $with) = RSFormProHelper::getReplacements($SubmissionId);

			$args = array(
				'cmd'           => '_xclick',
				'business'      => RSFormProHelper::getConfig('paypal.email'),
				'item_name'     => implode(', ', $products),
				'currency_code' => RSFormProHelper::getConfig('payment.currency'),
				'amount'        => number_format($price, 2, '.', ''),
				'notify_url'    => JURI::root() . 'index.php?option=com_rsform&formId=' . $formId . '&task=plugin&plugin_task=paypal.notify&code=' . $code,
				'charset'       => 'utf-8',
				'lc'            => RSFormProHelper::getConfig('paypal.language') ? RSFormProHelper::getConfig('paypal.language') : 'US',
				'bn'            => 'RSJoomla_SP',
				'return'        => JURI::root() . 'index.php?option=com_rsform&formId=' . $formId . '&task=plugin&plugin_task=paypal.return'
			);

			// Add cancel URL
			if ($cancel = RSFormProHelper::getConfig('paypal.cancel')) {
				$args['cancel_return'] = str_replace($replace, $with, $cancel);
			}

			// Add return URL
			if ($return = RSFormProHelper::getConfig('paypal.return')) {
				$args['return'] = str_replace($replace, $with, $return);
			}

			// Add tax
			if ($tax = RSFormProHelper::getConfig('paypal.tax.value')) {
				if (RSFormProHelper::getConfig('paypal.tax.type')) {
					$args['tax'] = $tax;
				} else {
					$args['tax_rate'] = $tax;
				}
			}

			// Get a new instance of the PayPal object. This is used so that we can programatically change values sent to PayPal through the "Scripts" areas.
			$paypal = RSFormProPayPal::getInstance();

			// If any options have already been set, use this to override the ones used here
			$paypal->args = array_merge($args, $paypal->args);

			JFactory::getApplication()->redirect($paypal->url.'?'.http_build_query($paypal->args, '', '&'));
		}
	}

	protected function payPalReturn($formId){
		// Get session object
		$session = JFactory::getSession();
		$app = JFactory::getApplication();
		// Get data from session
		$formparams = $session->get('com_rsform.formparams.formId'.$formId);
		if ($formparams && $formparams->redirectUrl) {
			// Mark form as processed
			$formparams->formProcessed = true;

			// Store new session data
			$session->set('com_rsform.formparams.formId'.$formId, $formparams);

			// Redirect
			$app->redirect($formparams->redirectUrl);
		}

	}

	public function rsfp_bk_onAfterCreateComponentPreview($args = array())
	{
		if ($args['ComponentTypeName'] == 'paypal')
		{
			$args['out'] = '<td>&nbsp;</td>';
			$args['out'].= '<td><span style="font-size:24px;margin-right:5px" class="rsficon rsficon-paypal"></span> '.$args['data']['LABEL'].'</td>';
		}
	}

	public function rsfp_bk_onAfterShowConfigurationTabs($tabs)
	{
		JFactory::getLanguage()->load( 'plg_system_rsfppaypal' );

		$tabs->addTitle(JText::_('RSFP_PAYPAL_LABEL'), 'form-paypal');
		$tabs->addContent($this->paypalConfigurationScreen());
	}

	/**
	 * Helper function to write log entries
	 */
	protected function writeLog()
	{
		// Need to separate IPN entries
		$this->addLogEntry("----------------------------- \n");

		$config   = JFactory::getConfig();
		$log_path = $config->get('log_path') . '/rsformpro_paypal_log.php';
		$log      = implode("\n", $this->log);

		/**
		 * If it's the first time we write in it, we need to add die() at the beginning of the file
		 */
		if (is_writable($config->get('log_path')))
		{
			if (!file_exists($log_path))
			{
				file_put_contents($log_path, "<?php die(); ?>\n");
			}

			/**
			 * we start appending log entries
			 */
			file_put_contents($log_path, $log, FILE_APPEND);
		}
	}

	/**
	 * Helper function to add messages to the log
	 *
	 * @param $message
	 */
	protected function addLogEntry($message)
	{
		$this->log[] = JFactory::getDate()->toSql() . ' : ' . $message;
	}

	public function rsfp_f_onSwitchTasks()
	{
		$input    = JFactory::getApplication()->input;

		// Notification receipt from Paypal
		if ($input->getString('plugin_task', '') == 'paypal.notify')
		{
			$code 	= $input->getCmd('code');
			$formId = $input->getInt('formId');
			$this->addLogEntry('IPN received from PayPal');

			$validation = $this->validateIpn();
			if($validation['error'])
			{
				$message = 'Validation failed -> ' . $validation['reason'];
				$this->addLogEntry($message);
				$this->addLogEntry('POST data is:');
				$this->addLogEntry(print_r($_POST, true));
				$this->addLogEntry('Validation data is:');
				$this->addLogEntry(print_r($this->_getValidationFields(), true));

				$this->writeLog();
				return false;
			}

			/**
			 * In case you issue a refund, there is no need to resend emails
			 */
			if( in_array($input->getString('reason_code', ''), array('refund', 'chargeback')) )
			{
				$message = 'Issued Refund for: ' . $input->getString('payer_email');
				$this->addLogEntry($message);

				$this->writeLog();
				return false;
			}

			$SubmissionId = $this->_getSubmissionId($formId, $code);
			if ($SubmissionId)
			{
				$message = 'Payment accepted from: ' . $input->getString('payer_email');
				$this->addLogEntry($message);
				$this->addLogEntry('Update database');

				$db = JFactory::getDbo();
				$db->setQuery("UPDATE #__rsform_submission_values sv SET sv.FieldValue=1 WHERE sv.FieldName='_STATUS' AND sv.FormId='".$formId."' AND sv.SubmissionId = '".$SubmissionId."'");
				$db->execute();

				$this->addLogEntry('Succesfully updated database');
				JFactory::getApplication()->triggerEvent('rsfp_afterConfirmPayment', array($SubmissionId));
				$this->addLogEntry('Payment confirmed');
				$this->writeLog();
			}
			jexit('ok');
		}

		if ($input->getString('plugin_task', '') == 'paypal.return')
		{
			$formId = $input->getInt('formId');
			$this->payPalReturn($formId);
		}
	}

	/**
	 * @return array
	 * @throws Exception
	 */
	public function validateIpn(){
		/**
		 * Set the URL
		 */
		$url = RSFormProHelper::getConfig('paypal.test') ? 'https://www.paypal.com/cgi-bin/webscr' : 'https://www.sandbox.paypal.com/cgi-bin/webscr';

		/**
		 * Build a default array for errors
		 */
		$array = array(
			'error'  => false,
			'reason' => null,
		);

		/**
		 * Start the IPN Verifaction here,
		 * Set up the fields to connect to the PayPal validation service
		 * and log each step individually in the log.
		 */
		$message = sprintf('Connecting to %s to verify if PayPal response is valid.', $url);
		$this->addLogEntry($message);

		/***
		 * Instantiate JHttpFactory;
		 */
		$http = JHttpFactory::getHttp();

		/**
		 * Use the RSFP! Version and the URL of the website to set the User Agent
		 */
		require_once JPATH_ADMINISTRATOR . '/components/com_rsform/helpers/version.php';
		$version = (string) new RSFormProVersion;
		$http->setOption('userAgent', "RSFormPro!/$version (" . JUri::root() . ")");

		/**
		 * Although Joomla! can parse the fields by itself,
		 * we can use this function to return a string.
		 */
		$req = $this->_buildPostData();
		try
		{
			$response = $http->post($url, $req, array(), 5);
			if ($response->code != 200)
			{
				throw new Exception(sprintf('Connection Error: %d', $response->code));
			}

			if (!isset($response->body))
			{
				throw new Exception('Response does not contain a valid body');
			}
		}
		catch (Exception $e)
		{
			return array(
				'error'  => true,
				'reason' => $e->getMessage(),
			);
		}

		/**
		 * In case the URL returns a different response, something went wrong.
		 * return here
		 */
		if (!in_array($response->body, array('INVALID', 'VERIFIED')))
		{
			$array['error']  = true;
			$array['reason'] = sprintf('PayPal response is not valid! Should be either VERIFIED or INVALID, received %s', strip_tags($response->body));

			return $array;
		}

		/**
		 * In case the response is invalid,
		 * return an error
		 */
		if (strcmp($response->body, 'INVALID') == 0)
		{
			$array['error']  = true;
			$array['reason'] = "PayPal reported an invalid transaction.";

			return $array;
		}

		/**
		 * Else, validate the transaction
		 */
		if (strcmp($response->body, "VERIFIED") == 0)
		{
			$this->addLogEntry('PayPal reported a valid transaction.');
		}

		/**
		 * Grab the information we need for validation with J-Input
		 * _getValidationFields() returns an array :
		 * array(
		 *  'currency' => 'USD',
		 *  'receiver_email' => 'email@email.com',
		 *  'reason' => 'refund'
		 * )
		 */
		$validation_fields = $this->_getValidationFields();
		/**
		 * We verify the amount paid only if it's a purchase transaction.
		 *
		 * The refund amount may vary due to the fact that partial refunds are available
		 */
		if ($validation_fields['reason'] !== 'refund')
		{
			/**
			 * Grab the Submission ID of the order
			 * return error if the submission does not exist
			 */
			$SubmissionId = $this->_getSubmissionId($validation_fields['formId'], $validation_fields['code']);
			if (!$SubmissionId)
			{
				$array['error']  = true;
				$array['reason'] = 'Submission does not exist.';
			}

			/**
			 * Use SubmissionId to get the total
			 * return error if it's null
			 */
			$total = $this->_getSubmissionValue($SubmissionId, 'rsfp_Total');
			if ($total === null)
			{
				$array['error']  = true;
				$array['reason'] = 'The total price of the order could not be verified.';

				return $array;
			}

			/**
			 * If we have an amount, make sure it's not "cheaper"
			 * return error if it is
			 */
			if ($validation_fields['amount'] < $total)
			{
				$array['error']  = true;
				$array['reason'] = 'The payment amount is not correct.';

				return $array;
			}

			/**
			 * If errors were not returned, we declare it OK and write it in log
			 */
			$this->addLogEntry(sprintf('Check the order\'s amount paid: %s - %s. Payment amount is correct.', $validation_fields['amount'], $total));
		}

		/**
		 * Check if the Email address of the receiving end is the same with the one from RSForm!Pro Configuration
		 * return error if it isn't
		 */
		if (RSFormProHelper::getConfig('paypal.email') !== $validation_fields['receiver_email'])
		{
			$array['error']  = true;
			$array['reason'] = sprintf('The email address is not correct - %s', $validation_fields['receiver_email']);

			return $array;
		}

		/**
		 * Write it in log if it passed
		 */
		$this->addLogEntry(sprintf('Checking the email address : %s - %s. Email address is correct.', RSFormProHelper::getConfig('paypal.email'), $validation_fields['receiver_email']));

		/**
		 * Check the currency of the transaction, see if it matches RSForm!Pro Configuration
		 */
		if (RSFormProHelper::getConfig('payment.currency') !== $validation_fields['currency'])
		{
			$array['error']  = true;
			$array['reason'] = sprintf('The currency does not match - %s', $validation_fields['currency']);

			return $array;
		}

		/**
		 * Write it in log if it passed
		 */
		$this->addLogEntry(sprintf('Checking currency : %s - %s. Currency is correct.', RSFormProHelper::getConfig('payment.currency'), $validation_fields['currency']));

		/**
		 * If we refunded, write in log the amount.
		 */
		if($validation_fields['reason'] == 'refund'){
			$this->addLogEntry(sprintf('Amount refunded: %s', $validation_fields['amount']));
		}

		return $array;
	}

	/**
	 * @return string
	 */
	protected function _buildPostData()
	{
		// read the post from PayPal system and add 'cmd'
		$req = 'cmd=_notify-validate';

		//reading raw POST data from input stream. reading pot data from $_POST may cause serialization issues since POST data may contain arrays
		$raw_post_data = file_get_contents('php://input');
		if ($raw_post_data)
		{
			$raw_post_array = explode('&', $raw_post_data);
			$myPost = array();
			foreach ($raw_post_array as $keyval) {
				$keyval = explode ('=', $keyval);
				if (count($keyval) == 2) {
					$myPost[$keyval[0]] = urldecode($keyval[1]);
				}
			}

			$get_magic_quotes_exists 	= function_exists('get_magic_quotes_gpc');
			$get_magic_quotes_gpc 		= $get_magic_quotes_exists && get_magic_quotes_gpc();

			foreach ($myPost as $key => $value) {
				if ($key == 'limit' || $key == 'limitstart' || $key == 'option') continue;

				if ($get_magic_quotes_exists && $get_magic_quotes_gpc) {
					$value = urlencode(stripslashes($value));
				} else {
					$value = urlencode($value);
				}
				$req .= "&$key=$value";
			}
		} else {
			// read the post from PayPal system
			$post = $_POST;
			foreach ($post as $key => $value)
			{
				if ($key == 'limit' || $key == 'limitstart' || $key == 'option') continue;

				$value = urlencode($value);
				$req .= "&$key=$value";
			}
		}

		return $req;
	}

	public function paypalConfigurationScreen()
	{
		ob_start();

		?>
		<div id="page-paypal" class="com-rsform-css-fix">
			<table class="admintable">
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="currency"><?php echo JText::_( 'RSFP_PAYPAL_EMAIL' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paypal.email]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.email')); ?>" size="100" maxlength="64"></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="return"><?php echo JText::_( 'RSFP_PAYPAL_RETURN' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paypal.return]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.return'));  ?>" size="100"></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="cancel"><?php echo JText::_( 'RSFP_PAYPAL_CANCEL' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paypal.cancel]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.cancel'));  ?>" size="100"></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="currency"><?php echo JText::_( 'RSFP_PAYPAL_TEST' ); ?></label></td>
					<td><?php echo JHTML::_('select.booleanlist', 'rsformConfig[paypal.test]' , '' , RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.test')));?></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="tax.type"><?php echo JText::_( 'RSFP_PAYPAL_TAX_TYPE' ); ?></label></td>
					<td><?php echo JHTML::_('select.booleanlist', 'rsformConfig[paypal.tax.type]' , '' , RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.tax.type')), JText::_('RSFP_PAYPAL_TAX_TYPE_FIXED'), JText::_('RSFP_PAYPAL_TAX_TYPE_PERCENT'));?></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="tax.value"><?php echo JText::_( 'RSFP_PAYPAL_TAX_VALUE' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paypal.tax.value]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.tax.value'));  ?>" size="4" maxlength="5"></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="language"><?php echo JText::_( 'RSFP_PAYPAL_LANGUAGE' ); ?></label></td>
					<td>
						<input type="text" name="rsformConfig[paypal.language]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paypal.language'));  ?>" size="4" maxlength="2">
						<?php echo JText::_('PAYPAL_LANGUAGES_CODES') ?>
					</td>
				</tr>
			</table>
		</div>
		<?php

		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	}

	/**
	 * @param $price
	 * @param $amount
	 * @param $type
	 *
	 * @return mixed
	 */
	public function calcTax($price, $amount, $type)
	{
		$price = (float) $price;
		$amount = (float) $amount;
		switch ($type)
		{
			case false:
				$price = $price + (($price * $amount) / 100);
				break;

			case true:
				$price = $price + $amount;
				break;
		}

		return $price;
	}

	protected function _getSubmissionValue($submissionId, $componentId) {
		if (is_numeric($componentId)) {
			$name = $this->_getComponentName($componentId);
		} else {
			$name = $componentId;
		}

		$db = JFactory::getDbo();
		$db->setQuery("SELECT FieldValue FROM #__rsform_submission_values WHERE SubmissionId='".(int) $submissionId."' AND FieldName='".$db->escape($name)."'");
		return $db->loadResult();
	}

	protected function _getSubmissionId($formId, $code){
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->qn('SubmissionId'))
			->from($db->qn('#__rsform_submissions', 's'))
			->where($db->qn('s.FormId') . ' = ' . $db->q($formId))
			->where('MD5(CONCAT(' . $db->qn('s.SubmissionId') . ',' . $db->qn('s.DateSubmitted') . ')) = ' . $db->q($code));
		$db->setQuery($query);

		if ($SubmissionId = $db->loadResult())
		{
			return $SubmissionId;
		};

		return false;
	}

	protected function _getValidationFields(){
		$jinput = JFactory::getApplication()->input;
		$validation_fields = array(
			'amount'         => $jinput->get('mc_gross', '', 'raw'),
			'currency'       => $jinput->get('mc_currency', '', 'raw'),
			'receiver_email' => $jinput->get('business', '', 'raw'),
			'formId'         => $jinput->getInt('formId', ''),
			'code'           => $jinput->get('code', ''),
			'reason'         => $jinput->get('reason_code', ''),
		);

		return $validation_fields;
	}
}

class RSFormProPayPal
{
	public $args = array();
	public $url;

	public static function getInstance() {
		static $inst;
		if (!$inst) {
			$inst = new RSFormProPayPal;
			$inst->url = RSFormProHelper::getConfig('paypal.test') ? 'https://www.paypal.com/cgi-bin/webscr' : 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		}

		return $inst;
	}
}