<?php
/**
* @package RSform!Pro
* @copyright (C) 2015 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * RSForm! Pro system plugin
 */
class plgSystemRSFPPagSeguroPayment extends JPlugin
{
	protected $componentId 	= 502;
	protected $componentValue = 'pagseguro';
	
	public function __construct( &$subject, $config ) {
		parent::__construct( $subject, $config );
		$this->newComponents = array(502);
	}
	
	public function rsfp_bk_onAfterShowComponents() {
		if (!$this->canRun()) { 
			return;
		}
		
		$formId 	= JFactory::getApplication()->input->getInt('formId');
		$link = "displayTemplate('".$this->componentId."')";
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId)) {
			$link = "displayTemplate('".$this->componentId."', '".$components[0]."')";
		}
		?>
		<li><a href="javascript: void(0);" onclick="<?php echo $link;?>;return false;" id="rsfpc<?php echo $this->componentId; ?>"><span class="rsficon rsficon-coin-dollar"></span><span class="inner-text"><?php echo JText::_('RSFP_PAGSEGURO_COMPONENT'); ?></span></a></li>
		<?php
	}
	
	public function rsfp_bk_onAfterCreateComponentPreview($args = array()) {
		if ($args['ComponentTypeName'] == 'pagseguro') {
			$args['out'] = '<td>&nbsp;</td>';
			$args['out'].= '<td><span class="rsficon rsficon-coin-dollar" style="font-size:24px;margin-right:5px"></span> '.$args['data']['LABEL'].'</td>';	
		}
	}
	
	public function rsfp_bk_onAfterShowConfigurationTabs($tabs) {
		if (!$this->canRun()) {
			return;
		}
		
		$tabs->addTitle(JText::_('RSFP_PAGSEGURO_LABEL'), 'form-pagseguro');
		$tabs->addContent($this->pagConfigurationScreen());
	}
	
	protected function pagConfigurationScreen() {
		ob_start(); ?>
		<div id="page-pagseguro" class="com-rsform-css-fix">
			<table  class="admintable">
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="customerid"><?php echo JText::_( 'RSFP_PAGSEGURO_EMAIL' ); ?></label></td>
					<td><input type="text" name="rsformConfig[pagseguro.email]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('pagseguro.email')); ?>" size="100" /></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="username"><?php echo JText::_( 'RSFP_PAGSEGURO_TOKEN' ); ?></label></td>
					<td><input type="text" name="rsformConfig[pagseguro.token]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('pagseguro.token')); ?>" size="100" /></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="mode"><?php echo JText::_( 'RSFP_PAGSEGURO_MODE' ); ?></label></td>
					<td><?php echo RSFormProHelper::renderHTML('select.booleanlist','rsformConfig[pagseguro.mode]','class="inputbox"',RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('pagseguro.mode'))); ?></td>
				</tr>
			</table>
		</div>
		<?php
		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	}
	
	public function rsfp_getPayment(&$items, $formId) {
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId)) {
			$data = RSFormProHelper::getComponentProperties($components[0]);
			
			$item 			= new stdClass();
			$item->value 	= $this->componentValue;
			$item->text 	= $data['LABEL'];
			
			// add to array
			$items[] = $item;
		}
	}
	
	public function rsfp_doPayment($payValue, $formId, $SubmissionId, $price, $products, $code) {
		if (!$this->canRun()) {
			return;
		}
		
		// execute only for our plugin
		if ($payValue != $this->componentValue) return;
		
		if ($price > 0) {
			$app	= JFactory::getApplication();
			$mode	= (int) RSFormProHelper::getConfig('pagseguro.mode');
			$email	= RSFormProHelper::getConfig('pagseguro.email');
			$token	= RSFormProHelper::getConfig('pagseguro.token');
			
			if (!empty($email) && !empty($token)) {
				try {
					require_once JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/pagseguro/PagSeguroLibrary.php';
			
					$enviroment = $mode ? 'production' : 'sandbox';
					PagSeguroConfig::setEnvironment($enviroment);
					
					$paymentRequest = new PagSeguroPaymentRequest();
					$paymentRequest->setCurrency('BRL');
					$paymentRequest->addItem('0001', implode(', ', $products), 1, number_format($price, 2, '.', ''));
					$paymentRequest->setReference($code);
					$paymentRequest->addParameter('notificationURL', JURI::root().'index.php?option=com_rsform&formId='.$formId.'&task=plugin&plugin_task=pagseguro.notify');
					
					$credentials = new PagSeguroAccountCredentials($email, $token);
					$url = $paymentRequest->register($credentials);
					
					$app->redirect($url);
				} catch (PagSeguroServiceException $e) {
					$app->enqueueMessage('PagSeguro: '.$e->getMessage(),'error');
				}
			}
		}
	}
	
	public function rsfp_f_onSwitchTasks() {
		if (!$this->canRun()) {
			return;
		}
		
		$app	= JFactory::getApplication();
		$input	= $app->input;
		$formId	= $input->getInt('formId',0);
		
		if ($input->getString('plugin_task','') == 'pagseguro.notify') {
			$mode	= (int) RSFormProHelper::getConfig('pagseguro.mode');
			$email	= RSFormProHelper::getConfig('pagseguro.email');
			$token	= RSFormProHelper::getConfig('pagseguro.token');
			$code	= $input->getString('notificationCode','');
			$type	= $input->getString('notificationType','');
			
			if (empty($email) || empty($token) || empty($code) || empty($type)) {
				return;
			}
			
			try {
				require_once JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/pagseguro/PagSeguroLibrary.php';
				
				$notificationType = new PagSeguroNotificationType($type);
				$type = $notificationType->getTypeFromValue();
				
				if ($type == 'TRANSACTION') {
					$enviroment = $mode ? 'production' : 'sandbox';
					PagSeguroConfig::setEnvironment($enviroment);
					
					$credentials = new PagSeguroAccountCredentials($email, $token);
					$transaction = PagSeguroNotificationService::checkTransaction($credentials, $code);
					$reff		 = $transaction->getReference();
					
					$statusPagSeguro	= $transaction->getStatus()->getValue();
					$transactionStatus	= new PagSeguroTransactionStatus($statusPagSeguro);
					$status				= $transactionStatus->getTypeFromValue();
					
					if (strtolower($status) == 'paid') {
						$db 	= JFactory::getDBO();
						$db->setQuery("SELECT SubmissionId FROM #__rsform_submissions s WHERE s.FormId='".$formId."' AND MD5(CONCAT(s.SubmissionId,s.DateSubmitted)) = '".$db->escape($reff)."'");
						if ($SubmissionId = $db->loadResult()) {
							$db->setQuery("UPDATE #__rsform_submission_values sv SET sv.FieldValue=1 WHERE sv.FieldName='_STATUS' AND sv.FormId='".$formId."' AND sv.SubmissionId = '".$SubmissionId."'");
							$db->execute();
							
							$app->triggerEvent('rsfp_afterConfirmPayment', array($SubmissionId));
							echo JText::_('RSFP_PAGSEGURO_PAYMENT_ACCEPTED');
							die();
						}
					}
				}
			} catch (PagSeguroServiceException $e) {}
		}
	}
	
	protected function _getFields($formId) {
		$db = JFactory::getDBO();
		$db->setQuery("SELECT p.PropertyValue FROM #__rsform_components c LEFT JOIN #__rsform_properties p ON (c.ComponentId=p.ComponentId) WHERE c.FormId='".(int) $formId."' AND p.PropertyName='NAME' ORDER BY c.Order");
		return $db->loadColumn();
	}
	
	protected function _escapeCommas(&$item) {
		$item = str_replace(',', '\,', $item);
	}
	
	protected function canRun() {
		if (class_exists('RSFormProHelper')) { 
			JFactory::getLanguage()->load('plg_system_rsfppagseguropayment',JPATH_ADMINISTRATOR);
			return true;
		}
		
		$helper = JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/rsform.php';
		if (file_exists($helper)) {
			require_once($helper);
			RSFormProHelper::readConfig();
			JFactory::getLanguage()->load('plg_system_rsfppagseguropayment',JPATH_ADMINISTRATOR);
			return true;
		}
		
		return false;
	}
}