<?php
/**
 * @package       RSform!Pro
 * @copyright (C) 2015 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class plgSystemRSFPEwayPaymentInstallerScript
{
	public function preflight($type, $parent)
	{
		if ($type == 'uninstall')
		{
			return true;
		}
		try
		{
			$source = $parent->getParent()->getPath('source');
			$app    = JFactory::getApplication();

			if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_rsform/helpers/rsform.php'))
			{
				throw new Exception('Please install the RSForm! Pro component before continuing.');
			}

			if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_rsform/helpers/assets.php'))
			{
				throw new Exception('Please upgrade RSForm! Pro to at least version 1.51.0 before continuing!');
			}

			if (!file_exists(JPATH_PLUGINS . '/system/rsfppayment/rsfppayment.php'))
			{
				throw new Exception('Please install the RSForm! Pro Payment Plugin first!');
			}

			if (!version_compare(phpversion(), "5.4.0", ">="))
			{
				throw new Exception('Please upgrade your PHP version to at least version 5.4.0 before continuing!');
			}

			$jversion = new JVersion();
			if (!$jversion->isCompatible('2.5.28'))
			{
				throw new Exception('Please upgrade to at least Joomla! 2.5.28 before continuing!');
			}

			$this->copyFiles($parent);

			// Update? Run our SQL file
			if ($type == 'update')
			{
				$this->copyFiles($parent);
				$this->runSQL($source, 'install');
			}

		} catch (Exception $e)
		{
			JFactory::getApplication()->enqueueMessage($e->getMessage(), 'error');

			return false;
		}

		return true;
	}

	/**
	 * @param $parent
	 */
	protected function copyFiles($parent)
	{
		$app       = JFactory::getApplication();
		$installer = $parent->getParent();

		$files = array(
			'admin' => array(
				'src'  => $installer->getPath('source') . '/admin',
				'dest' => JPATH_ADMINISTRATOR . '/components/com_rsform'
			),
			'site'  => array(
				'src'  => $installer->getPath('source') . '/site',
				'dest' => JPATH_SITE . '/components/com_rsform'
			)
		);

		foreach ($files as $source)
		{
			if (!JFolder::copy($source['src'], $source['dest'], '', true))
			{
				$app->enqueueMessage('Could not copy to ' . str_replace(JPATH_SITE, '', $source['dest']) . ', please make sure destination is writable!', 'error');
			}
		}

	}

	protected function runSQL($source, $file)
	{
		$db     = JFactory::getDbo();
		$driver = strtolower($db->name);
		if (strpos($driver, 'mysql') !== false)
		{
			$driver = 'mysql';
		}
		elseif ($driver == 'sqlsrv')
		{
			$driver = 'sqlazure';
		}

		$sqlfile = $source . '/sql/' . $driver . '/' . $file;

		if (file_exists($sqlfile))
		{
			$buffer = file_get_contents($sqlfile);
			if ($buffer !== false)
			{
				$queries = JInstallerHelper::splitSql($buffer);
				foreach ($queries as $query)
				{
					$query = trim($query);
					if ($query != '' && $query{0} != '#')
					{
						$db->setQuery($query);
						if (!$db->execute())
						{
							JError::raiseWarning(1, JText::sprintf('JLIB_INSTALLER_ERROR_SQL_ERROR', $db->stderr(true)));
						}
					}
				}
			}
		}
	}

	/**
	 * @param $type
	 * @param $parent
	 */
	public function postflight($type, $parent)
	{
		if ($type == 'install')
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->update($db->qn('#__extensions'))
				->set($db->qn('enabled') . ' = ' . $db->q(1))
				->where($db->qn('element') . ' = ' . $db->q('rsfpeway'))
				->where($db->qn('type') . '=' . $db->q('plugin'))
				->where($db->qn('folder') . '=' . $db->q('system'));
			$db->setQuery($query);
			$db->execute();
		}
	}
}