<?php
/**
 * @package       RSform!Pro
 * @copyright (C) 2015 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * RSForm! Pro system plugin
 */
class plgSystemRSFPEwayPayment extends JPlugin
{
	/**
	 * @var int
	 */
	protected $componentId = 501;
	/**
	 * @var string
	 */
	protected $componentValue = 'eway';

	/**
	 * plgSystemRSFPEwayPayment constructor.
	 *
	 * @param object $subject
	 * @param array  $config
	 */
	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
		JFactory::getLanguage()->load('plg_system_rsfpewaypayment', JPATH_ADMINISTRATOR);
		$this->newComponents = array(501);
	}

	/**
	 * @throws Exception
	 */
	public function rsfp_bk_onAfterShowComponents()
	{
		JFactory::getDocument()->addStyleDeclaration('ul.rsform_leftnav li a span#eway { background: url(components/com_rsform/assets/images/icons/eway.png) no-repeat 10px center; }');

		$formId = JFactory::getApplication()->input->getInt('formId');
		$link   = "displayTemplate('" . $this->componentId . "')";
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId))
		{
			$link = "displayTemplate('" . $this->componentId . "', '" . $components[0] . "')";
		}
		?>
		<li>
			<a href="javascript: void(0);" onclick="<?php echo $link; ?>;return false;" id="rsfpc<?php echo $this->componentId; ?>"><span class="rsficon rsficon-coin-dollar"></span><span class="inner-text"><?php echo JText::_('RSFP_EWAY_COMPONENT'); ?></span></a>
		</li>
		<?php
	}

	/**
	 * @param array $args
	 */
	public function rsfp_bk_onAfterCreateComponentPreview($args = array())
	{
		if ($args['ComponentTypeName'] == 'eway')
		{
			$args['out'] = '<td>&nbsp;</td>';
			$args['out'] .= '<td><span class="rsficon rsficon-coin-dollar" style="font-size:24px;margin-right:5px"></span>  ' . $args['data']['LABEL'] . '</td>';
		}
	}

	/**
	 *
	 */
	public function rsfp_bk_onAfterShowFormEditTabsTab()
	{
		echo '<li><a href="javascript: void(0);" id="eway"><span class="rsficon rsficon-coin-dollar"></span><span class="inner-text">' . JText::_('RSFP_EWAY_PAYMENT') . '</span></a></li>';
	}

	/**
	 * @param $form
	 *
	 * @return bool|void
	 * @throws Exception
	 */
	public function rsfp_onFormSave($form)
	{
		$application = JFactory::getApplication();

		try
		{
			$post            = JFactory::getApplication()->input->get('eway', array(), 'array');
			$post['form_id'] = JFactory::getApplication()->input->getInt('formId', 0);
			$row             = JTable::getInstance('RSForm_Eway', 'Table');

			if (!$row)
			{
				throw new Exception ('Could not get an instance of the Eway Table');
			}
			if (!$row->bind($post))
			{
				throw new Exception ('Could not bind data from the Eway Table');
			}

			$row->merge_vars = isset($post['merge_vars']) ? serialize($post['merge_vars']) : '';

			$db    = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select($db->qn('form_id'))
				->from($db->qn('#__rsform_eway'))
				->where($db->qn('form_id') . '=' . $db->q((int) $post['form_id']));
			$db->setQuery($query);
			if (!$db->loadResult())
			{
				$query->clear();
				$query->insert('#__rsform_eway')
					->set($db->qn('form_id') . '=' . $db->q((int) $post['form_id']));
				$db->setQuery($query);
				$db->execute();
			}

			if (!$row->store())
			{
				throw new Exception ('Could not save information to database');
			}

		} catch (Exception $e)
		{
			$application->enqueueMessage($e->getMessage(), 'error');
		}
	}

	public function rsfp_bk_onFormCopy($args){
		$formId = $args['formId'];
		$newFormId = $args['newFormId'];

		if ($row = JTable::getInstance('RSForm_Eway', 'Table') )
		{
			if ($row->load($formId)) {
				$vars = unserialize($row->merge_vars);

				if (isset($vars['form_id'])) {
					$vars['form_id'] = $newFormId;
				}

				if (!$row->bind(array('form_id'=>$newFormId, 'merge_vars'=> serialize($vars)))) {
					JError::raiseWarning(500, $row->getError());
					return false;
				}

				$db 	= JFactory::getDbo();
				$query 	= $db->getQuery(true)
					->select($db->qn('form_id'))
					->from($db->qn('#__rsform_eway'))
					->where($db->qn('form_id').'='.$db->q($newFormId));
				if (!$db->setQuery($query)->loadResult()) {
					$query = $db->getQuery(true)
						->insert($db->qn('#__rsform_eway'))
						->set($db->qn('form_id').'='.$db->q($newFormId));
					$db->setQuery($query)->execute();
				}

				if ($row->store())
				{
					return true;
				}
				else
				{
					JError::raiseWarning(500, $row->getError());

					return false;
				}
			}
		}
	}

	/**
	 * @throws Exception
	 */
	public function rsfp_bk_onAfterShowFormEditTabs()
	{
		$formId = JFactory::getApplication()->input->getInt('formId', 0);
		$row    = JTable::getInstance('RSForm_Eway', 'Table');

		if (!$row)
		{
			return;
		}

		$row->load($formId);
		$row->merge_vars = @unserialize($row->merge_vars);
		if ($row->merge_vars === false)
		{
			$row->merge_vars = array();
		}

		// Fields
		$fields = array();
		if ($array = $this->_getFields($formId))
		{
			$fields[] = JHTML::_('select.option', '', JText::_('RSFP_EWAY_IGNORE'));
			foreach ($array as $field)
			{
				$fields[] = JHTML::_('select.option', $field, $field);
			}
		}

		// Merge Vars
		$merge_vars = array(
			'cardholder' => JText::_('RSFP_EWAY_CARDHOLDER'),
			'creditcard' => JText::_('RSFP_EWAY_CREDITCARD'),
			'expmonth'   => JText::_('RSFP_EWAY_EXPIRATION_MONTH'),
			'expyear'    => JText::_('RSFP_EWAY_EXPIRATION_YEAR'),
			'cscnumber'  => JText::_('RSFP_EWAY_CSC')
		);

		$lists['ew_fields'] = array();
		if (is_array($merge_vars))
		{
			foreach ($merge_vars as $merge_var => $title)
			{
				$lists['ew_fields'][$merge_var] = JHTML::_('select.genericlist', $fields, 'eway[merge_vars][' . $merge_var . ']', null, 'value', 'text', isset($row->merge_vars[$merge_var]) ? $row->merge_vars[$merge_var] : null);
			}
		}
		?>
		<div id="paywaydiv">
			<table class="admintable">
				<tr>
					<td valign="top" align="left" width="100%">
						<table class="table table-bordered">
							<?php
							if (is_array($merge_vars))
							{
								foreach ($merge_vars as $merge_var => $title)
								{
									?>
									<tr>
										<td nowrap="nowrap" width="80" align="right" class="key"><?php echo $title ?></td>
										<td nowrap="nowrap">
											<?php
											echo $lists['ew_fields'][$merge_var];
											if ($merge_var == 'expmonth')
											{
												echo '<span style="margin-left: 15px;">' . JText::_('RSFP_EWAY_MONTH_DESC') . '</span>';
											}
											if ($merge_var == 'expyear')
											{
												echo '<span style="margin-left: 15px;">' . JText::_('RSFP_EWAY_YEAR_DESC') . '</span>';
											}
											?>
										</td>
									</tr>
									<?php
								}
							}
							?>
						</table>
					</td>
					<td valign="top">
						&nbsp;
					</td>
				</tr>
			</table>
		</div>
		<?php
	}

	/**
	 * @param $tabs
	 */
	public function rsfp_bk_onAfterShowConfigurationTabs($tabs)
	{
		$tabs->addTitle(JText::_('RSFP_EWAY_LABEL'), 'form-eway');
		$tabs->addContent($this->ewayConfigurationScreen());
	}

	/**
	 * @return string
	 */
	protected function ewayConfigurationScreen()
	{
		ob_start(); ?>
		<div id="page-eway" class="com-rsform-css-fix">
			<table class="admintable">
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key">
						<label for="username"><?php echo JText::_('RSFP_EWAY_USERNAME'); ?></label></td>
					<td>
						<input type="text" name="rsformConfig[eway.username]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('eway.username')); ?>" size="100" />
					</td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key">
						<label for="password"><?php echo JText::_('RSFP_EWAY_PASSWORD'); ?></label></td>
					<td>
						<input type="password" name="rsformConfig[eway.password]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('eway.password')); ?>" size="100" maxlength="64" />
					</td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key">
						<label for="mode"><?php echo JText::_('RSFP_EWAY_TEST'); ?></label></td>
					<td><?php echo RSFormProHelper::renderHTML('select.booleanlist', 'rsformConfig[eway.test]', 'class="inputbox"', RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('eway.test'))); ?></td>
				</tr>
			</table>
		</div>
		<?php
		$contents = ob_get_contents();
		ob_end_clean();

		return $contents;
	}

	/**
	 * @param $items
	 * @param $formId
	 */
	public function rsfp_getPayment(&$items, $formId)
	{
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId))
		{
			$data = RSFormProHelper::getComponentProperties($components[0]);

			$item        = new stdClass();
			$item->value = $this->componentValue;
			$item->text  = $data['LABEL'];

			// add to array
			$items[] = $item;
		}
	}

	/**
	 * @param $payValue
	 * @param $formId
	 * @param $SubmissionId
	 * @param $price
	 * @param $products
	 * @param $code
	 *
	 * @throws Exception
	 */
	public function rsfp_doPayment($payValue, $formId, $SubmissionId, $price, $products, $code)
	{
		// execute only for our plugin
		if ($payValue != $this->componentValue)
		{
			return;
		}

		if ($price > 0)
		{
			$app   = JFactory::getApplication();
			$db    = JFactory::getDbo();
			$post  =& $args['post'];
			$query = $db->getQuery(true);
			$query->select('*')
				->from($db->qn('#__rsform_eway'))
				->where($db->qn('form_id') . ' = ' . $db->q($formId));
			$db->setQuery($query);
			if ($row = $db->loadObject())
			{
				$post            = $_POST['form'];
				$row->merge_vars = @unserialize($row->merge_vars);
				if ($row->merge_vars === false)
				{
					$row->merge_vars = array();
				}

				$vars          = array();
				$vars['price'] = $price;
				foreach ($row->merge_vars as $tag => $field)
				{
					if (empty($tag))
					{
						continue;
					}

					if (!isset($post[$field]))
					{
						$post[$field] = '';
					}

					if (is_array($post[$field]))
					{
						array_walk($post[$field], array('plgSystemRSFPEwayPayment', '_escapeCommas'));
						$post[$field] = implode(',', $post[$field]);
					}

					$vars[$tag] = $post[$field];
				}

				// Make the payment
				require_once JPATH_ADMINISTRATOR . '/components/com_rsform/helpers/eway/include_eway.php';

				$apiKey      = RSFormProHelper::getConfig('eway.username');
				$apiPassword = RSFormProHelper::getConfig('eway.password');
				$apiEndpoint = \Eway\Rapid\Client::MODE_PRODUCTION;

				if (!(bool) RSFormProHelper::getConfig('eway.test'))
				{
					$apiEndpoint = \Eway\Rapid\Client::MODE_SANDBOX;
				}


				$client = \Eway\Rapid::createClient($apiKey, $apiPassword, $apiEndpoint);

				$payment = array(
					'TotalAmount'   => 100 * number_format($price, 2, '.', ''),
					'InvoiceNumber' => substr($code, 0, 16)
				);

				$transaction = array(
					'Payment'         => $payment,
					'RedirectUrl'     => JUri::root() . 'index.php?option=com_rsform&formId=' . $formId . '&task=plugin&plugin_task=eway.return&internalCode=' . $code,
					'TransactionType' => \Eway\Rapid\Enum\TransactionType::PURCHASE,
					'Capture'         => true,
				);

				// Get a new instance of the Eway object. This is used so that we can programatically change values sent to Eway through the "Scripts" areas.
				$eway = RSFormProEway::getInstance();

				// If any options have already been set, use this to override the ones used here
				$eway->args = array_merge($transaction, $eway->args);


				$response = $client->createTransaction(\Eway\Rapid\Enum\ApiMethod::TRANSPARENT_REDIRECT, $eway->args);
				$errors = $response->getErrors();

				if (empty($errors))
				{
					$data = array(
						'EWAY_CARDNAME'        => $vars['cardholder'],
						'EWAY_CARDNUMBER'      => $vars['creditcard'],
						'EWAY_CARDEXPIRYMONTH' => $vars['expmonth'],
						'EWAY_CARDEXPIRYYEAR'  => $vars['expyear'],
						'EWAY_CARDCVN'         => $vars['cscnumber'],
						'EWAY_ACCESSCODE'      => $response->AccessCode
					);

					?>
					<form method="post" action="<?php echo RSFormProHelper::htmlEscape($response->FormActionURL); ?>" id="payment_form">
						<?php foreach ($data as $key => $value)
						{ ?>
							<input type="hidden" name="<?php echo RSFormProHelper::htmlEscape($key); ?>" value="<?php echo RSFormProHelper::htmlEscape($value); ?>" />
						<?php } ?>
					</form>
					<div class="center">
						<p><?php echo JText::_('RSFP_EWAY_PLEASE_WAIT_WHILE_PROCESSING'); ?></p>
						<p><img src="<?php echo JUri::root(true); ?>/components/com_rsform/assets/images/eway.png"></p>
					</div>
					<style type="text/css">
						.center {
							padding    : 100px;
							text-align : center;
						}
					</style>
					<script type="text/javascript">
						function paymentFormSubmit() {
							window.setTimeout(function () {
								document.getElementById('payment_form').submit();
							}, 5500);
						}
						try {
							window.addEventListener ? window.addEventListener('load', paymentFormSubmit, false) : window.attachEvent('onload', paymentFormSubmit);
						}
						catch (err) {
							paymentFormSubmit();
						}
					</script>
					<?php
					JFactory::getApplication()->close();
				}
			}
		}
	}

	/**
	 * @param $args
	 */
	public function rsfp_f_onBeforeStoreSubmissions($args)
	{
		$db     = JFactory::getDbo();
		$formId = (int) $args['formId'];
		$post   =& $args['post'];
		$query  = $db->getQuery(true);
		$query->select('*')
			->from($db->qn('#__rsform_eway'))
			->where($db->qn('form_id') . ' = ' . $db->q($formId));
		$db->setQuery($query);
		if ($row = $db->loadObject())
		{
			$row->merge_vars = @unserialize($row->merge_vars);
			if ($row->merge_vars === false)
			{
				$row->merge_vars = array();
			}

			foreach ($row->merge_vars as $tag => $field)
			{
				if (empty($tag))
				{
					continue;
				}

				if ($tag == 'creditcard' || $tag == 'expmonth' || $tag == 'expyear' || $tag == 'cscnumber')
				{
					$post[$field] = '';
				}
			}
		}
	}

	/**
	 * @throws Exception
	 */
	public function rsfp_f_onSwitchTasks()
	{
		$input  = JFactory::getApplication()->input;
		$formId = $input->getInt('formId', 0);

		if ($input->getString('plugin_task', '') == 'eway.return')
		{
			$this->ewayReturn($formId, $input->getString('AccessCode', ''), $input->getString('internalCode', ''));
		}
	}

	// Parse the response
	/**
	 * @param $formId
	 * @param $accessCode
	 *
	 * @throws Exception
	 */
	protected function ewayReturn($formId, $accessCode, $internalCode)
	{
		require_once JPATH_ADMINISTRATOR . '/components/com_rsform/helpers/eway/include_eway.php';
		$apiEndpoint = \Eway\Rapid\Client::MODE_PRODUCTION;

		if (!(bool) RSFormProHelper::getConfig('eway.test'))
		{
			$apiEndpoint = \Eway\Rapid\Client::MODE_SANDBOX;
		}


		$client   = \Eway\Rapid::createClient(RSFormProHelper::getConfig('eway.username'), RSFormProHelper::getConfig('eway.password'), $apiEndpoint);
		$response = $client->queryTransaction($accessCode);

		$app               = JFactory::getApplication();
		$transactionStatus = $response->Transactions[0]->getAttribute('TransactionStatus');
		$errors            = $response->getErrors();
		$confirmed         = false;

		if (empty($errors) && $transactionStatus)
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select($db->qn('SubmissionId'))
				->from($db->qn('#__rsform_submissions', 's'))
				->where($db->qn('s.FormId') . ' = ' . $db->q($formId))
				->where('MD5(CONCAT(' . $db->qn('s.SubmissionId') . ',' . $db->qn('s.DateSubmitted') . ')) = ' . $db->q($internalCode));
			$db->setQuery($query);
			if ($SubmissionId = $db->loadResult())
			{
				$query->clear();
				$query->update($db->qn('#__rsform_submission_values'))
					->set($db->qn('FieldValue') . ' = ' . $db->q(1))
					->where($db->qn('FieldName') . ' = ' . $db->q('_STATUS'))
					->where($db->qn('FormId') . ' = ' . $db->q($formId))
					->where($db->qn('SubmissionId') . ' = ' . $db->q($SubmissionId));
				$db->setQuery($query);
				$db->execute();

				$confirmed = true;
				$app->triggerEvent('rsfp_afterConfirmPayment', array($SubmissionId));
			}
		}

		$log = array();
		if (!empty($errors))
		{
			foreach ($errors as $error)
			{
				$log[] = JText::_('RSFP_EWAY_' . \Eway\Rapid::getMessage($error));
			}
		}

		if (!$transactionStatus)
		{
			$errors = explode(', ', $response->Transactions[0]->ResponseMessage);
			foreach ($errors as $error)
			{
				$log[] = JText::_('RSFP_EWAY_' . \Eway\Rapid::getMessage($error));
			}
		}

		$reason = '';
		if (!empty($log))
		{
			$reason = implode('<br />', $log);
		}

		// Get session object
		$session = JFactory::getSession();

		// Get data from session
		$formparams = $session->get('com_rsform.formparams.formId' . $formId);

		if ($formparams && $formparams->redirectUrl)
		{
			// Mark form as processed
			$formparams->formProcessed = true;

			// Store new session data
			$session->set('com_rsform.formparams.formId' . $formId, $formparams);

			$message = array(
				'type' => $confirmed ? 'Notice' : 'error',
			);

			$message['message'] = JText::sprintf('PLG_SYSTEM_RSFPEWAY_TRANSACTION_SUCCESFUL', substr($internalCode, 0,16));

			if (!$confirmed)
			{
				$message['message'] = JText::_($reason);
			}
			// Redirect
			$app->redirect($formparams->redirectUrl, $message['message'], $message['type']);
		}
	}

	/**
	 * @param $formId
	 *
	 * @return mixed
	 */
	protected function _getFields($formId)
	{
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true)
			->select($db->qn('p.PropertyValue'))
			->from($db->qn('#__rsform_components', 'c'))
			->join('LEFT', $db->qn('#__rsform_properties', 'p') . ' ON (' . $db->qn('c.ComponentId') . '=' . $db->qn('p.ComponentId') . ')')
			->where($db->qn('c.FormId') . '=' . $db->q($formId))
			->where($db->qn('p.PropertyName') . '=' . $db->q('NAME'))
			->order($db->qn('c.Order') . ' ' . $db->escape('ASC'));

		return $db->setQuery($query)->loadColumn();
	}

	/**
	 * @param $item
	 */
	protected function _escapeCommas(&$item)
	{
		$item = str_replace(',', '\,', $item);
	}

	/**
	 * @param $formId
	 */
	public function rsfp_onFormDelete($formId)
	{
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->delete('#__rsform_eway')
			->where($db->qn('form_id') . '=' . $db->q($formId));
		$db->setQuery($query)->execute();
	}

	/**
	 * @param $form
	 * @param $xml
	 * @param $fields
	 */
	public function rsfp_onFormBackup($form, $xml, $fields)
	{
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->qn('#__rsform_eway'))
			->where($db->qn('form_id') . '=' . $db->q($form->FormId));
		$db->setQuery($query);
		if ($eway = $db->loadObject())
		{
			// No need for a form_id
			unset($eway->form_id);

			$xml->add('eway');
			foreach ($eway as $property => $value)
			{
				$xml->add($property, $value);
			}
			$xml->add('/eway');
		}
	}

	/**
	 * @param $form
	 * @param $xml
	 * @param $fields
	 */
	public function rsfp_onFormRestore($form, $xml, $fields)
	{
		if (isset($xml->eway))
		{
			$data = array(
				'form_id' => $form->FormId
			);

			foreach ($xml->eway->children() as $property => $value)
			{
				$data[$property] = (string) $value;
			}

			$row = JTable::getInstance('RSForm_Eway', 'Table');

			if (!$row->load($form->FormId))
			{
				$db    = JFactory::getDbo();
				$query = $db->getQuery(true);
				$query->insert('#__rsform_eway')
					->set(array($db->qn('form_id') . '=' . $db->q($form->FormId)));
				$db->setQuery($query)->execute();
			}

			$row->save($data);
		}
	}

	/**
	 *
	 */
	public function rsfp_bk_onFormRestoreTruncate()
	{
		JFactory::getDbo()->truncateTable('#__rsform_eway');
	}
}

class RSFormProEway
{
	public $args = array();

	public static function getInstance() {
		static $inst;
		if (!$inst) {
			$inst = new RSFormProEway;
		}

		return $inst;
	}
}