<?php
/**
* @version		v1.0.0
* @package		Joomla!®
* @copyright	Copyright © 2011 Natural Selection Web Design LLC.
* @support      http://nswd.co
* @license		GNU/GPL, see license.md
*/

defined('_JEXEC') or die('Restricted access');
use Joomla\Registry\Registry as Registry;


class plgSystemNS_Keys_client extends JPlugin
{
	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
	}
	
	public function onAfterRoute(){
		//trick to delete double update links
		if(JFactory::getApplication()->isSite()){
			return true;
		}
		
		$extensions = array('"com_ns_downloadshop"', '"mod_nsmeet"', '"plg_ns_fontawesome_pro_btn"', '"plg_rsfpstripe"', '"plg_rseprostripe"', '"plg_rsmembershipstripe"', '"plg_system_ns_members_login"', '"com_nsnerds"');
		$db = JFactory::getDbo();
		$db = JFactory::getDbo();
		$query = 'SELECT name, COUNT(*) AS sites_num FROM #__update_sites GROUP BY name HAVING name IN (' . implode(',',$extensions) . ')';

		$db->setQuery($query);
		$updateSites = $db->loadObjectList();
		foreach($updateSites as $site){
			if($site->sites_num > 1){
				$query = 'DELETE FROM #__update_sites WHERE name = "'.$site->name.'" AND location LIKE "%key=1"';
				$db->setQuery($query);
				$db->execute();
			}
		}
	}

	public function onExtensionAfterSave($context, $table, $boolean){
		if($context != 'com_config.component' && $context != 'com_plugins.plugin' && $context != 'com_modules.module' && $context != 'com_ns_downloadshop.dashboard' && $context != 'com_nsnerds.intro'){
			return false;
		}
		
		if($context == 'com_ns_downloadshop.dashboard'){
			$component = JFactory::getApplication()->input->get('component');
			$form = JFactory::getApplication()->input->get('jform',array(),'array');
			$key = $form['license_key'];
			
			$params = new Registry();
			$db = JFactory::getDbo();
			$query = 'SELECT params FROM #__extensions WHERE element = "com_ns_downloadshop"';
			$db->setQuery($query);
			$json = $db->loadResult();
			$params->loadString($json,'JSON');
			$params->set('license_key',$key);

			$query = "UPDATE #__extensions SET params = '".$db->escape($params->toString())."' WHERE element = 'com_ns_downloadshop'";
			$db->setQuery($query);
			$db->execute();
			
			$this->setLocation($component,$key);
		}
		
		if($context == 'com_nsnerds.intro'){
			$component = JFactory::getApplication()->input->get('component');
			$form = JFactory::getApplication()->input->get('jform',array(),'array');
			$key = $form['license_key'];
			
			$params = new Registry();
			$db = JFactory::getDbo();
			$query = 'SELECT params FROM #__extensions WHERE element = "com_nsnerds"';
			$db->setQuery($query);
			$json = $db->loadResult();
			$params->loadString($json,'JSON');
			$params->set('license_key',$key);

			$query = "UPDATE #__extensions SET params = '".$db->escape($params->toString())."' WHERE element = 'com_nsnerds'";
			$db->setQuery($query);
			$db->execute();
			
			$this->setLocation($component,$key);
		}
		
		if($context == 'com_config.component'){
			$component = JFactory::getApplication()->input->get('component');
			$form = JFactory::getApplication()->input->get('jform', array(), 'array');
			
			if(!isset($form['license_key'])){
				return false;
			}
			
			$key = $form['license_key'];
			
			$this->setLocation($component,$key);
		}
		
		if($context == 'com_plugins.plugin' || $context == 'com_modules.module'){
			$form = JFactory::getApplication()->input->get('jform', array(), 'array');
			
			if(!isset($form['params']['license_key'])){
				return false;
			}
			
			if($context == 'com_plugins.plugin'){
				$extension = 'plg_'.$form['element'];
			}
			if($context == 'com_modules.module'){
				$extension = $form['module'];
			}
			
			$key = $form['params']['license_key'];
			
			$this->setLocation($extension,$key);
		}		
	}
	
	public function setLocation($extension, $key){
	
		$db = JFactory::getDbo();
		
		$query = 'SELECT location FROM #__update_sites WHERE name="'.$extension.'"';
		$db->setQuery($query);
		$location = $db->loadResult();
		
		$location = preg_replace('/key=.*/','key='.$key, $location);
		$query = 'UPDATE #__update_sites SET location="'.$location.'" WHERE name = "'.$extension.'"';
		$db->setQuery($query);
		$db->execute();			
	}
	
}