<?php
/**
 * @copyright	Copyright (C) 2012 Cedric KEIFLIN alias ced1870
 * http://www.joomlack.fr
 * Module Maximenu CK
 * @license		GNU/GPL
 * version 2.0.3
 * */
// no direct access
defined('_JEXEC') or die('Restricted access');

class modMaximenuckvirtuemartHelper {

	/**
	 * Get a list of the menu items.
	 *
	 * @param	JRegistry	$params	The module options.
	 *
	 * @return	array
	 */
    static function getItems(&$params) {
        jimport('joomla.application.module.helper');
        if (!class_exists( 'VmConfig' )) require_once(JPATH_ADMINISTRATOR.'/components/com_virtuemart/helpers/config.php');
        $config= VmConfig::loadConfig();
		$usevmsuffix = $params->get('usevmsuffix', '0');
		$vmimagesuffix = $params->get('vmimagesuffix', '_mini');
		$usevmimages = $params->get('usevmimages', '0');
		$vmcategoryroot = $params->get('vmcategoryroot', '0');
		$vmcategorydepth = $params->get('vmcategorydepth', '0');
		// $start = $params->get('startLevel', '1');
        // $end = $params->get('endLevel', '10');
        // $dependantitems = $params->get('dependantitems', '0');
		$vmshowall = $params->get('vmshowall', '1');

       $active_path = array();

        $db = JFactory::getDBO();
	
		$query = "SELECT *, #__virtuemart_categories.virtuemart_category_id as id, #__virtuemart_category_categories.category_parent_id as parent, #__virtuemart_categories.ordering as ordering, 1 as level"
                ." FROM (((#__virtuemart_categories"
				." INNER JOIN #__virtuemart_category_categories"
                ." ON #__virtuemart_categories.virtuemart_category_id = #__virtuemart_category_categories.category_child_id)"
				." INNER JOIN #__virtuemart_categories_".VMLANG
                ." ON #__virtuemart_categories.virtuemart_category_id = #__virtuemart_categories_".VMLANG.".virtuemart_category_id)"
				." LEFT OUTER JOIN #__virtuemart_category_medias"
                ." ON #__virtuemart_categories.virtuemart_category_id = #__virtuemart_category_medias.virtuemart_category_id)"
				." LEFT OUTER JOIN #__virtuemart_medias"
                ." ON #__virtuemart_category_medias.virtuemart_media_id = #__virtuemart_medias.virtuemart_media_id"
				." WHERE #__virtuemart_categories.published = 1"
				." ORDER BY parent DESC, #__virtuemart_categories.ordering ASC";

        $db->setQuery($query);

        if ($db->query()) {
            $rows = $db->loadObjectList('id');
        } else {
            echo '<p style="color:red;font-weight:bold;">Error loading SQL data : loading the Virtuemart categories in Maximenu CK</p>';
            return false;
        }
		

        // reverse rows to put level class
        $temprows = array_reverse($rows);
        foreach ($temprows as $row) {
            if ($row->parent != 0) {
                $row->level = $rows[$row->parent]->level + 1;
            }
        }

		$active_category_id = JRequest::getInt('virtuemart_category_id', '0');

        $level = 0;
        $items = array();
        $i = 0;
		$vmcategoryrootitem = new stdClass();
		$vmcategoryrootitem->level = 0;
		$vmcategoryrootitem->enfants = '';
		

        foreach ($rows as $k => &$item) {
		
			
			$showitem = false;
            // saves childs into parents items
            if ($item->level > 1) {

                $rows[$item->parent]->haschild = 'yes';
                if (isset($item->haschild)) {
                    $rows[$item->parent]->enfants.=$item->id . '|' . $item->enfants;
                } else {
                    $rows[$item->parent]->enfants.=$item->id . '|';
                }

                // add parent-child classes
                if (isset($active_category_id) && $active_category_id == $item->id) {
					$active_path[] = $item->id;
                    $j = $item->level;

                    $tempitemID = $item->parent;

                    while ($j != 1) {

                        $rows[$tempitemID]->classe .= " active";
						$active_path[] = $tempitemID ;
                        $tempitemID = $rows[$tempitemID]->parent;

                        $j--;
                    }
                }
				// TODO : confirmer suppression
                // if (isset($item->haschild) AND $params->get('layout', 'default') != '_:flatlist') {
                    // $item->classe .= " parent";
                // }
            }
            // create childs after respective parent
            if ($item->level == 1) { //gestion des droits des parents niveau 0
                $items[$i] = $item;
                if (isset($active_category_id) && $active_category_id == $item->id) {
                    //$item->classe .= " current active";
					$active_path[] = $item->id;
                }
				$item->path = array();
				$item->path[] = $item->id;
                if (isset($item->haschild)) {
					// TODO : confirmer suppression
                    // if ($params->get('layout', 'default') != '_:flatlist') 
						// $item->classe .= " parent";
                    $childs = explode("|", $item->enfants);
                    foreach ($childs as $c) {
                        if ($c) {
                            $i++;
							$item->path[] = $rows[$c]->id;
							$rows[$c]->path = $item->path;                           
                            $items[$i] = $rows[$c];
                        }
                    }
                }
            } else {
                $i--;
            }
			
			
		
		
            $i++;
			
			if ($item->id == $vmcategoryroot) $vmcategoryrootitem = $item;
        }

		$vmcategoryrootitem->enfants = explode("|", $vmcategoryrootitem->enfants);
		$tmpitems = array();
		$j = 0;
        $lastitem = 0;
        foreach ($items as $i => &$item) {

		// check if the item is in the path for the selected root category
			if ( $vmcategoryroot != 0
				AND (
					($item->id == $vmcategoryroot)
					// OR (!in_array($vmcategoryroot, $item->path))
					OR (!in_array($item->id, $vmcategoryrootitem->enfants))
					) 
				) {
				unset($items[$i]);
				continue;
			}

			// check the depth
			if ($vmcategorydepth AND (($item->level - $vmcategoryrootitem->level) > $vmcategorydepth) OR ($item->level <= $vmcategoryrootitem->level) ) {
				unset($items[$i]);
				continue;
			}
		
			$tmpitems[$j] = $item;
			$j++;
			
		}
		
		$items = $tmpitems;
		
		foreach ($items as $i => &$item) {
		
			$item->params = new JRegistry();
			// pour compat avec default.php
			$item->anchor_css = '';
			$item->anchor_title = '';
			$item->type = '';
		
                $item->flink = JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $item->id);

            $item->deeper = false;
            $item->shallower = false;
            $item->level_diff = 0;
			
            if (isset($items[$i-1])) {
                $items[$i-1]->deeper = ($item->level > $items[$i-1]->level);
                $items[$i-1]->shallower = ($item->level < $items[$i-1]->level);
                $items[$i-1]->level_diff = ($items[$i-1]->level - $item->level);
				if ($items[$i-1]->deeper AND $params->get('layout', 'default') != '_:flatlist') $items[$i-1]->classe .= " parent";
            }

			// if ($item->deeper) $item->classe .= " parent";

            

            // test if it is the last item
			$item->is_end = !isset($items[$i + 1]);
				


            // add some classes
            $item->classe .= " item" . $item->id;
            if (isset($active_category_id) && $active_category_id == $item->id) {
                $item->classe .= " current active";
            }


            // search for parameters
            $patterns = "#{maximenu}(.*){/maximenu}#Uis";
            $result = preg_match($patterns, stripslashes($item->category_description), $results);

            $item->desc = '';
            $item->colwidth = '';
            $item->tagcoltitle = 'none';
			$item->tagclass = '';
            $item->leftmargin = '';
            $item->topmargin = '';
			$item->submenuwidth = '';

            if (isset($results[1])) {
                $vmparams = explode('|', $results[1]);
                // $parmsnumb = count($vmparams);
                for ($j = 0; $j < count($vmparams); $j++) {
                    $item->desc = stristr($vmparams[$j], "desc=") ? str_replace('desc=', '', $vmparams[$j]) : $item->desc;
                    $item->colwidth = stristr($vmparams[$j], "col=") ? str_replace('col=', '', $vmparams[$j]) : $item->colwidth;
                    $item->tagcoltitle = stristr($vmparams[$j], "taghtml=") ? str_replace('taghtml=', '', $vmparams[$j]) : $item->tagcoltitle;
					$item->tagclass = stristr($vmparams[$j], "tagclass=") ? ' '.str_replace('tagclass=', '', $vmparams[$j]) : $item->tagclass;
                    $item->leftmargin = stristr($vmparams[$j], "leftmargin=") ? str_replace('leftmargin=', '', $vmparams[$j]) : $item->leftmargin;
                    $item->topmargin = stristr($vmparams[$j], "topmargin=") ? str_replace('topmargin=', '', $vmparams[$j]) : $item->topmargin;
					$item->submenucontainerwidth = stristr($vmparams[$j], "submenuwidth=") ? str_replace('submenuwidth=', '', $vmparams[$j]) : $item->submenuwidth;
					$item->createnewrow = stristr($vmparams[$j], "newrow") ? 1 : 0;
					$item->type = stristr($vmparams[$j], "separator") ? 'separator' : $item->type;
                }
            }

			$item->classe .= $item->tagclass;
			// manage tag encapsulation
			// $item->tagcoltitle = $item->params->set('maximenu_tagcoltitle', $item->taghtml);


            // variables definition
            $item->ftitle = stripslashes(htmlspecialchars($item->category_name));
            $item->content = "";
            $item->rel = "";

			
			
            // manage images
            if (!$usevmsuffix) $vmimagesuffix = '';
            $item->menu_image = '';
            if ($usevmimages) {
				$imageurl = $item->file_url ? explode(".",$item->file_url): '';
				$imagelocation = isset($imageurl[0]) ? $imageurl[0] : '';
				$imageext = isset($imageurl[1]) ? $imageurl[1] : '';
                if (JFile::exists(JPATH_ROOT . '/'. $imagelocation . $vmimagesuffix . '.' . $imageext)) {
					$item->menu_image = $imagelocation . $vmimagesuffix . '.' . $imageext;					
				}
            }
			

			// manage columns
            if ($item->colwidth) {
				$item->colonne = true;
                $parentItem = self::getParentItem($item->parent, $items);

                if (isset($parentItem->submenuswidth)) {
                    $parentItem->submenuswidth = strval($parentItem->submenuswidth) + strval($item->colwidth);
                } else {
                    if (is_object($parentItem)) $parentItem->submenuswidth = strval($item->colwidth);
                }
                if (isset($items[$i-1]) AND $items[$i-1]->deeper) {
					$items[$i-1]->nextcolumnwidth = $item->colwidth;
				}
				$item->columnwidth = $item->colwidth;
            }
			if (isset($parentItem->submenucontainerwidth) AND $parentItem->submenucontainerwidth) $parentItem->submenuswidth = $parentItem->submenucontainerwidth;


            $item->name = $item->ftitle;
			
			// get plugin parameters that are used directly in the layout
			// $item->leftmargin = $item->params->get('maximenu_leftmargin', '');
			// $item->topmargin = $item->params->get('maximenu_topmargin', '');
			$item->liclass = $item->params->get('maximenu_liclass', '');
			$item->colbgcolor = $item->params->get('maximenu_colbgcolor', '');
			
			
				

			
			// $lastitem = $i;
        }
		
		// give the correct deep infos for the last item
		if (isset($items[$i])) {
			// $items[$i]->deeper		= (($start?$start:1) > $items[$i]->level);
			// $items[$i]->shallower	= (($start?$start:1) < $items[$i]->level);
			$items[$i]->level_diff	= ($items[$i]->level - 1 - $vmcategoryrootitem->level);
		}

        return $items;
    }

    function getParentItem($id, $items) {
        foreach ($items as $item) {
            if ($item->id == $id)
                return $item;
        }
    }

}

?>