<?php
/**
 * @package       obGoodies
 * @subpackage    Import from K2 to Joomla! Content
 * @author        Tung Pham - foobla.com
 * @copyright     Copyright (C) 2014 foobla.com. All rights reserved.
 * @license       GNU General Public License version 3 or later; see LICENSE
 */

defined( '_JEXEC' ) or die;

jimport( 'joomla.plugin.plugin' );
jimport( 'joomla.database.tablenested' );

define( 'LOG_CATEGORIES', JPATH_ROOT . DIRECTORY_SEPARATOR . "cache" . DIRECTORY_SEPARATOR . "k2tocontent" . DIRECTORY_SEPARATOR . "catagories.txt" );
define( 'PATH_LOG_CATEGORIES', JPATH_ROOT . DIRECTORY_SEPARATOR . "cache" . DIRECTORY_SEPARATOR . "k2tocontent" );

class PlgSystemK2toContent extends JPlugin {


	var $total = null;

	var $limitdb = null;
	var $end_limit = null;
	var $jump = null;
	var $type = null;
	protected $tagsHelper = null;

	public function __construct( & $subject, $config ) {
		parent::__construct( $subject, $config );

		$this->loadLanguage();
	}

	function onafterDispatch() {
		ob_start();
		$app = JFactory::getApplication();
		if ( !$app->isAdmin() ) {
			return;
		}
		$importcontent = JRequest:: getCmd( 'importcontent' );

		$this->limitdb = JRequest:: getInt( 'limitdb', 0 );
		$this->jump    = JRequest:: getInt( 'jump', 1 );
		$this->type    = JRequest:: getVar( 'type', 'categories' );
		$json          = array();
		if ( $importcontent ) {
			if ( $this->params->get( 'turnoff' ) == 1 ) {
				$this->turn_off_plg();
			}
			if ( trim( $this->type ) == 'categories' ) {
				$this->total_categories = $this->getTotalCategories()->count;

				if ( !$this->limitdb ) {
					$this->remove_all_first();
				}
				if ( $this->limitdb < $this->total_categories ) {
					if ( $this->jump > $this->total_categories ) {
						$this->jump = $this->total_categories;
					}
					if ( !$this->import_content_categories() ) {
						$json['message'] = "categories";
						$json['type']    = 'error';
					} else {
						$json['limit'] = $this->end_limit;
						$json['type']  = 'categories';
					}
					ob_end_clean();
					echo json_encode( $json );
				} else {
					$json['limit'] = 0;
					$json['type']  = 'items';
					ob_end_clean();
					echo json_encode( $json );
				}
			} elseif ( trim( $this->type ) == 'items' ) {
				$this->total = $this->getTotalItems()->count;
				if ( $this->limitdb < $this->total ) {
					if ( $this->jump > $this->total ) {
						$this->jump = $this->total;
					}
					if ( ( $this->limitdb % 1000 ) == 0 ) {
						$this->optimizeTable();
					}
					if ( !$this->import_k2_to_content() ) {
						$json['message'] = "items";
						$json['type']    = 'error';
					} else {
						$json['limit'] = $this->end_limit;
						$json['type']  = 'items';
					}

					ob_end_clean();
					echo json_encode( $json );

				} else {
					$json['limit'] = 0;
					$json['type']  = 'check';
					ob_end_clean();
					echo json_encode( $json );
				}
			} else {
				if ( $this->reBuildAll() ) {
					$json['type'] = 'done';
					ob_end_clean();
					echo json_encode( $json );
				} else {
					$json['type'] = 'error';
					ob_end_clean();
					echo json_encode( $json );
				}

			}
		}
	}

	/**
	 * Import categories from K2 to Content Component
	 */
	protected function import_content_categories() {

		$db    = JFactory::getDbo();
		$jump  = $this->jump;
		$query = "SELECT COUNT(*) FROM #__categories WHERE extension='system' AND alias='root'";
		$db->setQuery( $query );
		$root_category = $db->loadResult();
		if ( !$root_category ) {
			$query = "INSERT INTO `#__categories` VALUES ('1', '0', '0', '0', '205', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1')";
			$db->setQuery( $query );
			$db->execute();
		}
		$query = "SELECT COUNT(*) FROM #__tags WHERE parent_id=0 AND alias='root'";
		$db->setQuery( $query );
		$root_tag = $db->loadResult();
		if ( !$root_tag ) {
			$query = "INSERT INTO `#__tags` VALUES ('1', '0', '0', '1', '0', '', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '', '2011-01-01 00:00:01', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00')";
			$db->setQuery( $query );
			$db->execute();
		}
		if ( $this->limitdb ) {
			$start_limit = $this->limitdb;
			$cal         = $this->total_categories - $start_limit;
			if ( $jump < (int) $cal ) {
				$end_limit = $start_limit + $jump;
			} else {
				$end_limit = $this->total_categories;
			}
			$this->end_limit  = $end_limit;
			$limit_categories = " ORDER BY id LIMIT $start_limit,$jump";
		} else {
			$limit_categories = " ORDER BY id LIMIT 0,$jump";
			$this->end_limit  = $jump;
		}

		$xml = new JXMLElement( JFile::read( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_categories' . DS . 'models' . DS . 'forms' . DS . 'category.xml' ) );
		@$categoryParams = class_exists( 'JParameter' ) ? new JParameter( '' ) : new JRegistry( '' );
		foreach ( $xml->params as $paramGroup ) {
			foreach ( $paramGroup->param as $param ) {
				if ( (string) $param->attributes()->type != 'spacer' && (string) $param->attributes()->name ) {
					$categoryParams->set( (string) $param->attributes()->name, (string) $param->attributes()->default );
				}
			}
		}
//
//		$xml = new JXMLElement( JFile::read( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_content' . DS . 'models' . DS . 'forms' . DS . 'article.xml' ) );
//		@$itemParams = class_exists( 'JParameter' ) ? new JParameter( '' ) : new JRegistry( '' );
//		foreach ( $xml->params as $paramGroup ) {
//			foreach ( $paramGroup->param as $param ) {
//				if ( (string) $param->attributes()->type != 'spacer' && (string) $param->attributes()->name ) {
//					$itemParams->set( (string) $param->attributes()->name, (string) $param->attributes()->default );
//				}
//			}
//		}
//		$itemParams = $itemParams->toString();

		$query = "SELECT * FROM #__k2_categories $limit_categories";

		$db->setQuery( $query );
		$K2categories = $db->loadObjectList();


		//$mapping = array();
		JTable::addIncludePath( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_categories' . DS . 'tables' );
		JTable::addIncludePath( JPATH_SITE . DS . 'components' . DS . 'com_content' . DS . 'tables' );


		//$new_categories = array();
		foreach ( $K2categories as $key => $K2category ) {
			$Category = JTable::getInstance( 'Category', 'JTable', array() );
			if ( isset( $K2category->exist_id ) ) {
				$Category->id = $K2category->exist_id;
			}
			$Category->title       = $K2category->name;
			$Category->alias       = $K2category->alias;
			$Category->path        = $K2category->alias;
			$Category->description = $K2category->description;
			$Category->parent_id   = $K2category->parent;
			if ( $Category->parent_id == 0 ) {
				$Category->parent_id = 1;
				$Category->level     = 1;
			}
			$Category->extension = 'com_content';
			$Category->published = $K2category->published;
			$Category->access    = $K2category->access;

			if ( $K2category->image != '' ) {
				$cate_image = 'images/' . $K2category->image;
				$categoryParams->set( 'image', $cate_image );
			}

			$Category->language = ( isset( $K2category->language ) && $K2category->language != '' ) ? $K2category->language : '*';
			$Category->params   = $categoryParams->toString();
			if ( !$Category->check() ) {
				return false;
			}

			if ( !$Category->store() ) {
				return false;
			}
			$this->setLogCategories( $K2category->id, $Category->id, self::get_level( $K2category->id, 1 ) );

			if ( JFile::exists( JPATH_SITE . DS . 'media' . DS . 'k2' . DS . 'categories' . DS . $K2category->image ) ) {
				JFile::copy( JPATH_SITE . DS . 'media' . DS . 'k2' . DS . 'categories' . DS . $K2category->image, JPATH_SITE . DS . $cate_image );
			}


		}

		return true;
	}

	/**
	 * Import K2 Items to Content's article
	 */
	protected function import_k2_to_content() {

		$db      = JFactory::getDBO();
		$version = new JVersion();
		$obJVer  = $version->getShortVersion();
		$isJ25   = substr( $obJVer, 0, 3 ) == "2.5";

		$jump = $this->jump;
		if ( $this->limitdb ) {
			$start_limit = $this->limitdb;
			$cal         = $this->total - $start_limit;
			if ( $jump < (int) $cal ) {
				$end_limit = $start_limit + $jump;
			} else {
				$end_limit = $this->total;
			}
			$this->end_limit = $end_limit;
			$limit           = " ORDER BY id LIMIT $start_limit,$jump";
		} else {
			$limit           = " ORDER BY id LIMIT 0,$jump";
			$this->end_limit = $jump;
		}

		$new_categories = $this->getLogCategories( true );
		if ( $isJ25 ) {
			$query = "SELECT items.*, user.userID AS k2_userID FROM #__k2_items AS items
						LEFT JOIN #__k2_users AS user ON items.created_by = user.id " . $limit;
		} else {
			$query = "SELECT items.*, GROUP_CONCAT(t.`name`) as tag_name, user.userID AS k2_userID FROM #__k2_items AS items
							LEFT JOIN #__k2_users AS user ON items.created_by = user.id
							LEFT OUTER JOIN #__k2_tags_xref as tx ON tx.itemID = items.id
							LEFT OUTER JOIN #__k2_tags as t ON t.id = tx.tagId
							GROUP BY items.id
							" . $limit;
		}

		$db->setQuery( $query );
		$K2items = $db->loadObjectList();
		if ( count( $K2items ) > 0 ) {
			foreach ( $K2items as $k => $K2item ) {
				$content        = JTable::getInstance( 'Content', 'JTable', array() );
				$content->title = $K2item->title;
				$content->alias = $K2item->alias;

				//Set New Content's Category
				$content->catid = isset( $new_categories[$K2item->catid]['newId'] ) ? $new_categories[$K2item->catid]['newId'] : 0;

				if ( $K2item->trash = 0 ) {
					$content->state = - 2;
				} else {
					$content->state = 1;
				}
				$file_name    = "Image" . $K2item->id;
				$file_code    = md5( $file_name );
				$images_cache = glob( JPATH_SITE . DS . 'media' . DS . 'k2' . DS . 'items' . DS . 'cache' . DS . $file_code . '_*.jpg' );
				if ( JFile::exists( JPATH_SITE . DS . 'media' . DS . 'k2' . DS . 'items' . DS . 'src' . DS . $file_code . '.jpg' ) ) {
					if ( !JFile::exists( JPATH_SITE . DS . 'images' . DS . $file_code . '.jpg' ) ) {
						JFile::copy( JPATH_SITE . DS . 'media' . DS . 'k2' . DS . 'items' . DS . 'src' . DS . $file_code . '.jpg', JPATH_SITE . DS . 'images' . DS . $file_code . '.jpg' );
					}
					$images = class_exists( 'JParameter' ) ? new JParameter( '' ) : new JRegistry( '' );
					$images->set( 'image_intro', 'images/' . $file_code . '.jpg' );
					$images->set( 'float_intro', '' );
					$images->set( 'image_intro_alt', $K2item->image_caption );
					$images->set( 'image_intro_caption', $K2item->image_caption );
					$images->set( 'image_fulltext', 'images/' . $file_code . '.jpg' );
					$images->set( 'float_fulltext', '' );
					$images->set( 'image_fulltext_alt', $K2item->image_caption );
					$images->set( 'image_fulltext_caption', $K2item->image_caption );
				} else {
					if ( count( $images_cache ) > 0 ) {
						JFile::copy( $images_cache[0], JPATH_SITE . DS . 'images' . DS . $file_code . '.jpg' );
						$images = class_exists( 'JParameter' ) ? new JParameter( '' ) : new JRegistry( '' );
						$images->set( 'image_intro', 'images/' . $file_code . '.jpg' );
						$images->set( 'float_intro', '' );
						$images->set( 'image_intro_alt', $K2item->image_caption );
						$images->set( 'image_intro_caption', $K2item->image_caption );
						$images->set( 'image_fulltext', 'images/' . $file_code . '.jpg' );
						$images->set( 'float_fulltext', '' );
						$images->set( 'image_fulltext_alt', $K2item->image_caption );
						$images->set( 'image_fulltext_caption', $K2item->image_caption );
					}
				}
				if ( isset( $images ) ) {
					$content->images = $images->toString();
				}
				$content->featured         = $K2item->featured;
				$content->introtext        = $K2item->introtext;
				$content->fulltext         = $K2item->fulltext;
				$content->created          = $K2item->created;
				//$content->created_by       = $K2item->created_by;
				$content->created_by       = ( $K2item->k2_userID ) ? $K2item->k2_userID : $K2item->created_by;
				$content->created_by_alias = $K2item->created_by_alias;
				$content->modified         = $K2item->modified;
				$content->modified_by      = $K2item->modified_by;
				$content->publish_up       = $K2item->publish_up;
				$content->publish_down     = $K2item->publish_down;
				$content->access           = $K2item->access;
				$content->ordering         = $K2item->ordering;
				$content->hits             = $K2item->hits;
				$content->metadesc         = $K2item->metadesc;
				$content->metadata         = $K2item->metadata;
				$content->metakey          = $K2item->metakey;
				//$content->language         = $K2item->language;
				$content->language          = ( isset( $K2item->language ) && $K2item->language != '' ) ? $K2item->language : '*';
				$content->check();

				if ( !$content_id = $content->store() ) {
					$content->alias = date( "Y-m-d-H-i-s" ) . "-" . $K2item->id;
					if ( !$content->store() ) {
						return false;
					}
				}
				if ( $isJ25 ) {
				} else {
					if ( $K2item->tag_name ) {
						$tags = explode( ',', $K2item->tag_name );
						$tags = array_filter( $tags );
						if ( count( $tags ) > 0 ) {
							foreach ( $tags as $k_t => $v_t ) {

								$v_t        = trim( $v_t );
								$tags[$k_t] = '#new#' . $v_t;
							}
							$tagssave = new JHelperTags;
							$tags     = array_values( $tags );
							$result   = $tagssave->createTagsFromField( $tags );
							if ( count( $result ) > 0 ) {
								$this->storeTags( $result, $content, date( 'Y-m-d H:i:s' ) );
							}
						}
					}
				}
			}
		}

		return true;
	}

	/**
	 * Function rebuild
	 */
	protected function reBuildAll() {
		$db      = JFactory::getDbo();
		$mapping = $this->getLogCategories( true );
		$query   = "SELECT * FROM #__k2_categories";
		$db->setQuery( $query );
		$cates = $db->loadObjectList();
		if ( count( $cates ) > 0 ) {
			foreach ( $cates as $cate ) {
				if ( $mapping[$cate->id]['oldId'] == $cate->id ) {
					$parent = $this->get_parent_k2( $mapping[$cate->id]['oldId'] );

					if ( $parent == 0 || !isset( $parent ) || !$parent ) {
						$parent = 0;
					} else {
						$parent = isset( $mapping[$parent]['newId'] ) && $mapping[$parent]['newId'] ? $mapping[$parent]['newId'] : 0;
					}
					if ( !isset( $mapping[$cate->id]['newId'] ) ) {
						$mapping[$cate->id]['newId'] = 0;
					}
					$query = "UPDATE #__categories SET parent_id=" . $parent . " , level = " . $mapping[$cate->id]['level'] . " WHERE id=" . $mapping[$cate->id]['newId'];
					$db->setQuery( $query );
					$db->query();
				}
			}
		}

		$query = "UPDATE #__categories SET parent_id=1 WHERE parent_id=0 AND extension = 'com_content'";
		$db->setQuery( $query );
		$db->query();

		$rebuild = new JTableNested( '#__categories', 'id', $db );
		$rebuild->rebuild();


		unlink( LOG_CATEGORIES );

		return true;
	}

	function onAfterRender() {
		$app = JFactory::getApplication();
		if ( !$app->isAdmin() ) {
			return;
		}
		$importcontent = JRequest:: getCmd( 'importcontent' );
		$tmpl          = JRequest:: getVar( 'tmpl' );
		if ( trim( $tmpl ) == "component" && ( $importcontent ) ) {
			$buffer = JResponse::getBody();
			$buffer = str_replace( $buffer, "", $buffer );
			JResponse::setBody( $buffer );

		}
	}

	function onBeforeRender() {
		$app = JFactory::getApplication();

		if ( !$app->isAdmin() ) {
			return;
		}

		jimport( 'joomla.html.toolbar' );
//		$japp     = JFactory::getApplication();
		$option    = JRequest:: getCmd( 'option' );
		$view      = JRequest:: getCmd( 'view' );
		$layout    = JRequest:: getCmd( 'layout' );
		$document  = JFactory::getDocument();
		$base_path = JURI::root();
		if ( $option == 'com_content' && $view = 'articles' && $layout == '' ) {
			$total            = $this->getTotalItems()->count;
			$total_categories = $this->getTotalCategories()->count;
			$bar              = JToolBar::getInstance( 'toolbar' );
//			$action = $base_path . "plugins/system/k2tocontent/import/import.php?link_back=" . $base_path;
			$version = new JVersion();
			$obJVer  = $version->getShortVersion();
			$isJ25   = substr( $obJVer, 0, 3 ) == "2.5";
			if ( $isJ25 ) :
				$button = '
					<a onclick="require_again()" id="k2tocontent" href="#loader" class="k2tocontent btn btn-small btn-warning">
						<span class="icon-32-archive" title="Import Joomla! content"></span>
						' . JText::_( 'PLG_SYSTEM_K2TOCONTENT_BTN_LBL' ) . '
					</a>
                    <div class="ob_loader" id="ob_loader" style="display:none">
                        <div class="ball"></div>
                        <div class="ball1">0%</div>
                        <input type="hidden" value="0" class="ob_percent" />
                    </div>
				';
				$document->addScript( '//ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js' );
				$document->addStyleDeclaration( "
					#ob_loader{font-weight: bold;     position: absolute;     top: -18px;     width: 100%;}
					#toolbar-k22content{position:relative}
					.ball {
							background-color: rgba(0,0,0,0);
							border: 5px solid rgba(0,183,229,0.9);
							opacity: .9;
							border-top: 5px solid rgba(0,0,0,0);
							border-left: 5px solid rgba(0,0,0,0);
							border-radius: 50px;
							box-shadow: 0 0 35px #2187e7;
							width: 50px;
							height: 50px;
							margin: 0 auto;
							-moz-animation: spin .5s infinite linear;
							-webkit-animation: spin .5s infinite linear;
						}

						.ball1 {
							color: rgba(0, 183, 229, 0.9);
							font-size: 18px;
							height: 30px;
							left: 10px;
							margin: 0 auto;
							position: absolute;
							text-align: center;
							top: 20px;
							width: 78px;
						}

						@-moz-keyframes spin {
							0% {
								-moz-transform: rotate(0deg);
							}

							100% {
								-moz-transform: rotate(360deg);
							};
						}

						@-moz-keyframes spinoff {
							0% {
								-moz-transform: rotate(0deg);
							}

							100% {
								-moz-transform: rotate(-360deg);
							};
						}

						@-webkit-keyframes spin {
							0% {
								-webkit-transform: rotate(0deg);
							}

							100% {
								-webkit-transform: rotate(360deg);
							};
						}

						@-webkit-keyframes spinoff {
							0% {
								-webkit-transform: rotate(0deg);
							}

							100% {
								-webkit-transform: rotate(-360deg);
							};
						}

				" );
			else :
				$button = '
					<a onclick="require_again()" id="k2tocontent" href="#loader" class="k2tocontent btn btn-small btn-warning">
						<img src="../media/k2/assets/images/system/k2_16x16.png" alt="k2" style="margin-top:-1px" width="16" height="16" />&nbsp;
						' . JText::_( 'PLG_SYSTEM_K2TOCONTENT_BTN_LBL' ) . '
					</a>
                    <div class="ob_loader" id="ob_loader" style="display:none">
                        <div class="ball"></div>
                        <div class="ball1">0%</div>
                        <input type="hidden" value="0" class="ob_percent" />
                    </div>    
				';
				$document->addStyleDeclaration( "
                #ob_loader{font-weight: bold;     position: absolute;     top: -18px;     width: 100%;}
                #toolbar-k22content{position:relative}
                .ball {
                        background-color: rgba(0,0,0,0);
                        border: 5px solid rgba(0,183,229,0.9);
                        opacity: .9;
                        border-top: 5px solid rgba(0,0,0,0);
                        border-left: 5px solid rgba(0,0,0,0);
                        border-radius: 50px;
                        box-shadow: 0 0 35px #2187e7;
                        width: 50px;
                        height: 50px;
                        margin: 0 auto;
                        -moz-animation: spin .5s infinite linear;
                        -webkit-animation: spin .5s infinite linear;
                    }

                    .ball1 {
                        color: rgba(0, 183, 229, 0.9);
                        font-size: 18px;
                        height: 30px;
                        left: 28px;
                        margin: 0 auto;
                        position: absolute;
                        text-align: center;
                        top: 20px;
                        width: 78px;
                    }

                    @-moz-keyframes spin {
                        0% {
                            -moz-transform: rotate(0deg);
                        }

                        100% {
                            -moz-transform: rotate(360deg);
                        };
                    }

                    @-moz-keyframes spinoff {
                        0% {
                            -moz-transform: rotate(0deg);
                        }

                        100% {
                            -moz-transform: rotate(-360deg);
                        };
                    }

                    @-webkit-keyframes spin {
                        0% {
                            -webkit-transform: rotate(0deg);
                        }

                        100% {
                            -webkit-transform: rotate(360deg);
                        };
                    }

                    @-webkit-keyframes spinoff {
                        0% {
                            -webkit-transform: rotate(0deg);
                        }

                        100% {
                            -webkit-transform: rotate(-360deg);
                        };
                    }

            " );
			endif;
			$bar->appendButton( 'Custom', $button, 'k22content' );

			$document->addScriptDeclaration( "
				function require_again() {
					var answer = confirm('" . JText::_( 'PLG_SYSTEM_K2TOCONTENT_WARNING_YOU_ARE_ABOUT_TO_IMPORT_ALL_SECTIONS_CATEGORIES_AND_ARTICLES_FROM_JOOMLAS_K2_COMPONENT_COM_CONTENT_INTO_COM_CONTENT', true ) . "');

					if (!answer) {
						window.event.preventDefault();
					} else{
						ajax_import(0, 50, 'categories');
					}
				}
				function ajax_import(limit, record, itype) {

					var total_items = " . $total . ";
					var total_categories = " . $total_categories . ";
					var total = parseInt(total_items)+parseInt(total_categories);
					var run = 0;
					record = parseInt(record);
					jQuery(document).ready(function () {
						jQuery('#ob_loader').show();
						jQuery.ajax({
							type   : 'POST',
							data   : 'jump=' + record + '&type=' + itype,
							url    : 'index.php?option=com_content&view=articles&importcontent=1&tmpl=component&limitdb=' + limit,
							success: function (html) {
								html = html.trim();
								if (html != '') {
									var obj = jQuery.parseJSON(html);
									if (obj.type != 'done') {
										limit = parseInt(obj.limit);
										run = parseInt(jQuery('.ob_percent').val());
										if(obj.type == 'categories'){
											jQuery('.ob_percent').val(limit);
											//run = limit;
										} else{
											run += limit;
										}
										if(obj.type != 'check'){
											percent = parseInt((run/total)*100);
											jQuery('.ball1').html(percent+'%');
											//setCookie('jump',record,1);
										}
										setTimeout(
										function () {
											ajax_import(limit, record, obj.type);
										}
										,1000);
									} else {
										jQuery('.ob_loader').hide();
										location.reload();
									}
								} else {
									jump = parseInt(record / 2);
									if (jump >= 1) {
										ajax_import(0, jump, 'categories');
									} else {
										alert('Can not import. Please capture screenshot and send us your problem. Website: http://foobla.com');
									}
								}
							},
							error  : function (html) {
								alert('Import is not sucessful because You refresh Please capture screenshot and send us your problem. Website: http://foobla.com');
							}
						});
					});
				}
			" );
		}
	}

	protected function checkexist( $type, $alias ) {
		$db = JFactory::getDBO();
		if ( $type == 'categories' ) {
			$where = ' AND `extension` = "com_content"';
		} else {
			$where = '';
		}
		$sql = 'SELECT id FROM #__' . $type . ' WHERE `alias` = "' . $alias . '"';
		$sql .= $where;
		$db->setQuery( $sql );
		$result = $db->loadResult();
		if ( $result ) {
			return $result;
		} else {
			return false;
		}
	}

	protected function get_parent_id( $id ) {
		$db  = JFactory::getDBO();
		$sql = 'SELECT `parent_id` FROM #__categories WHERE `id` = "' . $id . '"';
		$db->setQuery( $sql );
		$result = $db->loadResult();

		return $result;
	}

	protected function get_parent_k2( $id ) {
		$db  = JFactory::getDBO();
		$sql = 'SELECT parent FROM #__k2_categories WHERE `id` = "' . $id . '"';
		$db->setQuery( $sql );
		$result = $db->loadResult();

		return $result;
	}

	protected function get_level( $id, $level ) {
		$parent_id = self::get_parent_k2( $id );
		if ( $parent_id == 0 ) {
			return $level;
		} else {
			$level ++;

			return self::get_level( $parent_id, $level );
		}

	}

	protected function turn_off_plg() {
		$db  = JFactory::getDBO();
		$sql = 'UPDATE #__extensions SET enabled = 0 WHERE `name` = "plg_system_k2tocontent" AND `type` = "plugin" AND `folder` = "system"';
		$db->setQuery( $sql );
		$db->query();
	}

	protected function remove_all_first() {
		$version = new JVersion();
		$obJVer  = $version->getShortVersion();
		$isJ25   = substr( $obJVer, 0, 3 ) == "2.5";
		$db      = JFactory::getDBO();
		if ( $isJ25 ) {
		} else {
			$sql_tag = "DELETE FROM #__contentitem_tag_map WHERE type_alias = 'com_content.article'";
			$db->setQuery( $sql_tag );
			$db->query();

			$sql_ucm_content = "DELETE FROM #__ucm_content WHERE core_type_alias = 'com_content.article' OR core_type_alias= 'com_content.category'";
			$db->setQuery( $sql_ucm_content );
			$db->query();

			$sql_ucm_base = "DELETE FROM #__ucm_base WHERE ucm_type_id = '1' OR ucm_type_id = '5'";
			$db->setQuery( $sql_ucm_base );
			$db->query();

		}
		/*Delete categories*/
		$sql_cate = "DELETE FROM #__categories WHERE `extension` = 'com_content'";
		$db->setQuery( $sql_cate );
		$db->query();
		/*Delete all contents*/
		$sql_content = "DELETE FROM #__content";
		$db->setQuery( $sql_content );
		$db->query();
		/*Delete all asset of content*/
		$sql_asset = "DELETE FROM #__assets WHERE name LIKE 'com_content.%'";
		$db->setQuery( $sql_asset );
		$db->query();
		/*Reset id*/
		$sql_inc = "ALTER TABLE #__content ENGINE = MYISAM AUTO_INCREMENT = 1";
		$db->setQuery( $sql_inc );
		$db->query();

		$this->optimizeTable();

		/*Reset id*/
		/*
		$sql_categories = "ALTER TABLE #__categories ENGINE = MYISAM AUTO_INCREMENT = 1";
		$db->setQuery( $sql_categories );
		$db->query();*/

		$sql = "UPDATE #__assets SET lft=(id*2)-2, rgt= (lft+1)";
		$db->setQuery( $sql );
		$db->query();
	}

	protected function optimizeTable() {
		$version = new JVersion();
		$obJVer  = $version->getShortVersion();
		$db      = JFactory::getDBO();

		$sql_op = "OPTIMIZE TABLE #__content, #__categories, #__assets ";
		$db->setQuery( $sql_op );
		$db->query();

		$sql_rp = "REPAIR TABLE #__content, #__categories, #__assets ";
		$db->setQuery( $sql_rp );
		$db->query();

		$isJ25 = substr( $obJVer, 0, 3 ) == "2.5";

		if ( $isJ25 ) {
		} else {

			$sql_op = "OPTIMIZE TABLE #__contentitem_tag_map, #__ucm_content, #__ucm_base";
			$db->setQuery( $sql_op );
			$db->query();
		}
	}

	protected function getTotalItems() {
		$db    = JFactory::getDBO();
		$query = "SELECT COUNT(*) AS count FROM #__k2_items";
		$db->setQuery( $query );

		return $db->loadObject();
	}

	protected function getTotalCategories() {
		$db    = JFactory::getDBO();
		$query = "SELECT COUNT(*) AS count FROM #__k2_categories";
		$db->setQuery( $query );

		return $db->loadObject();
	}

	/**
	 * Function get Categories mapping
	 * @return mixed
	 */
	protected function getLogCategories( $assoc = false ) {
		$session      = JFactory::getSession();
		$data_session = $session->get( 'k2categories' );
		if ( $data_session && $this->type != 'categories' ) {
			return $data_session;
		} else {
			@$data = file_get_contents( LOG_CATEGORIES );
			if ( $data ) {
				$array_logs = json_decode( $data, true );
				if ( count( $array_logs ) < 500 ) {

					$session->set( 'k2categories', $array_logs );

					return $array_logs;
				} else {
					return $array_logs;
				}
			}
		}
	}

	/**
	 * Function store log Categories ID to file
	 *
	 * @param $oldId Old K2 Category's Id
	 * @param $newId New Content Category's ID
	 *
	 * @return bool
	 */
	protected function setLogCategories( $oldId, $newId, $level ) {
		if ( !is_dir( PATH_LOG_CATEGORIES ) ) {
			if ( !mkdir( PATH_LOG_CATEGORIES, 0777, true ) ) {
				//echo 'Directory could not be created : ' . $image_folder;
			}
		}

		$data          = array();
		$oldData       = array();
		$data['newId'] = $newId;
		$data['level'] = $level;
		$data['oldId'] = $oldId;
		@$oldData = $this->getLogCategories( true );
		$oldData[$oldId] = $data;

		file_put_contents( LOG_CATEGORIES, json_encode( $oldData ), LOCK_EX );

		return true;
	}

	/**
	 * @param $ids_tag
	 * @param $pk
	 * @param $date
	 * @param $table
	 */
	protected function storeTags( $ids_tag, $table, $date ) {

		$data = $this->getRowData( $table );

		$ucmContentTable = JTable::getInstance( 'Corecontent' );

		$ucm = new JUcmContent( $table, 'com_content.article' );

		$ucmData = $data ? $ucm->mapData( $data ) : $ucm->ucmData;

		$primaryId = $ucm->getPrimaryKey( $ucmData['common']['core_type_id'], $ucmData['common']['core_content_item_id'] );

		$result = $ucmContentTable->load( $primaryId );

		$result = $result && $ucmContentTable->bind( $ucmData['common'] );

		$result          = $result && $ucmContentTable->check();
		$result          = $result && $ucmContentTable->store();
		$core_content_id = $ucmContentTable->core_content_id;
		if ( !$core_content_id ) {
			$core_content_id = 0;
		}


		$db = JFactory::getDBO();
		$pk = $table->id;
		foreach ( $ids_tag as $id_tag ) {
			$sql = "SELECT COUNT(*) FROM `#__contentitem_tag_map` WHERE `type_alias` = 'com_content.article' AND `core_content_id` = {$core_content_id} AND `content_item_id` = {$pk}
					AND `tag_id` = {$id_tag} AND `type_id` = 1";
			$db->setQuery( $sql );
			$result = $db->loadResult();
			if ( $result < 1 ) {
				$sql = "INSERT INTO #__contentitem_tag_map (`type_alias`,`core_content_id`,`content_item_id`,`tag_id`,`type_id`,`tag_date`)
				VALUES ('com_content.article', $core_content_id, $pk, $id_tag, 1, '$date')";
				$db->setQuery( $sql );
				$db->query();
			}
		}
	}

	/**
	 * Gets a row of data from a table
	 *
	 * @param   JTableInterface $table JTable instance for a row.
	 *
	 * @return  array  Associative array of all columns and values for a row in a table.
	 *
	 * @since   3.2
	 */
	public function getRowData( JTableInterface $table ) {
		$fields = $table->getFields();
		$data   = array();

		foreach ( $fields as &$field ) {
			$columnName        = $field->Field;
			$value             = $table->$columnName;
			$data[$columnName] = $value;
		}

		return $data;
	}
}