<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

jimport ( 'joomla.plugin.plugin' );

if (! defined ( 'JSPEED_VERSION' )) {
	$currentVersion = strval ( simplexml_load_file ( JPATH_ROOT . '/plugins/system/jspeed/jspeed.xml' )->version );
	define ( 'JSPEED_VERSION', $currentVersion );
}

include_once (dirname ( __FILE__ ) . '/framework/loader.php');
class plgSystemJSpeed extends JPlugin {
	/**
	 * Gets the name of the current Editor
	 *
	 * @staticvar string $sEditor
	 * @return string
	 */
	protected function excludeEditorViews() {
		$aEditors = JPluginHelper::getPlugin ( 'editors' );

		foreach ( $aEditors as $sEditor ) {
			if (class_exists ( 'plgEditor' . $sEditor->name, false )) {
				return true;
			}
		}

		return false;
	}

	/**
	 *
	 * @return boolean
	 */
	protected function pluginExclusions() {
		$app = JFactory::getApplication ();
		$user = JFactory::getUser ();

		$menuexcluded = $this->params->get ( 'menuexcluded', array () );
		$menuexcludedurl = $this->params->get ( 'menuexcludedurl', array () );
		
		// Check access levels intersection to ensure that users has access
		// Get users access levels based on user groups belonging
		$userAccessLevels = $user->getAuthorisedViewLevels();
		
		// Get chat access level from configuration, if set AKA param != array(0) go on with intersection
		$excludeAccess = false;
		$accessLevels = $this->params->get('pluginaccesslevels', array(0));
		if(is_array($accessLevels) && !in_array(0, $accessLevels, false)) {
			$intersectResult = array_intersect($userAccessLevels, $accessLevels);
			$excludeAccess = (bool)(count($intersectResult));
		}
		
		// Exclude by default the JSitemap bot for images/videos
		if (isset ( $_SERVER ['HTTP_USER_AGENT'] )) {
			$pattern = strtolower ( '/JSitemapbot/i' );
			if (preg_match ( $pattern, $_SERVER ['HTTP_USER_AGENT'] )) {
				$excludeAccess = true;
			}
		}
		// Exclude by default all other documents different than html
		$document = $app->getDocument();
		if($document->getType() !== 'html') {
			$excludeAccess = true;
		}

		return (! $app->isSite() || $excludeAccess || ($app->input->get ( 'jspeedtaskexec', '', 'int' ) == 1) || ($app->get ( 'offline', '0' ) && $user->get ( 'guest' )) || $this->excludeEditorViews () || in_array ( $app->input->get ( 'Itemid', '', 'int' ), $menuexcluded ) || JSpeedHelper::findExcludes ( $menuexcludedurl, JSpeedUri::getInstance ()->toString () ));
	}

	/**
	 * Get the sef string for the current language
	 *
	 * @access public
	 * @return string
	 */
	protected function getCurrentSefLanguage() {
		static $defaultLanguageSef;
		
		$app = JFactory::getApplication();
		
		if($defaultLanguageSef) {
			return $defaultLanguageSef;
		}
		
		$knownLangs = JLanguageHelper::getLanguages();
		
		// Setup predefined site language
		$defaultLanguageCode = $app->getLanguage()->getTag();
		
		foreach ($knownLangs as $knownLang) {
			if($knownLang->lang_code == $defaultLanguageCode) {
				$defaultLanguageSef = $knownLang->sef;
				break;
			}
		}
		
		return $defaultLanguageSef;
	}
	
	/**
	 * Main plugin execution method, here happens the magic and optimizations of the output buffer
	 *
	 * @return boolean
	 * @throws Exception
	 */
	public function onAfterRender() {
		if ($this->pluginExclusions ()) {
			return false;
		}

		$app = JFactory::getApplication ();
		$sHtml = $app->getBody ();

		if (! JSpeedHelper::validateHtml ( $sHtml )) {
			return false;
		}

		if ($app->input->get ( 'jspeedtaskexec' ) == '2') {
			echo $sHtml;
			while ( @ob_end_flush () )
				;
			exit ();
		}

		try {
			JSpeedAutoLoader ( 'JSpeedOptimizer' );

			$sOptimizedHtml = JSpeedOptimizer::optimize ( $this->params, $sHtml );
		} catch ( Exception $e ) {
			$sOptimizedHtml = $sHtml;
		}
		
		if($this->params->get ( 'html_minify_level', 0 ) == 2) {
			$sOptimizedHtml = preg_replace('/.css \/>/i', '.css data-css=""/>',  $sOptimizedHtml);
		}
		
		if ($this->params->get ( 'enable_instant_page', '0' ) && $this->params->get ( 'instant_page_delay', 'fast' ) == 'slow' && ! $this->pluginExclusions ()) {
			$sOptimizedHtml = preg_replace('/<body/i', '<body data-instant-intensity="150"',  $sOptimizedHtml);
		}

		$app->setBody ( $sOptimizedHtml );
	}

	/**
	 * Provide a hash for the default page cache plugin's key based on type of browser detected by Google font
	 *
	 *
	 * @return string $hash Calculated hash of browser type
	 */
	public function onPageCacheGetKey() {
		$browser = JSpeedBrowser::getInstance ();
		$hash = $browser->getFontHash ();
		
		// ADAPTIVE CONTENTS: remove any matched tag for bots
		// Check for user agent exclusion
		if($this->params->get('adaptive_contents_enable', 0)) {
			if (isset ( $_SERVER ['HTTP_USER_AGENT'] )) {
				$user_agent = $_SERVER ['HTTP_USER_AGENT'];
				$botRegexPattern = array();
				$botsList = $this->params->get('adaptive_contents_bots_list', array());
				if (! empty ( $botsList )) {
					foreach ( $botsList as &$bot ) {
						$bot = preg_quote($bot);
					}
					$botRegexPattern = implode('|', $botsList);
				}
				
				$isBot = preg_match("/{$botRegexPattern}/i", $user_agent) || array_key_exists($_SERVER['REMOTE_ADDR'], JSpeedJsonManager::$botsIP);
				if($isBot) {
					$hash = md5($hash . '-AdaptiveBot');
				}
			}
		}

		return $hash;
	}
	
	public function onAfterDispatch() {
		$app = JFactory::getApplication();
		
		// Exclude by menu item
		$lazyLoadExcludeMenuitems = false;
		if (in_array ( $app->input->get ( 'Itemid', '', 'int' ), $this->params->get ( 'excludeLazyLoadMenuitem', array () ) )) {
			$lazyLoadExcludeMenuitems = true;
		}
		
		// Exclude disable always the lazy load of images if the Adaptive Contents is detected
		if($this->params->get('adaptive_contents_enable', 0)) {
			if (isset ( $_SERVER ['HTTP_USER_AGENT'] )) {
				$user_agent = $_SERVER ['HTTP_USER_AGENT'];
				$botRegexPattern = array();
				$botsList = $this->params->get('adaptive_contents_bots_list', array());
				if (! empty ( $botsList )) {
					foreach ( $botsList as &$bot ) {
						$bot = preg_quote($bot);
					}
					$botRegexPattern = implode('|', $botsList);
				}
				
				$isBot = preg_match("/{$botRegexPattern}/i", $user_agent) || array_key_exists($_SERVER['REMOTE_ADDR'], JSpeedJsonManager::$botsIP);
				if($isBot) {
					$this->params->set('lazyload', 0);
					$this->params->set('lazyload_isbot', 1);
				}
			}
		}
		
		if ($this->params->get ( 'lazyload', '0' ) && 
			$this->params->get ( 'lazyload_mode', 'both' ) != 'native' && 
			! $this->pluginExclusions () && 
			!JSpeedHelper::findExcludes($this->params->get('excludeLazyLoadUrl', array()), JSpeedUri::getInstance()->toString()) && !$lazyLoadExcludeMenuitems) {
			JHtml::script ( 'plg_jspeed/lazyload_loader.js', false, true );

			if ($this->params->get ( 'lazyload_effects', 0 )) {
				JHtml::stylesheet ( 'plg_jspeed/lazyload_effects.css', array (), true );
				JHtml::script ( 'plg_jspeed/lazyload_loader_effects.js', false, true );
			}

			// Lazyload autosize in JS mode
			if ($this->params->get ( 'lazyload_autosize', 0 ) == 2) {
				JHtml::script ( 'plg_jspeed/lazyload_autosize.js', false, true );
			}

			JHtml::script ( 'plg_jspeed/lazyload.js', false, true );
		}
		
		// Check if the Instant Page feature is enabled, if so load the script
		if ($this->params->get ( 'enable_instant_page', '0' ) && ! $this->pluginExclusions ()) {
			$app->getDocument()->addScript(JUri::root(true) . '/media/plg_jspeed/js/instantpage-5.1.0.js', 'text/javascript', true);
		}
		
		if($app->isSite()) {
			return;
		}
		$matchTask = false;
		$jSpeedtask = $app->input->getCmd('jspeedtask', null);
		switch ($jSpeedtask) {
			case 'optimizehtaccess' :
				$htaccess = JPATH_ROOT . '/.htaccess';

				if (file_exists ( $htaccess )) {
					$contents = file_get_contents ( $htaccess );
					if (! preg_match ( '@\n?## START JSPEED OPTIMIZATIONS ##.*?## END JSPEED OPTIMIZATIONS ##@s', $contents )) {
						$sExpires = PHP_EOL;
						$sExpires .= '## START JSPEED OPTIMIZATIONS ##' . PHP_EOL;
						$sExpires .= '<IfModule mod_expires.c>' . PHP_EOL;
						$sExpires .= '  ExpiresActive on' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Default' . PHP_EOL;
						$sExpires .= '  ExpiresDefault "access plus 1 year"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Application Cache' . PHP_EOL;
						$sExpires .= '  ExpiresByType text/cache-manifest "access plus 0 seconds"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# HTML Document' . PHP_EOL;
						$sExpires .= '  ExpiresByType text/html "access plus 0 seconds"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Data documents' . PHP_EOL;
						$sExpires .= '  ExpiresByType text/xml "access plus 0 seconds"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/xml "access plus 0 seconds"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/json "access plus 0 seconds"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Feed XML' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/rss+xml "access plus 1 hour"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/atom+xml "access plus 1 hour"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Favicon' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/x-icon "access plus 1 week"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Media: images, video, audio' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/gif "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/png "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/jpg "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/jpeg "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/webp "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType video/ogg "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType audio/ogg "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType video/mp4 "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType video/webm "access plus 1 year"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# X-Component files' . PHP_EOL;
						$sExpires .= '  ExpiresByType text/x-component "access plus 1 year"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# Fonts' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/font-ttf "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType font/opentype "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/font-woff "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/font-woff2 "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType image/svg+xml "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/vnd.ms-fontobject "access plus 1 year"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '# CSS and JavaScript' . PHP_EOL;
						$sExpires .= '  ExpiresByType text/css "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType text/javascript "access plus 1 year"' . PHP_EOL;
						$sExpires .= '  ExpiresByType application/javascript "access plus 1 year"' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '  <IfModule mod_headers.c>' . PHP_EOL;
						$sExpires .= '    Header append Cache-Control "public"' . PHP_EOL;
						$sExpires .= '    <FilesMatch ".(js|css|xml|gz|html)$">' . PHP_EOL;
						$sExpires .= '       Header append Vary: Accept-Encoding' . PHP_EOL;
						$sExpires .= '    </FilesMatch>' . PHP_EOL;
						$sExpires .= '  </IfModule>' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '</IfModule>' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '<IfModule mod_deflate.c>' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE text/html' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE text/css' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE text/javascript' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE text/xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE text/plain' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE image/x-icon' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE image/svg+xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/rss+xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/javascript' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/x-javascript' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/xhtml+xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font-truetype' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font-ttf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font-otf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font-opentype' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font-woff' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/font-woff2' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE application/vnd.ms-fontobject' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE font/ttf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE font/otf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE font/opentype' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE font/woff' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType DEFLATE font/woff2' . PHP_EOL;
						$sExpires .= '# GZip Compression' . PHP_EOL;
						$sExpires .= 'BrowserMatch ^Mozilla/4 gzip-only-text/html' . PHP_EOL;
						$sExpires .= 'BrowserMatch ^Mozilla/4\.0[678] no-gzip' . PHP_EOL;
						$sExpires .= 'BrowserMatch \bMSIE !no-gzip !gzip-only-text/html' . PHP_EOL;
						$sExpires .= '</IfModule>' . PHP_EOL;
						$sExpires .= '' . PHP_EOL;
						$sExpires .= '<IfModule mod_brotli.c>' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS text/html' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS text/css' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS text/javascript' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS text/xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS text/plain' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS image/x-icon' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS image/svg+xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/rss+xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/javascript' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/x-javascript' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/xhtml+xml' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font-truetype' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font-ttf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font-otf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font-opentype' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font-woff' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/font-woff2' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS application/vnd.ms-fontobject' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS font/ttf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS font/otf' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS font/opentype' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS font/woff' . PHP_EOL;
						$sExpires .= 'AddOutputFilterByType BROTLI_COMPRESS font/woff2' . PHP_EOL;
						$sExpires .= '</IfModule>' . PHP_EOL;
						$sExpires .= '## END JSPEED OPTIMIZATIONS ##' . PHP_EOL;

						$writtenFile = file_put_contents ( $htaccess, $sExpires, FILE_APPEND );
						if($writtenFile) {
							$app->enqueueMessage(JText::_('PLG_JSPEED_HTACCESS_SUCCESSFULLY_CONFIGURED'));
						}
					} else {
						$app->enqueueMessage(JText::_('PLG_JSPEED_HTACCESS_ALREADY_CONFIGURED'));
					}
				} else {
					$app->enqueueMessage(JText::_('PLG_JSPEED_HTACCESS_MISSING'));
				}
				
				$matchTask = true;
			break;
			
			case 'restorehtaccess':
				$htaccess = JPATH_ROOT . '/.htaccess';
				if (file_exists ( $htaccess )) {
					$contents = file_get_contents ( $htaccess );
					$regex = '@\n?## START JSPEED OPTIMIZATIONS ##.*?## END JSPEED OPTIMIZATIONS ##@s';
					
					$clean_contents = preg_replace ( $regex, '', $contents, - 1, $count );
					
					if ($count > 0) {
						$writtenFile = file_put_contents ( $htaccess, $clean_contents );
						if($writtenFile) {
							$app->enqueueMessage(JText::_('PLG_JSPEED_HTACCESS_SUCCESSFULLY_RESTORED'));
						}
					} else {
						$app->enqueueMessage(JText::_('PLG_JSPEED_HTACCESS_ALREADY_RESTORED'));
					}
				} else {
					$app->enqueueMessage(JText::_('PLG_JSPEED_HTACCESS_MISSING'));
				}
				
				$matchTask = true;
			break;
				
			case 'clearcache' :
				// Clear all caches, plugin and page cache, additionally trigger plugin and HTTP headers for cache cleaning
				$outputCache = JSpeedCache::getCacheObject ();
				$staticCache = JSpeedCache::getCacheObject ( 'targetcache' );
				$pageCache = JCache::getInstance ();
				$pageCacheRoot = JCache::getInstance ('page', array('cachebase' => JPATH_ROOT . '/cache'));
				$pageCacheAdminRoot = JCache::getInstance ('page', array('cachebase' => JPATH_ROOT . '/administrator/cache'));
				
				if($outputCache->clean ( 'plg_jspeed' ) && $outputCache->clean ( 'plg_jspeed_nowebp' )) {
					$app->enqueueMessage(JText::_('PLG_JSPEED_PLUGIN_CACHE_SUCCESSFULLY_CLEARED'));
				}
				
				if($staticCache->clean ()) {
					$app->enqueueMessage(JText::_('PLG_JSPEED_STATIC_CACHE_SUCCESSFULLY_CLEARED'));
				}

				if($pageCache->clean ( 'page' ) && $pageCacheRoot->clean ( 'page' ) && $pageCacheAdminRoot->clean ( 'page' )) {
					$app->enqueueMessage(JText::_('PLG_JSPEED_PAGE_CACHE_SUCCESSFULLY_CLEARED'));
				}
				
				if(JPluginHelper::getPlugin('system', 'pagecacheextended')) {
					if($pageCache->clean ( 'pce' ) && $pageCacheRoot->clean ( 'pce' ) && $pageCacheAdminRoot->clean ( 'pce' )) {
						$app->enqueueMessage(JText::_('PLG_JSPEED_PAGE_CACHE_PCE_SUCCESSFULLY_CLEARED'));
					}
					
					if($pageCache->clean ( 'pce-gzip' ) && $pageCacheRoot->clean ( 'pce-gzip' ) && $pageCacheAdminRoot->clean ( 'pce-gzip' )) {
						$app->enqueueMessage(JText::_('PLG_JSPEED_PAGE_CACHE_PCE_GZIP_SUCCESSFULLY_CLEARED'));
					}
				}

				// Trigger LiteSpeed cache clearing
				$dispatcher = JEventDispatcher::getInstance ();
				$dispatcher->trigger ( 'onLSCacheExpired' );

				$app->setHeader( 'X-LiteSpeed-Purge', '*' );
				
				if($this->params->get('clear_server_cache', 0)) {
					JSpeedCache::purgeServerCache(JUri::root(false));
					$app->enqueueMessage(JText::_('PLG_JSPEED_SERVER_CACHE_SUCCESSFULLY_CLEARED'));
				}
				
				$matchTask = true;
			break;
		}
		if ($matchTask) {
			$oUri = clone JUri::getInstance ();
			$oUri->delVar ( 'jspeedtask' );
			$app->redirect ( $oUri->toString () );
		}
	}
	
	/**
	 * onAfterRoute handler
	 *
	 * @access	public
	 * @return null
	 */
	public function onAfterRoute() {
		$app = JFactory::getApplication();
		
		// Kill com_joomlaupdate informations about extensions missing updater info, leave only main one
		if($app->getClientId()) {
			$doc = JFactory::getDocument();
			if(version_compare(JVERSION, '3.10', '>=') && version_compare(JVERSION, '4.0', '<') && !$app->get('jextstore_joomlaupdate_script') && $app->input->get('option') == 'com_joomlaupdate' && !$app->input->get('view') && !$app->input->get('task')) {
				$doc->addScriptDeclaration ("
					window.addEventListener('DOMContentLoaded', function(e) {
						if(document.querySelector('#pre-update-check')) {
							var jextensionsIntervalCount = 0;
							var jextensionsIntervalTimer = setInterval(function() {
							    [].slice.call(document.querySelectorAll('#compatibilitytype1 tbody tr td.exname, #preupdatecheckheadings tbody tr[id^=plg_] td:first-child')).forEach(function(td) {
							        let txt = td.innerText;
							        if (txt && txt.toLowerCase().match(/jsitemap|gdpr|responsivizer|jchatsocial|jcomment|jrealtime|jspeed|jredirects|vsutility|visualstyles|visual\sstyles|instant\sfacebook\slogin|instantpaypal|screen\sreader|jspeed|jamp/i)) {
							            td.parentElement.style.display = 'none';
							            td.parentElement.classList.remove('error');
										td.parentElement.classList.add('jextcompatible');
							        }
							    });
								[].slice.call(document.querySelectorAll('#compatibilitytype2 tbody tr td.exname')).forEach(function(td) {
							        let txt = td.innerText;
							        if (txt && txt.toLowerCase().match(/jsitemap|gdpr|responsivizer|jchatsocial|jcomment|jrealtime|jspeed|jredirects|vsutility|visualstyles|visual\sstyles|instant\sfacebook\slogin|instantpaypal|screen\sreader|jspeed|jamp/i)) {
										td.parentElement.classList.remove('error');
										td.parentElement.classList.add('jextcompatible');
							            let smallLabels = td.querySelectorAll(':scope span.label');
										[].slice.call(smallLabels).forEach(function(element) {
								            element.style.display = 'none';
								        });
							        }
							    });
								if (document.querySelectorAll('#compatibilitytype0 tbody tr').length == 0 &&
									document.querySelectorAll('#compatibilitytype1 tbody tr:not(.jextcompatible)').length == 0 &&
									document.querySelectorAll('#compatibilitytype2 tbody tr:not(.jextcompatible)').length == 0) {
							        [].slice.call(document.querySelectorAll('#preupdatecheckbox, #preupdateCheckCompleteProblems')).forEach(function(element) {
							            element.style.display = 'none';
							        });
									if(document.querySelector('#noncoreplugins')) {
										document.querySelector('#noncoreplugins').checked = true;
									}
									if(document.querySelector('button.submitupdate')) {
								        document.querySelector('button.submitupdate').disabled = false;
								        document.querySelector('button.submitupdate').classList.remove('disabled');
									}
							    };
						
								if (document.querySelectorAll('#compatibilitytype0 tbody tr').length == 0 &&
									document.querySelectorAll('#preupdatecheckheadings tbody tr:not(.jextcompatible)').length == 0) {
							        [].slice.call(document.querySelectorAll('#preupdatecheckheadings, #preupdateconfirmation')).forEach(function(element) {
							            element.style.display = 'none';
							        });
							    };
						
								if (document.querySelectorAll('#compatibilitytype0 tbody tr').length == 0) {
									if(document.querySelectorAll('#compatibilitytype1 tbody tr:not(.jextcompatible)').length == 0) {
										let compatibilityTable1 = document.querySelector('#compatibilitytype1');
										if(compatibilityTable1) {
											compatibilityTable1.style.display = 'none';
										}
									}
						
									clearInterval(jextensionsIntervalTimer);
								}
						
							    jextensionsIntervalCount++;
							}, 1000);
						};
					});");
				$app->set('jextstore_joomlaupdate_script', true);
			}
		}
	}

	/**
	 * Event to query the Google PageSpeed Insights API
	 *
	 * @return  void
	 */
	public function onAjaxJspeed() {
		// Ensure that at least a language is available for the backend and locale sent to Google otherwise the API fails
		$language = $this->getCurrentSefLanguage();
		$locale = $language ? $language : 'en';
		$response = new stdClass();
		
		// Build the purified domain to scrape using the host only
		$linkUrl = $this->params->get('pagespeedtest_domain_url', JUri::root(false));
		$hostDomain = rawurlencode ( $linkUrl );
		$customApiKey = trim($this->params->get ( 'google_pagespeed_api_key', ''));
		$apiKey = $customApiKey ? $customApiKey : 'AIzaSyDBN6utYmIBNQ2IVlLcY7-42S9GuKHBIfQ';
		
		$urlDesktop = "https://content.googleapis.com/pagespeedonline/v5/runPagespeed?url=$hostDomain&key=$apiKey&strategy=desktop&category=performance&locale=" . $locale;
		$urlMobile = "https://content.googleapis.com/pagespeedonline/v5/runPagespeed?url=$hostDomain&key=$apiKey&strategy=mobile&category=performance&locale=" . $locale;
		
		try {
			// Fetch remote data to scrape
			$connectionAdapter = JSpeedFileScanner::getInstance ();
			$httpResponseDesktop = $connectionAdapter->getFileContents ( $urlDesktop, null, array (), '', 60);
			$httpResponseMobile = $connectionAdapter->getFileContents ( $urlMobile, null, array (), '', 60);
			
			// Check if HTTP status code is 200 OK
			if ($httpResponseDesktop) {
				$decodedApiResponse = json_decode($httpResponseDesktop, true);
				if(is_array($decodedApiResponse)) {
					// Calculate the score category, range, colors for labels and sliders
					$response->pagespeedDesktop = isset($decodedApiResponse['lighthouseResult']['categories']['performance']) ? (int)($decodedApiResponse['lighthouseResult']['categories']['performance']['score'] * 100) : -1;
					
					$response->fcpDesktop = number_format($decodedApiResponse['lighthouseResult']['audits']['first-contentful-paint']['numericValue'] / 1000, 1);
					$response->siDesktop = number_format($decodedApiResponse['lighthouseResult']['audits']['speed-index']['numericValue'] / 1000, 1);
					$response->lcpDesktop = number_format($decodedApiResponse['lighthouseResult']['audits']['largest-contentful-paint']['numericValue'] / 1000, 1);
					
					$response->interactiveDesktop = number_format($decodedApiResponse['lighthouseResult']['audits']['interactive']['numericValue'] / 1000, 1);
					$response->tbtDesktop = intval($decodedApiResponse['lighthouseResult']['audits']['total-blocking-time']['numericValue']);
					$response->clsDesktop = number_format($decodedApiResponse['lighthouseResult']['audits']['cumulative-layout-shift']['numericValue'], 3);
					
					$response->screenShotDesktop = $decodedApiResponse['lighthouseResult']['audits']['final-screenshot']['details']['data'];
				}
			}
			// Check if HTTP status code is 200 OK
			if ($httpResponseMobile) {
				$decodedApiResponse = json_decode($httpResponseMobile, true);
				if(is_array($decodedApiResponse)) {
					// Calculate the score category, range, colors for labels and sliders
					$response->pagespeedMobile = isset($decodedApiResponse['lighthouseResult']['categories']['performance']) ? (int)($decodedApiResponse['lighthouseResult']['categories']['performance']['score'] * 100) : -1;
					
					$response->fcpMobile = number_format($decodedApiResponse['lighthouseResult']['audits']['first-contentful-paint']['numericValue'] / 1000, 1);
					$response->siMobile = number_format($decodedApiResponse['lighthouseResult']['audits']['speed-index']['numericValue'] / 1000, 1);
					$response->lcpMobile = number_format($decodedApiResponse['lighthouseResult']['audits']['largest-contentful-paint']['numericValue'] / 1000, 1);
					
					$response->interactiveMobile = number_format($decodedApiResponse['lighthouseResult']['audits']['interactive']['numericValue'] / 1000, 1);
					$response->tbtMobile = intval($decodedApiResponse['lighthouseResult']['audits']['total-blocking-time']['numericValue']);
					$response->clsMobile = number_format($decodedApiResponse['lighthouseResult']['audits']['cumulative-layout-shift']['numericValue'], 3);
					
					$response->screenShotMobile = $decodedApiResponse['lighthouseResult']['audits']['final-screenshot']['details']['data'];
				}
			}
			
			$response->analyzedUrl = $linkUrl;
		} catch ( Exception $e ) {
			// Go on with the next API without blocking exception
		}
		
		return $response;
	}
	
	/** Manage the Joomla updater based on the user license
	 *
	 * @access public
	 * @return void
	 */
	public function onInstallerBeforePackageDownload(&$url, &$headers) {
		$uri 	= JUri::getInstance($url);
		$parts 	= explode('/', $uri->getPath());
		$app = JFactory::getApplication();
		if ($uri->getHost() == 'storejextensions.org' && in_array('plg_jspeed.zip', $parts)) {
			// Init as false unless the license is valid
			$validUpdate = false;
			
			// Manage partial language translations
			$jLang = JFactory::getLanguage();
			$jLang->load('plg_system_jspeed', JPATH_ADMINISTRATOR, 'en-GB', true, true);
			
			// Email license validation API call and &$url building construction override
			if(!class_exists('JPluginHelper')) {
				jimport('joomla.plugin.helper');
			}
			$plugin = JPluginHelper::getPlugin('system', 'jspeed');
			$pluginParams = json_decode($plugin->params);
			$registrationEmail = $pluginParams->registration_email;
			
			// License
			if($registrationEmail) {
				$prodCode = 'jspeed';
				$cdFuncUsed = 'str_' . 'ro' . 't' . '13';
				
				// Retrieve license informations from the remote REST API
				$apiResponse = null;
				$apiEndpoint = $cdFuncUsed('uggc' . '://' . 'fgberwrkgrafvbaf' . '.bet') . "/option,com_easycommerce/action,licenseCode/email,$registrationEmail/productcode,$prodCode";
				if (function_exists('curl_init')){
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					$apiResponse = curl_exec($ch);
					curl_close($ch);
				}
				$objectApiResponse = json_decode($apiResponse);
				
				if(!is_object($objectApiResponse)) {
					// Message user about error retrieving license informations
					$app->enqueueMessage(JText::_('PLG_JSPEED_ERROR_RETRIEVING_LICENSE_INFO'));
				} else {
					if(!$objectApiResponse->success) {
						switch ($objectApiResponse->reason) {
							// Message user about the reason the license is not valid
							case 'nomatchingcode':
								$app->enqueueMessage(JText::_('PLG_JSPEED_LICENSE_NOMATCHING'));
								break;
								
							case 'expired':
								// Message user about license expired on $objectApiResponse->expireon
								$app->enqueueMessage(JText::sprintf('PLG_JSPEED_LICENSE_EXPIRED', $objectApiResponse->expireon));
								break;
						}
						
					}
					
					// Valid license found, builds the URL update link and message user about the license expiration validity
					if($objectApiResponse->success) {
						$url = $cdFuncUsed('uggc' . '://' . 'fgberwrkgrafvbaf' . '.bet' . '/WFCRRQ1301TSPQvbnu3243628423ctfcvu35td1ozba09xx6.ugzy');
						
						$validUpdate = true;
						$app->enqueueMessage(JText::sprintf('PLG_JSPEED_EXTENSION_UPDATED_SUCCESS', $objectApiResponse->expireon));
					}
				}
			} else {
				// Message user about missing email license code
				$app->enqueueMessage(JText::_('PLG_JSPEED_MISSING_REGISTRATION_EMAIL_ADDRESS'));
			}
			
			if(!$validUpdate) {
				$app->enqueueMessage(JText::_('PLG_JSPEED_UPDATER_STANDARD_ADVISE'), 'notice');
			}
		}
	}
	
	/**
	 * Override registers Listeners to the Dispatcher
	 * It allows to stop a plugin execution based on the registered listeners
	 *
	 * @override
	 * @return  void
	 */
	public function registerListeners() {
		// Ensure compatibility excluding Joomla 4
		if(version_compare(JVERSION, '4', '>=')) {
			return;
		} elseif (method_exists(get_parent_class($this), 'registerListeners')) {
			parent::registerListeners();
		}
	}
	
	/**
	 */
	public function __construct(& $subject, $config) {
		// Ensure compatibility excluding Joomla 4
		if(version_compare(JVERSION, '4', '>=')) {
			return false;
		}
		
		parent::__construct ( $subject, $config );
	}
}
