<?php
/**
 * Application install script
 * @author Joomla! Extensions Store
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html    
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
jimport ( 'joomla.filesystem.file' );

/** 
 * Application install script class
 */
class PlgsystemJspeedInstallerScript {
	/*
	* Find mimimum required joomla version for this extension. It will be read from the version attribute (install tag) in the manifest file
	*/
	private $minimum_joomla_release = '3.0';
	
	/*
	 * $parent is the class calling this method.
	 * $type is the type of change (install, update or discover_install, not uninstall).
	 * preflight runs before anything else and while the extracted files are in the uploaded temp folder.
	 * If preflight returns false, Joomla will abort the update and undo everything already done.
	 */
	function preflight($type, $parent) {
		// Check for Joomla compatibility
		if(version_compare(JVERSION, '3', '<') || version_compare(JVERSION, '4', '>=')) {
			JFactory::getApplication()->enqueueMessage (JText::sprintf('PLG_JSPEED_INSTALLING_VERSION_NOTCOMPATIBLE', JVERSION), 'error');
			return false;
		}
	}
	
	/*
	 * $parent is the class calling this method.
	 * install runs after the database scripts are executed.
	 * If the extension is new, the install method is run.
	 * If install returns false, Joomla will abort the install and undo everything already done.
	 */
	function install($parent, $isUpdate = false) {
		$database = JFactory::getDBO ();
		echo ('<style type="text/css">div.alert-success, span.step_details {display: none;font-size: 12px;} span.step_details div{margin-top:0 !important;}.installcontainer{width: 720px;}</style>');
		echo ('<link rel="stylesheet" type="text/css" href="' . JUri::root ( true ) . '/administrator/components/com_jspeed/css/bootstrap-install.css' . '" />');
		echo ('<script type="text/javascript" src="' . JUri::root ( true ) . '/administrator/components/com_jspeed/js/installer.js' .'"></script>' );
		
		$parentParent = $parent->getParent();
		
		// Component installer
		$pluginInstaller = JInstaller::getInstance ();
		$pathToAdminComponent = $pluginInstaller->getPath ( 'source' ) . '/component';
		
		echo ('<div class="installcontainer">');
		$componentInstaller = new JInstaller ();
		if (! $componentInstaller->install ( $pathToAdminComponent )) {
			echo '<p>' . JText::_ ( 'PLG_JSPEED_ERROR_INSTALLING_COMPONENT' ) . '</p>';
			// Install failed, rollback changes
			$parentParent->abort(JText::_('PLG_JSPEED_ERROR_INSTALLING_COMPONENT'));
			return false;
		} else {
			// Publish the plugin only on the first install
			if(!$isUpdate) {
				$query = "UPDATE #__extensions" . "\n SET enabled = 1, ordering = 9999" .
						 "\n WHERE type = 'plugin' AND element = " . $database->quote ( 'jspeed' ) .
						 "\n AND folder = " . $database->quote ( 'system' );
				$database->setQuery ( $query );
				if (! $database->execute ()) {
					echo '<p>' . JText::_ ( 'PLG_JSPEED_ERROR_PUBLISHING_PLUGIN' ) . '</p>';
				}
			}
			
			// Kill the component update server
			$query = "DELETE FROM  #__update_sites" .
					 "\n WHERE " . $database->quoteName('location') . " LIKE " . $database->quote ( '%storejextensions.org/updates/dummy.xml%' );
			$database->setQuery ( $query )->execute();

			?>
			<div class="progress">
				<div class="bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100">
					<span class="step_details"><?php echo JText::_('PLG_JSPEED_OK_INSTALLING_COMPONENT');?></span>
				</div>
			</div>
			<?php 
		}
		
		// INSTALL ADMIN MODULE - Current installer instance
		$pathToAdminModule = $pluginInstaller->getPath ( 'source' ) . '/module';
		// New module installer
		$moduleInstaller = new JInstaller ();
		if (! $moduleInstaller->install ( $pathToAdminModule )) {
			echo '<p>' . JText::_ ( 'PLG_JSPEED_ERROR_INSTALLING_ADMIN_MODULE' ) . '</p>';
		} else {
			// Publish the module only on the first install
			if(!$isUpdate) {
				$query = "UPDATE #__modules" .
						 "\n SET " . $database->quoteName('published') . " = 1," .
						 "\n" . $database->quoteName('position') . " = " . $database->quote('cpanel') . "," .
						 "\n" . $database->quoteName('ordering') . " = 999" .
						 "\n WHERE " . $database->quoteName('module') . " = " . $database->quote('mod_jspeed') .
						 "\n AND " . $database->quoteName('client_id') . " = 1";
				$database->setQuery($query);
				if(!$database->execute()) {
					echo JText::_('PLG_JSPEED_ERROR_PUBLISHING_ADMIN_MODULE');
				}
				
				// Publish all pages for default on joomla1.6+
				$query	= $database->getQuery(true);
				$query->select('id');
				$query->from('#__modules');
				$query->where($database->quoteName('module') . '=' . $database->quote('mod_jspeed'));
				$query->where($database->quoteName('client_id') . '= 1');
				
				$database->setQuery($query);
				$lastIDForModule = $database->loadResult();
				
				// Now insert
				try {
					$query	= $database->getQuery(true);
					$query->insert('#__modules_menu');
					$query->set($database->quoteName('moduleid') . '=' . $database->quote($lastIDForModule));
					$query->set($database->quoteName('menuid') . '= 0');
					$database->setQuery($query);
					$database->execute();
				} catch (Exception $e) {
					// Already existing no insert - do nothing all true
				}
			}
			
			?>
			<div class="progress">
				<div class="bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100">
					<span class="step_details"><?php echo JText::_('PLG_JSPEED_OK_INSTALLING_MODULE');?></span>
				</div>
			</div>
			<?php 
		}
		
		?>
		<div class="progress">
			<div class="bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100">
				<span class="step_details"><?php echo JText::_('PLG_JSPEED_OK_INSTALLING_PLUGIN');?></span>
		  	</div>
		</div>
		<?php 
		echo ('</div>');
		
		return true;
	}
	
	/*
	 * $parent is the class calling this method.
	 * update runs after the database scripts are executed.
	 * If the extension exists, then the update method is run.
	 * If this returns false, Joomla will abort the update and undo everything already done.
	 */
	function update($parent) {
		$this->install($parent, true);
	}
	
	
	/*
	 * $parent is the class calling this method
	 * uninstall runs before any other action is taken (file removal or database processing).
	 */
	function uninstall($parent) {
		$database = JFactory::getDBO ();
		 
		// Check if system plugin exists
		$query = "SELECT extension_id" .
				 "\n FROM #__extensions" .
				 "\n WHERE type = 'component' AND element = " . $database->quote('com_jspeed');
		$database->setQuery($query);
		$componentID = $database->loadResult();
		if(!$componentID) {
			echo '<p>' . JText::_('PLG_JSPEED_COMPONENT_ALREADY_REMOVED') . '</p>';
		} else {
			// New plugin installer
			$componentInstaller = new JInstaller ();
			if(!$componentInstaller->uninstall('component', $componentID)) {
				echo '<p>' . JText::_('PLG_JSPEED_ERROR_UNINSTALLING_COMPONENT') . '</p>';
			}
		}
		
		// UNINSTALL ADMIN MODULE - Check if site module exists
		$query = "SELECT extension_id" .
				 "\n FROM #__extensions" .
				 "\n WHERE type = 'module' AND element = " . $database->quote('mod_jspeed') .
				 "\n AND client_id = 1";
		$database->setQuery($query);
		$moduleID = $database->loadResult();
		if(!$moduleID) {
			echo '<p>' . JText::_('PLG_JSPEED_MODULE_ALREADY_REMOVED') . '</p>';
		} else {
			// New module installer
			$moduleInstaller = new JInstaller ();
			if(!$moduleInstaller->uninstall('module', $moduleID)) {
				echo '<p>' . JText::_('PLG_JSPEED_ERROR_UNINSTALLING_MODULE') . '</p>';
			}
		}
		
		// Uninstall complete
		return true;
	}
}