<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class JSpeedUtilities {
	/**
	 *
	 * @return \JCrypt
	 */
	private static function getCrypt() {
		$crypt = new JCrypt ();
		$conf = JFactory::getConfig ();

		$key = new JCryptKey ( 'simple' );

		$key->private = $conf->get ( 'secret' );
		$key->public = $key->private;

		$crypt->setKey ( $key );

		return $crypt;
	}

	/**
	 *
	 * @param type $text
	 * @return type
	 */
	public static function translate($text) {
		if (strlen ( $text ) > 20) {
			$text = substr ( $text, 0, strpos ( wordwrap ( $text, 20 ), "\n" ) );
		}

		$text = 'PLG_JSPEED_' . strtoupper ( str_replace ( ' ', '_', $text ) );

		return JText::_ ( $text );
	}

	/**
	 *
	 * @return type
	 */
	public static function isMsieLT10() {
		jimport ( 'joomla.environment.browser' );
		$oBrowser = JBrowser::getInstance ();

		return (($oBrowser->getBrowser () == 'msie') && ($oBrowser->getMajor () <= '9'));
	}

	/**
	 *
	 * @param type $time
	 * @param type $timezone
	 * @return type
	 */
	public static function unixCurrentDate() {
		return JFactory::getDate ( 'now', 'GMT' )->toUnix ();
	}

	/**
	 *
	 * @param type $url
	 * @return type
	 */
	public static function loadAsync($url) {
		return;
	}

	/**
	 *
	 * @return type
	 */
	public static function lnEnd() {
		$oDocument = JFactory::getDocument ();

		return $oDocument->_getLineEnd ();
	}

	/**
	 *
	 * @return type
	 */
	public static function tab() {
		$oDocument = JFactory::getDocument ();

		return $oDocument->_getTab ();
	}

	/**
	 *
	 * @param type $path
	 */
	public static function createFolder($path) {
		jimport ( 'joomla.filesystem.folder' );

		return JFolder::create ( $path );
	}

	/**
	 *
	 * @param type $file
	 * @param type $contents
	 */
	public static function write($file, $contents) {
		jimport ( 'joomla.filesystem.file' );

		return JFile::write ( $file, $contents );
	}

	/**
	 *
	 * @param type $value
	 * @return type
	 */
	public static function decrypt($value) {
		$crypt = self::getCrypt ();

		return $crypt->decrypt ( $value );
	}

	/**
	 *
	 * @param type $value
	 * @return type
	 */
	public static function encrypt($value) {
		$crypt = self::getCrypt ();

		return $crypt->encrypt ( $value );
	}

	/**
	 *
	 * @param type $value
	 * @param type $default
	 * @param type $filter
	 * @param type $method
	 */
	public static function get($value, $default = '', $filter = 'cmd', $method = 'request') {
		$input = new JInput ();

		return $input->$method->get ( $value, $default, $filter );
	}

	/**
	 *
	 * @return type
	 */
	public static function getLogsPath() {
		$config = JFactory::getConfig ();

		return $config->get ( 'log_path' );
	}

	/**
	 */
	public static function menuId() {
		return JSpeedUtilities::get ( 'Itemid' );
	}

	/**
	 *
	 * @param string $path
	 *        	Path of folder to read
	 * @param string $filter
	 *        	A regex filter for file names
	 * @param boolean $recurse
	 *        	True to recurse into sub-folders
	 * @param array $exclude
	 *        	An array of files to exclude
	 *        	
	 * @return array Full paths of files in the folder recursively
	 */
	public static function lsFiles($path, $filter = '.', $recurse = true, $exclude = array ()) {
		jimport ( 'joomla.filesystem.folder' );

		$path = rtrim ( $path, '/\\' );

		return JFolder::files ( $path, $filter, $recurse, true, $exclude );
	}

	/**
	 */
	public static function isGuest() {
	}

	/**
	 */
	public static function sendHeaders($headers) {
		// print_r($headers); exit();
		if (! empty ( $headers )) {
			$app = JFactory::getApplication ();

			foreach ( $headers as $header => $value ) {
				$app->setHeader ( $header, $value, true );
			}
		}
	}
}
