<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class JSpeedPaths {

	/**
	 *
	 * @return type
	 */
	public static function assetPath($pathonly = false) {
		$sBaseFolder = JSpeedHelper::getBaseFolder ();

		return $sBaseFolder . 'media/plg_jspeed/assets';
	}

	/**
	 */
	public static function cachePath($rootrelative = true) {
		$sCache = 'media/plg_jspeed/cache';

		if ($rootrelative) {
			return JSpeedHelper::getBaseFolder () . $sCache;
		} else {
			return self::rootPath () . $sCache;
		}
	}

	/**
	 *
	 * @return type
	 */
	public static function spriteDir($url = false) {
		if ($url) {
			static $sBaseUrl = '';

			$sBaseUrl = JSpeedHelper::getBaseFolder ();

			return $sBaseUrl . 'images/jspeed/';
		}

		return JPATH_ROOT . '/images/jspeed';
	}

	/**
	 *
	 * @param type $url
	 * @return type
	 */
	public static function absolutePath($url) {
		return JPATH_ROOT . DIRECTORY_SEPARATOR . ltrim ( str_replace ( '/', DIRECTORY_SEPARATOR, $url ), '\\/' );
	}

	/**
	 *
	 * @return type
	 */
	public static function rewriteBase() {
		return JSpeedHelper::getBaseFolder ();
	}

	/**
	 *
	 * @param type $sPath
	 */
	public static function path2Url($sPath) {
		$oUri = clone JUri::getInstance ();
		$sUriPath = $oUri->toString ( array (
				'scheme',
				'user',
				'pass',
				'host',
				'port'
		) ) . self::rewriteBase () . JSpeedHelper::strReplace ( JPATH_ROOT . DIRECTORY_SEPARATOR, '', $sPath );

		return $sUriPath;
	}

	/**
	 *
	 * @param type $function
	 */
	public static function ajaxUrl($function) {
		$url = JUri::getInstance ()->toString ( array (
				'scheme',
				'user',
				'pass',
				'host',
				'port'
		) );
		$url .= JSpeedHelper::getBaseFolder ();
		$url .= 'index.php?option=com_ajax&plugin=' . $function . '&format=raw';

		return $url;
	}

	/**
	 */
	public static function rootPath() {
		return JPATH_ROOT . '/';
	}

	/**
	 */
	public static function adminController($name) {
		return JURI::getInstance ()->toString () . '&amp;task=' . $name;
	}

	/**
	 *
	 * @return string
	 */
	public static function backupImagesParentFolder() {
		return self::rootPath () . 'images/';
	}

	/**
	 *
	 * @return type
	 */
	public static function cacheFolder() {
		return 'cache/plg_jspeed/';
	}
}
