<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

class JSpeedHttp {
	protected $oHttpAdapter = false;

	/**
	 *
	 * @param type $sPath
	 * @param type $aPost
	 * @return type
	 * @throws Exception
	 */
	public function request($sPath, $aPost = null, $aHeaders = null, $sUserAgent = '', $timeout = 5) {
		if (! $this->oHttpAdapter) {
			throw new BadFunctionCallException ( JSpeedUtilities::translate ( 'No HTTP Adapter present' ) );
		}

		$oUri = JUri::getInstance ( $sPath );

		$method = ! isset ( $aPost ) ? 'GET' : 'POST';

		$oResponse = $this->oHttpAdapter->request ( $method, $oUri, $aPost, $aHeaders, $timeout, $sUserAgent );

		$return = array (
				'body' => $oResponse->body,
				'code' => $oResponse->code
		);

		return $return;
	}

	/**
	 */
	public function available() {
		return $this->oHttpAdapter;
	}

	/**
	 */
	public function __construct($aDrivers) {
		jimport ( 'joomla.http.factory' );

		$aOptions = array ();

		if (empty ( ini_get ( 'open_basedir' ) )) {
			$aOptions ['follow_location'] = true;
		}

		$oOptions = new JRegistry ( $aOptions );

		$this->oHttpAdapter = JHttpFactory::getAvailableDriver ( $oOptions, $aDrivers );
	}
}
