<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class JSpeedCache {
	/* Array of instances of cache objects */
	protected static $aCacheObject = array ();
	/**
	 *
	 * @param type $id
	 * @param type $lifetime
	 * @return type
	 */
	public static function getCache($id, $checkexpire = false) {
		$oCache = self::getCacheObject (); // Output cache implicit
		$aCache = $oCache->get ( $id );

		if ($aCache === false) {
			return false;
		}

		return $aCache ['result'];
	}

	/**
	 *
	 * @param type $id
	 * @param type $lifetime
	 * @param type $function
	 * @param type $args
	 * @return type
	 */
	public static function getCallbackCache($id, $function, $args) {
		$oCache = self::getCacheObject ( 'callback' ); // Callback cache
		$oCache->get ( $function, $args, $id );

		// Joomla! doesn't check if the cache is stored so we gotta check ourselves
		$aCache = self::getCache ( $id );

		if ($aCache === false) {
			$oCache->clean ( 'plg_jspeed' );
			$oCache->clean ( 'plg_jspeed_nowebp' );
		}

		return $aCache;
	}

	/**
	 *
	 * @param type $type
	 * @return type
	 */
	public static function getCacheObject($argtype = 'output') {
		if (empty ( self::$aCacheObject [$argtype] )) {
			$cachebase = JPATH_SITE . '/cache';
			$group = 'plg_jspeed';
			$type = $argtype;
			
			// Override force mode if all images must be converted to WEBP
			$params = JSpeedPlugin::getPluginParams ();
			$jSpeedBrowser = JSpeedBrowser::getInstance()->getBrowser ();
			if(	$params->get('combine_files_enable', 0) &&
				$params->get('css', 1) &&
				$params->get('lightimgs_status', 0) &&
				$params->get('convert_all_images_to_webp', 0) &&
				version_compare(PHP_VERSION, '5.4', '>=') &&
				function_exists('imagewebp') &&
				($jSpeedBrowser == 'Safari' || $jSpeedBrowser == 'IE')) {
				$group = 'plg_jspeed_nowebp';
			}

			if ($argtype == 'targetcache') { // Output cache implicit
				$cachebase = JSpeedPaths::cachePath ( false );
				$type = 'output';
				$group = '';
			}

			if ($argtype == 'sourcecache') { // Output cache implicit
				$cachebase = JPATH_SITE . '/cache/plg_jspeed';
				$type = 'output';
				$group = '';
			}

			if (! file_exists ( $cachebase )) {
				JSpeedUtilities::createFolder ( $cachebase );
			}

			$aOptions = array (
					'defaultgroup' => $group,
					'checkTime' => true,
					'application' => 'site',
					'language' => 'en-GB',
					'cachebase' => $cachebase,
					'storage' => 'file'
			);

			$oCache = JCache::getInstance ( $type, $aOptions );

			$oCache->setCaching ( true );
			$oCache->setLifeTime ( self::getLifetime () );

			self::$aCacheObject [$argtype] = $oCache;
		}

		return self::$aCacheObject [$argtype];
	}
	protected static function getLifetime() {
		static $lifetime;

		if (! $lifetime) {
			$params = JSpeedPlugin::getPluginParams ();

			$lifetime = $params->get ( 'cache_lifetime', '60' );
		}

		return ( int ) $lifetime;
	}

	/**
	 *
	 * @param type $lifetime
	 */
	public static function gc() {
		$oCache = self::getCacheObject ( 'sourcecache' );
		$oCache->gc ();

		$oStaticCache = self::getCacheObject ( 'targetcache' );
		$oStaticCache->gc ();

		// Only delete page cache
		self::deleteCache ( true );
	}

	/**
	 */
	public static function saveCache($content, $id) {
		$oCache = self::getCacheObject ();
		$oCache->store ( array (
				'result' => $content
		), $id );
	}

	/**
	 */
	public static function deleteCache($page = false) {
		$return = false;

		// Don't delete if we're only deleting page cache
		if (! $page) {
			$cacheObject = JSpeedCache::getCacheObject (); // Output cache implicit
			$oStaticCache = JSpeedCache::getCacheObject ( 'targetcache' ); // Output cache implicit

			$return |= $cacheObject->clean ( 'plg_jspeed' );
			$return |= $cacheObject->clean ( 'plg_jspeed_nowebp' );
			$return |= $oStaticCache->clean ();
		}

		$oJCache = JCache::getInstance ();

		$return |= $oJCache->clean ( 'page' );

		if(JPluginHelper::getPlugin('system', 'pagecacheextended')) {
			$return |= $oJCache->clean ( 'pce' );
			$return |= $oJCache->clean ( 'pce-gzip' );
		}
		
		// Clean LiteSpeed cache if any installed
		$dispatcher = JEventDispatcher::getInstance ();
		$dispatcher->trigger ( 'onLSCacheExpired' );

		header ( 'X-LiteSpeed-Purge: *' );
		
		if(JSpeedPlugin::getPluginParams()->get('clear_server_cache', 0)) {
			self::purgeServerCache(JUri::current());
		}

		return ( bool ) $return;
	}
	
	public static function purgeServerCache($url) {
		$urlFormatted = self::getUrl ( $url );
		$curl = curl_init ();
		curl_setopt ( $curl, CURLOPT_USERAGENT, 'joomla_purgeCache' );
		curl_setopt ( $curl, CURLOPT_CUSTOMREQUEST, "PURGE" );
		curl_setopt ( $curl, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt ( $curl, CURLOPT_HTTPHEADER, array (
				'Host: ' . $urlFormatted ['hostname']
		) );
		curl_setopt ( $curl, CURLOPT_SSL_VERIFYHOST, false );
		curl_setopt ( $curl, CURLOPT_SSL_VERIFYPEER, false );
		curl_setopt ( $curl, CURLOPT_CONNECTTIMEOUT, 200);
		curl_setopt ( $curl, CURLOPT_TIMEOUT, 200); //timeout in seconds
		curl_setopt ( $curl, CURLOPT_URL, $urlFormatted ['url'] );
		$response = curl_exec ( $curl );
		curl_close ( $curl );
		return true;
	}
	
	protected static function getUrl($url) {
		$parsedUrl = parse_url ( $url );
		$hostname = $parsedUrl ['host'];
		$address = gethostbyname ( $hostname );
		$url = $parsedUrl ['scheme'] . '://' . $address;
		if (isset($parsedUrl ['port']) && $parsedUrl ['port']) {
			$url .= ':' . $parsedUrl ['port'];
		}
		if (isset($parsedUrl ['path']) && $parsedUrl ['path']) {
			$url .= $parsedUrl ['path'];
		}
		if (isset($parsedUrl ['query']) && $parsedUrl ['query']) {
			$url .= '?' . $parsedUrl ['query'];
		}
		if (isset($parsedUrl ['fragment']) && $parsedUrl ['fragment']) {
			$url .= '#' . $parsedUrl ['fragment'];
		}
		return array (
				'url' => $url,
				'hostname' => $hostname
		);
	}
}
