<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();
JFormHelper::loadFieldClass('range');

class JFormFieldRangeslider extends JFormFieldRange {
	public $type = 'rangeslider';

	/**
	 *
	 * @return type
	 */
	protected function getInput() {
		$doc = JFactory::getDocument ();
		
		// Include jQuery/Bootstrap framework
		$doc->addScript( JUri::root(true) . '/media/plg_jspeed/js/autoconfiguration.js' );
		$doc->addStyleSheet ( JUri::root(true) . '/media/plg_jspeed/css/autoconfiguration.css' );
		
		$rangeSlider = '<div id="rangecontainer">';
		$rangeSlider .= parent::getInput ();
		$rangeSlider .= '<div id="rangelabels">' .
							'<span data-container-label="0"><span class="innerlabel" data-label="0">' . JText::_('PLG_JSPEED_AUTO_CONFIGURATION_CUSTOM') . '</span></span>' . 
							'<span data-container-label="1"><span class="innerlabel" data-label="1">' . JText::_('PLG_JSPEED_AUTO_CONFIGURATION_MINIMUM') . '</span></span>' . 
							'<span data-container-label="2"><span class="innerlabel" data-label="2">' . JText::_('PLG_JSPEED_AUTO_CONFIGURATION_STANDARD') . '</span></span>' .
							'<span data-container-label="3"><span class="innerlabel" data-label="3">' . JText::_('PLG_JSPEED_AUTO_CONFIGURATION_AVERAGE') . '</span></span>' .
							'<span data-container-label="4"><span class="innerlabel" data-label="4">' . JText::_('PLG_JSPEED_AUTO_CONFIGURATION_ADVANCED') . '</span></span>' .
							'<span data-container-label="5"><span class="innerlabel" data-label="5">' . JText::_('PLG_JSPEED_AUTO_CONFIGURATION_MAXIMUM') . '</span></span>' .
						'</div>';
		$rangeSlider .= '</div>';
		$rangeSlider .= '<div id="optimizationslist" class="mt-2 border"></div>';
		
		return $rangeSlider;
	}
}
