<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();

class JFormFieldPagespeedtest extends JFormFieldText {
	public $type = 'pagespeedtest';
	
	/**
	 * Inject language constant into JS Domain maintaining same name mapping
	 *
	 * @access protected
	 * @param $translations array
	 * @param $doc Object&
	 * @return void
	 */
	private function injectJsTranslations($translations, $doc) {
		$jsInject = null;
		// Do translations
		foreach ( $translations as $translation ) {
			$jsTranslation = strtoupper ( $translation );
			$translated = JText::_ ( $jsTranslation, true );
			$jsInject .= <<<JS
							var $translation = '{$translated}';
JS;
		}
		$doc->addScriptDeclaration ( $jsInject );
	}
	
	/**
	 *
	 * @return type
	 */
	protected function getInput() {
		$doc = JFactory::getDocument ();
		
		$this->injectJsTranslations(array(
				'PLG_JSPEED_AUTO_CONFIGURATION_MOBILE',
				'PLG_JSPEED_AUTO_CONFIGURATION_DESKTOP',
				'PLG_JSPEED_AUTO_CONFIGURATION_FCP',
				'PLG_JSPEED_AUTO_CONFIGURATION_SI',
				'PLG_JSPEED_AUTO_CONFIGURATION_LCP',
				'PLG_JSPEED_AUTO_CONFIGURATION_TTI',
				'PLG_JSPEED_AUTO_CONFIGURATION_TBT',
				'PLG_JSPEED_AUTO_CONFIGURATION_CLS',
				'PLG_JSPEED_AUTO_CONFIGURATION_SCREENSHOT',
				'PLG_JSPEED_AUTO_CONFIGURATION_MISSINGDATA',
				'PLG_JSPEED_AUTO_CONFIGURATION_ERROR_RETRIEVING'
		), $doc);
		
		$doc->addStyleSheet( JUri::root(true) . '/media/plg_jspeed/css/pagespeed.css' );
		
		$pageSpeedLink = JUri::root(false) . 'administrator/index.php?option=com_ajax&plugin=jspeed&format=json';
		$doc->addScriptDeclaration( 'var jspeedPageSpeedLink = "' .  $pageSpeedLink . '";' );
		
		$doc->addScript ( JUri::root(true) . '/media/plg_jspeed/js/progress-ring.js' );
		$doc->addScript ( JUri::root(true) . '/media/plg_jspeed/js/pagespeed.js' );
		
		$btnText = JText::_('PLG_JSPEED_AUTO_CONFIGURATION_TEST_BTN');
		$htmlControl = <<<HTMLCONTROL
			<a class="btn btn-sm btn-primary" id="pagespeed-test"><span class="icon-dashboard"></span> $btnText</a>
			<div class="pagespeed-test-url label bg-light"></div>
			<div class="timeline-container">
				<div class="timeline-wrapper" id="timeline-mobile">
				    <div class="timeline-item">
				        <div class="static-background">
				            <div class="background-masker header-top"></div>
				            <div class="background-masker header-left"></div>
				            <div class="background-masker header-right"></div>
				            <div class="background-masker subheader-left"></div>
				            <div class="background-masker subheader-bottom"></div>
				            <div class="background-masker content-top"></div>
				            <div class="background-masker content-first-end"></div>
				            <div class="background-masker content-second-end"></div>
				            <div class="background-masker content-third-end"></div>
							<div class="background-masker content-forth-line"></div>
							<div class="background-masker content-fifth-line"></div>
				        </div>
				    </div>
				</div>
				<div class="timeline-wrapper" id="timeline-desktop">
				    <div class="timeline-item">
				        <div class="static-background">
				            <div class="background-masker header-top"></div>
				            <div class="background-masker header-left"></div>
				            <div class="background-masker header-right"></div>
				            <div class="background-masker subheader-left"></div>
				            <div class="background-masker subheader-bottom"></div>
				            <div class="background-masker content-top"></div>
				            <div class="background-masker content-first-end"></div>
				            <div class="background-masker content-second-end"></div>
				            <div class="background-masker content-third-end"></div>
							<div class="background-masker content-forth-line"></div>
							<div class="background-masker content-fifth-line"></div>
				        </div>
				    </div>
				</div>
			</div>
HTMLCONTROL;
		
		return $htmlControl;
	}
}
