<?php
/**
 * @author Joomla! Extensions Store
 * @package JSPEED::plugins::system
 * @copyright (C) 2020 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ();

include_once dirname ( dirname ( __FILE__ ) ) . '/framework/loader.php';
class JFormFieldAssets extends JFormField {
	protected $type = 'Assets';
	public function setup(SimpleXMLElement $element, $value, $group = NULL) {
		$params = JSpeedPlugin::getPluginParams ();

		static $cnt = 1;

		if ($cnt == 1) {
			JHtml::_('bootstrap.framework');

			$doc = JFactory::getDocument ();
			$sScript = '';

			$doc->addStyleSheet ( JUri::root ( true ) . '/media/plg_jspeed/css/bootstrap-interface.css' );
			$doc->addStyleSheet ( JUri::root ( true ) . '/media/plg_jspeed/css/select2.min.css' );
			$doc->addScript ( JUri::root ( true ) . '/media/plg_jspeed/js/bootstrap-interface.js' );
			$doc->addScript ( JUri::root ( true ) . '/media/plg_jspeed/js/select2.min.js' );

			$uri = clone JUri::getInstance ();
			$domain = $uri->toString ( array (
					'scheme',
					'user',
					'pass',
					'host',
					'port'
			) ) . JSpeedHelper::getBaseFolder ();
			$plugin_path = 'plugins/system/jspeed/';

			$ajax_url = $domain . 'administrator/index.php?option=com_jspeed';

			// Optimize htaccess
			$optimizeHtaccess = JText::_('PLG_JSPEED_HTACCESS_SETUP', true);
			$optimizeHtaccessDesc = JText::_('PLG_JSPEED_HTACCESS_SETUP_DESC', true);
			$optimizeHtaccessURL = JUri::getInstance()->toString() . '&amp;jspeedtask=optimizehtaccess';
			
			// Restore htaccess
			$restoreHtaccess = JText::_('PLG_JSPEED_HTACCESS_RESTORE', true);
			$restoreHtaccessDesc = JText::_('PLG_JSPEED_HTACCESS_RESTORE_DESC', true);
			$restoreHtaccessURL = JUri::getInstance()->toString() . '&amp;jspeedtask=restorehtaccess';	
			
			// Clear cache
			$clearCache = JText::_('PLG_JSPEED_CLEAR_CACHE', true);
			$clearCacheDesc = JText::_('PLG_JSPEED_CLEAR_CACHE_DESC', true);
			$clearCacheURL = JUri::getInstance()->toString() . '&amp;jspeedtask=clearcache';
			$enabledLabel = JText::_('PLG_JSPEED_AUTO_CONFIGURATION_ENABLED', true);
			$disabledLabel = JText::_('PLG_JSPEED_AUTO_CONFIGURATION_DISABLED', true);
			$sScript .= <<<JSPEEDSCRIPTS
						var ajaxEndpoint = '$ajax_url';
						var jSpeedOptimizeHtaccessURL = '$optimizeHtaccessURL';
						var jSpeedRestoreHtaccessURL = '$restoreHtaccessURL';
						var jSpeedClearCacheURL = '$clearCacheURL';
						var PLG_JSPEED_HTACCESS_SETUP = '$optimizeHtaccess';
						var PLG_JSPEED_HTACCESS_SETUP_DESC = '$optimizeHtaccessDesc';
						var PLG_JSPEED_HTACCESS_RESTORE = '$restoreHtaccess';
						var PLG_JSPEED_HTACCESS_RESTORE_DESC = '$restoreHtaccessDesc';
						var PLG_JSPEED_CLEAR_CACHE = '$clearCache';
						var PLG_JSPEED_CLEAR_CACHE_DESC = '$clearCacheDesc';
						var PLG_JSPEED_AUTO_CONFIGURATION_ENABLED = '$enabledLabel';
						var PLG_JSPEED_AUTO_CONFIGURATION_DISABLED = '$disabledLabel';
JSPEEDSCRIPTS;

			$doc->addScriptDeclaration ( $sScript );
		}

		$cnt ++;

		// Check for Joomla compatibility
		if(version_compare(JVERSION, '4', '>=')) {
			JFactory::getApplication()->enqueueMessage (JText::_('PLG_JSPEED_INSTALLED_VERSION_NOTCOMPATIBLE'), 'error');
		}
		
		return false;
	}
	protected function getInput() {
		return false;
	}
}
