jQuery(function($){

    var isLoading = false;

    $(function(){

        $('body').on('click','.jll-find-keywords',function(e){
            e.preventDefault();

            var searchValue = $('.jll-languages input[name="search"]').val();

            if(searchValue.length < 1)
            {
                alert('شما باید متنی را برای جستجو وارد نمایید.');
                return false;
            }

            $('.jll-languages-overly').removeClass('jb-hide');

            var data = {
                'JJLMethod' : 'findKeywords',
                'searchValue' : searchValue
            };

            $.ajax({
                type: "POST",
                url: "index.php?option=com_installer&format=ajax",
                data: data,
                success:function(result)
                {
                    $('.jll-languages-overly').addClass('jb-hide');
                    $('.jll-keywords').html(result);
                }
            });
        });

        $('body').on('click','.jll-languages .lang-tools .lang-tool img',function(){
            var dir = $(this).closest('tr');
            var action = $(this).parent().attr('action');

            if(action == 'edit')
            {
                dir.find('.td-translate').removeClass('translate-edited translate-loading');

                dir.find('.td-translate').addClass('translate-edited');
                dir.find('.lang-text').hide();
                dir.find('.lang-box').show();
                dir.find('.lang-box input').focus();
            }
            else if(action == 'reset')
            {
                dir.find('.td-translate').removeClass('translate-edited translate-loading');
                dir.find('.td-translate').addClass('translate-loading');

                var data = {
                    'JJLMethod' : 'setDefault',
                    'khash' : dir.attr('khash'),
                    'location' : dir.find('.td-location').attr('location'),
                    'file' : dir.find('.td-file').text()
                };

                $.ajax({
                    type: "POST",
                    url: "index.php?option=com_installer&format=ajax",
                    data: data,
                    success:function(result)
                    {
                        result = $.parseJSON(result);
                        isLoading = false;

                        if(result[0] == 1)
                        {
                            dir.find('.td-translate').removeClass('translate-loading');
                            dir.find('.td-translate').addClass('translate-result-success');

                            dir.find('.lang-text').html(result[1]);
                            dir.find('input').val(result[1]);

                            if(dir.find('.td-translate').hasClass('translate-changed'))
                            {
                                dir.find('.td-translate').removeClass('translate-changed');
                            }
                        }
                        else
                        {
                            dir.find('.td-translate').removeClass('translate-loading');
                            dir.find('.td-translate').addClass('translate-result-error');
                            dir.find('.td-translate').addClass('translate-changed');
                        }

                        dir.find('.lang-text').fadeIn(500);
                        dir.find('.lang-box').hide();

                        setTimeout(function(){
                            dir.find('.td-translate').removeClass('translate-result-success translate-result-error');
                        },2000);
                    }
                });
            }
            else if(action == 'save')
            {
                isLoading = true;

                dir.find('.td-translate').removeClass('translate-edited translate-loading');
                dir.find('.td-translate').addClass('translate-loading');

                dir.find('input').focus();

                var translate = dir.find('input[type="text"]').val();
                var location = dir.find('.td-location').attr('location');
                var file = dir.find('.td-file').text();
                var khash = dir.attr('khash');

                var data = {
                    'JJLMethod' : 'saveTranslate',
                    'khash' : khash,
                    'location' : location,
                    'file' : file,
                    'translate' : translate
                };

                $.ajax({
                    type: "POST",
                    url: "index.php?option=com_installer&format=ajax",
                    data: data,
                    success:function(result)
                    {
                        isLoading = false;
                        if(result == 'OK')
                        {
                            dir.find('.td-translate').removeClass('translate-loading');
                            dir.find('.td-translate').addClass('translate-result-success');

                            dir.find('.lang-text').html(translate);

                            if(!dir.find('.td-translate').hasClass('translate-changed'))
                            {
                                dir.find('.td-translate').addClass('translate-changed');
                            }
                        }
                        else
                        {
                            dir.find('.td-translate').removeClass('translate-loading');
                            dir.find('.td-translate').addClass('translate-result-error');
                        }

                        dir.find('.lang-text').fadeIn(500);
                        dir.find('.lang-box').hide();

                        setTimeout(function(){
                            dir.find('.td-translate').removeClass('translate-result-success translate-result-error');
                        },2000);
                    }
                });
            }
        });
    });
});