<?php
/**
 * @copyright	Copyright (C) 2015 Cédric KEIFLIN alias ced1870
 * http://www.joomlack.fr
 * http://www.template-creator.com
 * @license		GNU/GPL
 * */

defined('_JEXEC') or die;
jimport('joomla.filesystem.folder');

class PlgButtonImageeffectckbutton extends JPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * Imageeffectckbutton button
	 *
	 * @param   string  $name  The name of the editor field
	 *
	 * @return button Object
	 */
	public function onDisplay($name)
	{
		$doc = JFactory::getDocument();

		// translations
		JText::script('PLG_IMAGEEFFECTCKBUTTONBUTTON_CHOOSE_IMAGE');
		JText::script('PLG_IMAGEEFFECTCKBUTTON_EDITION');
		JText::script('CK_SAVE_CLOSE');
		JText::script('PLG_IMAGEEFFECTCKBUTTON_SELECT_EFFECT');
		JText::script('JCANCEL');
		JText::script('PLG_IMAGEEFFECTCKBUTTON_IMAGE_TITLE');
		JText::script('PLG_IMAGEEFFECTCKBUTTON_IMAGE_DESCRIPTION');
		JText::script('PLG_IMAGEEFFECTCKBUTTON_IMAGE_CSS_CLASS');

		// $doc->addScriptDeclaration($js);
		JHtml::_('jquery.framework', true);
		$doc->addStylesheet(JUri::root(true) . '/plugins/editors-xtd/imageeffectckbutton/assets/imageeffectckbutton.css');
		$doc->addStylesheet(JUri::root(true) . '/plugins/system/imageeffectck/assets/imageeffectck.css');
		$doc->addScript(JUri::root(true) . '/plugins/editors-xtd/imageeffectckbutton/assets/imageeffectckbutton.js');

		$button = new JObject;
		$button->modal = false;
		$button->class = 'btn';
		$button->onclick = 'showImageeffectckButton(\'' . $name . '\', \'' . JUri::root(true) . '\');return false;';
		$button->text = JText::_('PLG_IMAGEEFFECTCKBUTTON_BUTTON');
		$button->name = 'imageeffectckbutton'; // nom de la classe pour icone
		$button->link = '#';
		// $button->options = "{handler: 'inline', size: {x: 800, y: 500}}";

		return $button;
	}

}