<?php
/**
 * @copyright	Copyright (c) 2014 dibuxo. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;



/**
 * editors-xtd - fontawesomebutton Plugin
 *
 * @package		Joomla.Plugin
 * @subpakage	dibuxo.fontawesomebutton
 */
class PlgButtonDxfabutton extends JPlugin {

	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * Display the button
	 *
	 * @param   string  $name  The name of the button to add
	 *
	 * @return array A two element array of (imageName, textToInsert)
	 */
	public function onDisplay($name)
	{

		$content_params = JComponentHelper::getParams( 'com_dxfontawesome' );
		$faversion = $content_params->get( 'faversion', '4');


		JHtml::_('behavior.modal');
		// Import CSS
		$isFront = JFactory::getApplication()->isSite() ? 'administrator/' : '';
		
		//prevent front
		$isFront = '';

		if($faversion == '4'){
			$link = $isFront.'index.php?option=com_dxfontawesome&view=dxfontawesome&layout=fa_selector&tmpl=component&editor=' . $name;
		}else{
			$link = $isFront.'index.php?option=com_dxfontawesome&view=dxfontawesome&layout=fa_selector5&tmpl=component&editor=' . $name;
		}



		$button = new JObject;
		$button->modal = true;
		$button->class = 'btn';
		$button->link  = $link;
		$button->text  = JText::_('FontAwesome '.$faversion);
		$button->name  = 'info-circle';
		$button->options = "{handler: 'iframe', size: {x: 740, y: 520}}";
	
		return $button;
	}
}
