<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Content.Dxfaparse
 *
 * @copyright   Copyright (C) 2005 - 2014 dibuxo.com | Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Plug-in to load FontAwsome into content (e.g. articles)
 * This uses the {fa-icon} syntax
 *
 * @package     Joomla.Plugin
 * @subpackage  Content.Dxfaparse
 * @since       1.5
 */
class PlgContentDxfaparser extends JPlugin{

	/**
	 * Plugin that loads FontAwesome icons within content
	 *
	 * @param   string   $context   The context of the content being passed to the plugin.
	 * @param   object   &$article  The article object.  Note $article->text is also available
	 * @param   mixed    &$params   The article params
	 * @param   integer  $page      The 'page' number
	 *
	 * @return  mixed   true if there is an error. Void otherwise.
	 *
	 * @since   1.6
	 */
	public function onContentPrepare($context, &$article, &$params, $page = 0){
		// Don't run this plugin when the content is being indexed
		if ($context == 'com_finder.indexer')
		{
			return true;
		}

		// Simple performance check to determine whether bot should process further
		if (strpos($article->text, 'fa-') === false)
		{
			return true;
		}

		// Expression to search for Dxfaparse
		$regex		= '/{fa-(.*?)}/i';
		//$regex		= '/{fa\s+(.*?)}/i';

		preg_match_all($regex, $article->text, $matches, PREG_SET_ORDER);

		//var_dump($matches);
		// No matches, skip this
		if ($matches){
			foreach ($matches as $match)
			{
				$matcheslist = explode(',', $match[0]);

				$found = trim($match[0]);
				$output = $this->_load($found);
				
				//$article->text = preg_replace("|$match[0]|", addcslashes($output, '\\$'), $article->text, 1);
				$article->text = str_replace($match[0], $output, $article->text);
			}

			//load fontawesome font
			jimport('joomla.application.component.helper');
			$loadfa = JComponentHelper::getParams('com_dxfontawesome')->get('loadfa',1);
			$load_external = JComponentHelper::getParams('com_dxfontawesome')->get('load_external',1);
			$loadfassl = JComponentHelper::getParams('com_dxfontawesome')->get('loadfassl',0);
			$fa_version = JComponentHelper::getParams('com_dxfontawesome')->get('faversion',4);

			if($loadfassl){
				$ssl = 'https://';
			}else{
				$ssl = 'http://';
			}

			$document = JFactory::getDocument();
			
			if($fa_version == '4'){
				if($loadfa){

					if($load_external){
						$document->addStyleSheet($ssl.'maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css');
					}else{
						$document->addStyleSheet(JURI::root().'administrator/components/com_dxfontawesome/assets/css/font-awesome.min.css');
					}
				}
			}


			if($fa_version == '5'){
				$document->addCustomTag('<script defer type="text/javascript" src="https://use.fontawesome.com/releases/v5.0.0/js/all.js" ></script>');
			}


		}



	}

	/**
	 * Loads the fa element
	 *
	 * @param   string  $found  The fa tag
	 *
	 * @return  mixed
	 *
	 * @since   1.6
	 */
	protected function _load($found)
	{
		//var_dump($found);
		$regex_color	= '/color=(.*)+\)/i';
		preg_match('/color=rgb\((.*?)\)/i', $found, $color_rgb);
		if($color_rgb){
			$estilo = preg_replace($regex_color, 'style="color:rgb('.$color_rgb[1].')"', $found);
			$estilo = 'style="color:rgb('.$color_rgb[1].')"';
		}else{
			$estilo = '';
		}
		
		$found = substr($found, 1, -1);
		$raso_array =  explode(" ",$found);
		$raso = implode(' ', $raso_array);
		
		$resultado = '<i class="fa '.$raso.'" '.$estilo.'></i>';
		return $resultado;
	}
}
