/**
 * Youfact News Engine
 * @version		1.0.0
 * @MooTools version 1.3+
 * @author		Constantin Boiangiu <info [at] constantinb.com>
 * Copyright Youjoomla.com
 */
var YouFactNe = new Class({
	Implements: [Options],					 
	options: {
		container : null, /* items container */
		items : null, /* CSS class for each item - mention it as .Class */
		itemWidth : null,
		visibleItems: null,
		effectDuration : 1000,
		autoSlide : 3000,
		mouseEventSlide: 1000,
		navigation: {
			'forward':null, 
			'back':null
		}
	},
	
	initialize: function(options) {
		this.setOptions(options);
		if( !this.options.container || !this.options.itemWidth || !this.options.visibleItems ) return;
		this.container = $(this.options.container);
		this.items = this.container.getElements(this.options.items);
		this.totalItems = this.items.length;
		this.currentElement = 0;
		this.direction = 1; /* -1:reverse ; 1: forward */
		
		if( this.options.autoSlide < 1 ){
			this.options.autoSlide = false;
		}
		
		this.start();	
	},
	
	start: function(){
		this.items.each(function(item, i){
								 
			var leftDist = i * this.options.itemWidth; 
			item.setStyles({
				'position':'absolute',
				'top':0,
				'left' : leftDist
			});
			var fx = new Fx.Morph(item, {
				duration:this.options.effectDuration, 
				wait:false, 
				transition:Fx.Transitions.Sine.easeOut
			});
			this.items[i]['fx'] = fx;
			this.items[i]['leftDist'] = leftDist;
			
			item.addEvent('mouseenter', function(event){
				if( this.options.autoSlide )
					clearTimeout(this.period);
			}.bind(this));
			
			item.addEvent('mouseleave', function(event){
				if( this.options.autoSlide )
					this.period = this.autoSlide();							   
			}.bind(this));
			
		}.bind(this));	
		
		if( this.options.autoSlide ){
			this.period = this.autoSlide();
		}
		
		this.inject();
    // morph images yj
    var container_image = $(this.options.container).getElements('img');
    var parent_size = $$(container_image)[0].getParent().getParent().getSize();
    var percentage_s = (100 - this.options.morphPercent) / 100;
    var percentage_m = this.options.morphPercent / 100;
    var hresize_to = parent_size.y * percentage_s;
    var wresize_to = parent_size.x * percentage_s;
    var m_verti = (parent_size.y * percentage_m) / 2;
    var m_horiz = (parent_size.x * percentage_m) / 2;
    var mspeed = this.options.morphDurration;
    var morphImage = this.options.morphPercent;
    if (this.options.morphPercent > 0) {
      $$(container_image).each(function (el) {
        var morph = new Fx.Morph(el, {
          duration: mspeed,
          link: 'chain'
        });
        el.addEvents({
          'mouseenter': function () {
            morph.start({
              'width': [parent_size.x, wresize_to],
              'height': [parent_size.y, hresize_to],
              'margin-top': m_verti,
              'margin-bottom': m_verti,
              'margin-left': m_horiz,
              'margin-right': m_horiz
            });
          },
          'mouseleave': function () {
            morph.start({
              'width': [wresize_to, parent_size.x],
              'height': [hresize_to, parent_size.y],
              'margin-top': 0,
              'margin-bottom': 0,
              'margin-left': 0,
              'margin-right': 0
            });
          }
        });
      });
    }
    //end  morph images yj
	},
	
	visibleFwd: function(){
		var t = new Array();
		t.push(this.currentElement);
		var el = this.currentElement;
		for( var i=1; i<this.options.visibleItems+2; i++ ){
			el = el+1 < this.totalItems ? el+1 : 0;
			t.push(el);	
		};
		return t;
	},
	
	rotateForward: function(){
		if (this.items[this.currentElement]['leftDist']!==0) return;
		var slides = this.visibleFwd();
		this.items.each( function( item, i ){
			var leftDist = item['leftDist'] - this.options.itemWidth;			
			
			if( slides.contains(i) ){
				item['fx'].start({'left': leftDist}).chain(function(){
					
					if( leftDist < 0 )				
					{
						leftDist = this.totalItems*this.options.itemWidth+(this.direction*leftDist);				
						item.setStyle('left', leftDist)
					}				
					this.items[i]['leftDist'] = leftDist;
					
				}.bind(this));
			}else{
				if( leftDist < 0 )				
				{
					leftDist = this.totalItems*this.options.itemWidth+(this.direction*leftDist);				
					item.setStyle('left', leftDist)
				}				
				this.items[i]['leftDist'] = leftDist;
			}
			
		}.bind(this));
		
		this.currentElement = this.currentElement+1 < this.totalItems ? this.currentElement+1 : 0;
	},
	
	visibleBkw: function(){
		var t = new Array();
		t.push( this.currentElement-1 < 0 ? this.totalItems-1 : this.currentElement-1 );
		t.push( this.currentElement );
		var el = this.currentElement;
		for( var i=1; i<this.options.visibleItems+2; i++ ){
			el = el+1 < this.totalItems ? el+1 : 0;
			t.push(el);	
		};
		return t;
	},
	
	rotateBackwards: function(){
		if (this.items[this.currentElement]['leftDist']!==0) return;
		var movedElement = this.items[ this.currentElement -1 ] || this.items.getLast();
		movedElement.setStyle('left',-this.options.itemWidth);
		movedElement['leftDist'] = -this.options.itemWidth;
		
		var t = this.visibleBkw();
		
		this.items.each( function(item, i){
			
			var leftDist = item['leftDist'] + this.options.itemWidth;
			
			if( t.contains(i) ){
				item['fx'].start({'left': leftDist}).chain(function(){
					this.items[i]['leftDist'] = leftDist;
				}.bind(this));
			}else{
				item.setStyle('left', leftDist);
				this.items[i]['leftDist'] = leftDist;
			}
			
		}.bind(this) );
		
		this.currentElement = this.currentElement-1 < 0 ? this.totalItems-1 : this.currentElement-1;		
	},
	
	autoSlide: function( mouseEvent ){
		var rotateType = this.direction == 1 ? this.rotateForward : this.rotateBackwards;
		return rotateType.periodical( mouseEvent ? this.options.mouseEventSlide : this.options.autoSlide, this);
	},
	
	inject: function(){
		var forward = new Element('a').set({'class':this.options.navigation.forward, 'id':'forward'}).inject(this.container);	
		var back = new Element('a').set({'class':this.options.navigation.back, 'id':'back'}).inject(this.container);
		
		//*
		forward.addEvent('click', this.navEvent.bind(this).pass(1));		
		back.addEvent('click', this.navEvent.bind(this).pass(-1));
		//*/	
		
		forward.addEvent('click', this.resetSlide.bind(this));
		back.addEvent('click', this.resetSlide.bind(this));
		
		forward.addEvent('click', function(event){
			event.stop();
			clearTimeout(this.period);
			this.direction = 1;
			
			if( this.items[this.currentElement]['leftDist'] == 0 )
				this.rotateForward.bind(this).delay(50);
			
		}.bind(this));
		
		back.addEvent('click', function(event){
			event.stop();
			clearTimeout(this.period);
			this.direction = -1;
			
			if( this.items[this.currentElement]['leftDist'] == 0 )
				this.rotateBackwards.bind(this).delay(50);
			
		}.bind(this));
			
	},
	
	navEvent: function(direction){
		this.direction = direction;
		clearTimeout(this.period);
		this.period = this.autoSlide(true);
	},
	
	resetSlide: function(){
		clearTimeout(this.period);
		this.period = this.autoSlide();
	}
});