<?php
/**
 * @package Sj K2 Mega News
 * @version 2.5
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2012 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 * 
 */
// no direct access
defined('_JEXEC') or die;

require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');
require_once dirname(__FILE__).'/helper_base.php';

class SjK2MegaNewsHelper extends K2BaseHelper
{
	public static function getList(&$params)
	{
  
		// webiranian
		$mainframe = JFactory::getApplication();
		$sourcetype = $params->get('sourcetype', 1);
		$limit = $params->get('itemCount', 5);
		 
		if($sourcetype == 1){
			if ($params->get('catfilter')){
				$cid = $params->get('category_id', NULL);
				
			} else{
				$itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
				$cid = $itemListModel->getCategoryTree($category=0);
			}
			$items = self::getItems($cid, $params);
		} elseif($sourcetype == 2) {
			$db = &JFactory::getDBO();
			$query = "SELECT * FROM #__content WHERE `state` = 1 ";
			if ($params->get('catfilter')){
				$cid = $params->get('category_id', NULL);
				$query .= " AND catid = '$cid' ";
			}	
			$query .= " ORDER BY id DESC "; 
			$query .= " LIMIT $limit"; 
			$db->setQuery($query);
			$items = $db->loadObjectList();
		}
        
		return $items;
	}
    
        public static function getItemsNew($cid, &$params)
        {
            
        
            jimport('joomla.filesystem.file');
            $mainframe = JFactory::getApplication();
            $limit = $params->get('itemCount', 5);
            $ordering = $params->get('itemsOrdering', '');
            $componentParams = JComponentHelper::getParams('com_k2');
            $limitstart = JRequest::getInt('limitstart');

            $user = JFactory::getUser();
            $aid = $user->get('aid');
            $db = JFactory::getDBO();

            $jnow = JFactory::getDate();
            $now =  $jnow->toSql();
            $nullDate = $db->getNullDate();

            if ($params->get('source') == 'specific')
            {

                $value = $params->get('items');
                $current = array();
                if (is_string($value) && !empty($value))
                    $current[] = $value;
                if (is_array($value))
                    $current = $value;

                $items = array();

                foreach ($current as $id)
                {

                    $query = "SELECT i.*, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams
                            FROM #__k2_items as i
                            LEFT JOIN #__k2_categories c ON c.id = i.catid
                            WHERE i.published = 1 ";
                    $query .= " AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
                    $query .= " AND i.trash = 0 AND c.published = 1 ";
                    $query .= " AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
                    $query .= " AND c.trash = 0
                            AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )
                                    AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )
                                    AND i.id={$id}";
                    if ($mainframe->getLanguageFilter())
                    {
                        $languageTag = JFactory::getLanguage()->getTag();
                        $query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
                    } 
                    $db->setQuery($query);
                    $item = $db->loadObject();
                    if ($item) $items[] = $item;

                }
            }

            else
            {
                
                //$query = "SELECT i.*, CASE WHEN i.modified = 0 THEN i.created ELSE i.modified END as lastChanged, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";
                $query = "SELECT DISTINCT i.`id`,i.*, CASE WHEN i.modified = 0 THEN i.created ELSE i.modified END as lastChanged, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";

                if ($ordering == 'best')
                    $query .= ", (r.rating_sum/r.rating_count) AS rating";

                if ($ordering == 'comments')
                    $query .= ", COUNT(comments.id) AS numOfComments";

                $query .= " FROM #__k2_items as i LEFT JOIN #__k2_categories c ON c.id = i.catid";

                if ($ordering == 'best')
                    $query .= " LEFT JOIN #__k2_rating r ON r.itemID = i.id";

                if ($ordering == 'comments')
                    $query .= " LEFT JOIN #__k2_comments comments ON comments.itemID = i.id";

                    //// arasjoomla
                    $query .= " LEFT JOIN  #__k2_additional_categories AS ca ON ca.`itemID`  = i.`id` ";
                    
                $query .= " WHERE i.published = 1 AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") AND i.trash = 0 AND c.published = 1 AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).")  AND c.trash = 0";

                $query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )";
                $query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";


                if (!is_null($cid))
                {
                    if (is_array($cid))
                    {
                        if ($params->get('getChildren'))
                        {
                            $itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
                            $categories = $itemListModel->getCategoryTree($cid);
                            $sql = @implode(',', $categories);
                            $query .= " AND i.catid IN ({$sql})";

                        }
                        else
                        {
                            JArrayHelper::toInteger($cid);
                            $query .= " AND i.catid IN(".implode(',', $cid).")";
                        }

                    }
                    else
                    {
                        if ($params->get('getChildren'))
                        {
                            $itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
                            $categories = $itemListModel->getCategoryTree($cid);
                            $sql = @implode(',', $categories);
                            $query .= " AND i.catid IN ({$sql})";
                        }
                        else
                        {
                            $query .= " AND i.catid=".(int)$cid;
                        }

                    }
                    $query .= " OR ca.`catid` IN ($cid)"; // arasjoomla
                }
                

                if ($params->get('FeaturedItems') == '0')
                    $query .= " AND i.featured != 1";

                if ($params->get('FeaturedItems') == '2')
                    $query .= " AND i.featured = 1";

                if ($params->get('videosOnly'))
                    $query .= " AND (i.video IS NOT NULL AND i.video!='')";

                if ($ordering == 'comments')
                    $query .= " AND comments.published = 1";

                if ($mainframe->getLanguageFilter())
                {
                    $languageTag = JFactory::getLanguage()->getTag();
                    $query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
                }

                switch ($ordering)
                {

                    case 'date' :
                        $orderby = 'i.created ASC';
                        break;

                    case 'rdate' :
                        $orderby = 'i.created DESC';
                        break;

                    case 'alpha' :
                        $orderby = 'i.title';
                        break;

                    case 'ralpha' :
                        $orderby = 'i.title DESC';
                        break;

                    case 'order' :
                        if ($params->get('FeaturedItems') == '2')
                            $orderby = 'i.featured_ordering';
                        else
                            $orderby = 'i.ordering';
                        break;

                    case 'rorder' :
                        if ($params->get('FeaturedItems') == '2')
                            $orderby = 'i.featured_ordering DESC';
                        else
                            $orderby = 'i.ordering DESC';
                        break;

                    case 'hits' :
                        if ($params->get('popularityRange'))
                        {
                            $datenow = JFactory::getDate();
                            $date =  $datenow->toSql();
                            $query .= " AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange')." DAY) ";
                        }
                        $orderby = 'i.hits DESC';
                        break;

                    case 'rand' :
                        $orderby = 'RAND()';
                        break;

                    case 'best' :
                        $orderby = 'rating DESC';
                        break;

                    case 'comments' :
                        if ($params->get('popularityRange'))
                        {
                            $datenow = JFactory::getDate();
                            $date =  $datenow->toSql();
                            $query .= " AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange')." DAY) ";
                        }
                        $query .= " GROUP BY i.id ";
                        $orderby = 'numOfComments DESC';
                        break;

                    case 'modified' :
                        $orderby = 'lastChanged DESC';
                        break;

                    case 'publishUp' :
                        $orderby = 'i.publish_up DESC';
                        break;

                    default :
                        $orderby = 'i.id DESC';
                        break;
                }

                $query .= " ORDER BY ".$orderby;
                //$dispatcher = JDispatcher::getInstance();
                //JPluginHelper::importPlugin('k2');
                //$dispatcher->trigger('onK2BeforeSetQuery', array(&$query,$cid));
                if($module->id==464)
                file_put_contents(JPATH_ROOT.DS.'debug'.DS.'data.txt', print_r($query, true)); 
                $db->setQuery($query, 0, $limit);
                $items = $db->loadObjectList();
            }

            $model = K2Model::getInstance('Item', 'K2Model');

            if (count($items))
            {

                foreach ($items as $item)
                {
                    $item->event = new stdClass;

                    //Clean title
                    $item->title = JFilterOutput::ampReplace($item->title);

                    //Images

                    //Read more link
                    $item->link = urldecode(JRoute::_(K2HelperRoute::getItemRoute($item->id.':'.urlencode($item->alias), $item->catid.':'.urlencode($item->categoryalias))));

                    //Tags
                    if ($params->get('itemTags'))
                    {
                        $tags = $model->getItemTags($item->id);
                        for ($i = 0; $i < sizeof($tags); $i++)
                        {
                            $tags[$i]->link = JRoute::_(K2HelperRoute::getTagRoute($tags[$i]->name));
                        }
                        $item->tags = $tags;
                    }

                    //Category link
                    if ($params->get('itemCategory'))
                        $item->categoryLink = urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($item->catid.':'.urlencode($item->categoryalias))));

                    //Extra fields
                    if ($params->get('itemExtraFields'))
                    {
                        $item->extra_fields = $model->getItemExtraFields($item->extra_fields, $item);
                    }

                    //Comments counter
                    if ($params->get('itemCommentsCounter'))
                        $item->numOfComments = $model->countItemComments($item->id);

                    //Attachments
                    if ($params->get('itemAttachments'))
                        $item->attachments = $model->getItemAttachments($item->id);

                    if ($params->get('JPlugins', 0)){
                        //Import plugins
                        $dispatcher = JDispatcher::getInstance();
                        JPluginHelper::importPlugin('content');
                    }

                    //Video
                    if ($params->get('itemVideo') && $format != 'feed')
                    {
                        $params->set('vfolder', 'media/k2/videos');
                        $params->set('afolder', 'media/k2/audio');
                        $item->text = $item->video;

                        $dispatcher->trigger('onContentPrepare', array('mod_k2_content.', &$item, &$params, $limitstart));
                        $item->video = $item->text;
                    }

                    // Introtext
                    $item->text = '';
                    if ($params->get('itemIntroText'))
                    {
                        
                        $item->text .= self::_cleanText($item->introtext);
                    }
                        
                    $params->set('parsedInModule', 1);
                    // for plugins to know when they are parsed inside this module

                    if ($params->get('JPlugins', 0))
                    {
                        //Plugins
                            
                        $results = $dispatcher->trigger('onBeforeDisplay', array(&$item, &$params, $limitstart));
                        $item->event->BeforeDisplay = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onAfterDisplay', array(&$item, &$params, $limitstart));
                        $item->event->AfterDisplay = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onAfterDisplayTitle', array(&$item, &$params, $limitstart));
                        $item->event->AfterDisplayTitle = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onBeforeDisplayContent', array(&$item, &$params, $limitstart));
                        $item->event->BeforeDisplayContent = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onAfterDisplayContent', array(&$item, &$params, $limitstart));
                        $item->event->AfterDisplayContent = trim(implode("\n", $results));

                        $dispatcher->trigger('onPrepareContent', array(&$item, &$params, $limitstart));

                    }
                    //Init K2 plugin events
                    $item->event->K2BeforeDisplay = '';
                    $item->event->K2AfterDisplay = '';
                    $item->event->K2AfterDisplayTitle = '';
                    $item->event->K2BeforeDisplayContent = '';
                    $item->event->K2AfterDisplayContent = '';
                    $item->event->K2CommentsCounter = '';

                    if ($params->get('K2Plugins', 0))
                    {
                        //K2 plugins
                        JPluginHelper::importPlugin('k2');
                        $results = $dispatcher->trigger('onK2BeforeDisplay', array(&$item, &$params, $limitstart));
                        $item->event->K2BeforeDisplay = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onK2AfterDisplay', array(&$item, &$params, $limitstart));
                        $item->event->K2AfterDisplay = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onK2AfterDisplayTitle', array(&$item, &$params, $limitstart));
                        $item->event->K2AfterDisplayTitle = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onK2BeforeDisplayContent', array(&$item, &$params, $limitstart));
                        $item->event->K2BeforeDisplayContent = trim(implode("\n", $results));

                        $results = $dispatcher->trigger('onK2AfterDisplayContent', array(&$item, &$params, $limitstart));
                        $item->event->K2AfterDisplayContent = trim(implode("\n", $results));

                        $dispatcher->trigger('onK2PrepareContent', array(&$item, &$params, $limitstart));

                        if ($params->get('itemCommentsCounter'))
                        {
                            $results = $dispatcher->trigger('onK2CommentsCounter', array(&$item, &$params, $limitstart));
                            $item->event->K2CommentsCounter = trim(implode("\n", $results));
                        }

                    }

                    // Restore the intotext variable after plugins execution
                    $item->displayIntrotext = $item->text;

                    //Clean the plugin tags
                    $item->displayIntrotext = preg_replace("#{(.*?)}(.*?){/(.*?)}#s", '', $item->displayIntrotext);

                    //Author
                    if ($params->get('itemAuthor'))
                    {
                        if (!empty($item->created_by_alias))
                        {
                            $item->author = $item->created_by_alias;
                            $item->authorGender = NULL;
                            $item->authorDescription = NULL;
                            if ($params->get('itemAuthorAvatar'))
                                $item->authorAvatar = K2HelperUtilities::getAvatar('alias');
                            $item->authorLink = Juri::root(true);
                        }
                        else
                        {
                            $author = JFactory::getUser($item->created_by);
                            $item->author = $author->name;

                            $query = "SELECT `description`, `gender` FROM #__k2_users WHERE userID=".(int)$author->id;
                            $db->setQuery($query, 0, 1);
                            $result = $db->loadObject();
                            if ($result)
                            {
                                $item->authorGender = $result->gender;
                                $item->authorDescription = $result->description;
                            }
                            else
                            {
                                $item->authorGender = NULL;
                                $item->authorDescription = NULL;
                            }

                            if ($params->get('itemAuthorAvatar'))
                            {
                                $item->authorAvatar = K2HelperUtilities::getAvatar($author->id, $author->email, $componentParams->get('userImageWidth'));
                            }
                            //Author Link
                            $item->authorLink = JRoute::_(K2HelperRoute::getUserRoute($item->created_by));
                        }
                    }

                    // Extra fields plugins
                    if (is_array($item->extra_fields))
                    {
                        foreach ($item->extra_fields as $key => $extraField)
                        {
                            if ($extraField->type == 'textarea' || $extraField->type == 'textfield')
                            {
                                $tmp = new JObject();
                                $tmp->text = $extraField->value;
                                if ($params->get('JPlugins', 0))
                                {
                                    $dispatcher->trigger('onPrepareContent', array(&$tmp, &$params, $limitstart));
                                }
                                if ($params->get('K2Plugins', 0))
                                {
                                    $dispatcher->trigger('onK2PrepareContent', array(&$tmp, &$params, $limitstart));
                                }
                                $extraField->value = $tmp->text;
                            }
                        }
                    }
                    $rows[] = $item;
                }
                return $rows;
            }
        }
}
