<?php
/**
* @title			Responsive Scroller for K2
* @copyright   		Copyright (C) 2011-2017 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   	https://www.minitek.gr/
* @developers   	Minitek.gr
*/

// no direct access
defined('_JEXEC') or die('Restricted access');
?>
 
<div id="<?php echo $rsck2; ?>" class="owl-carousel owl-theme rsck2 <?php echo $theme; ?>">

	<?php foreach($items as $key=>$item) { ?>
    
		<?php
		if ($show_image && isset($item->itemImage) && $item->itemImage) {
			$active_class = '';
		}
		else
		{
			$active_class = 'no-image';
		}
		?>
        <div class="rsck2-item <?php echo $active_class; ?>">
        	
            <?php if ($show_image && isset($item->itemImage) && $item->itemImage) { ?>
                <div class="rsck2-media">
					<a href="<?php echo $item->itemLink; ?>">
                    	<img class="lazyOwl" data-src="<?php echo $item->itemImage; ?>" src="<?php echo $item->itemImage; ?>" alt="<?php echo htmlspecialchars($item->title); ?>">
					</a>
                </div>    
            <?php } ?>  
            
			<?php if ($show_title) { ?>
                <div class="rsck2-title go-to-top">
                    <h4>
                        <a href="<?php echo $item->itemLink; ?>"><?php echo $item->itemTitle; ?></a>
                    </h4>
                </div>
            <?php } ?>
             
			<?php if ($detail_box) { ?>
                
				<div class="rsck2-details">
                
                	<div class="reveal_wrapper">
                    
						<?php if ($show_introtext) { ?>
							<div class="rsck2-intro-outer">
								<span class="rsck2-intro txt-center"><?php echo $item->itemIntrotext; ?></span>
							</div>
						<?php } ?>
						
						<?php if ($show_date) { ?>
							<div class="rsck2-date">
								<?php echo $item->itemDate; ?>
							</div>
						<?php } ?>
						
						<?php if ($show_category || $show_author || $show_hits) { ?>
					
							<div class="rsck2-extras">
								
								<?php if ($show_category) { ?>
									<span class="rsck2-category">
										<?php echo JText::_('MOD_RESPONSIVE_SCROLLER_FOR_K2_IN'); ?>&nbsp;
										<a href="<?php echo $item->itemCategoryLink; ?>"><?php echo $item->itemCategory; ?></a>&nbsp;
									</span>
								<?php }?>
								
								<?php if ($show_author) { ?>
									<span class="rsck2-author">
										<?php echo JText::_('MOD_RESPONSIVE_SCROLLER_FOR_K2_BY'); ?>&nbsp;
										<a href="<?php echo $item->itemAuthorLink; ?>"><?php echo $item->itemAuthor; ?></a>&nbsp;
									</span>
								<?php }?>
																		
								<?php if ($show_hits) { ?>
									<p class="rsck2-hits">
										<?php echo $item->itemHits; ?>&nbsp;<?php echo JText::_('MOD_RESPONSIVE_SCROLLER_FOR_K2_HITS'); ?>
									</p>
								<?php }?>
								
							</div>
							
						<?php }?>
						
						<?php if ($show_readmore) { ?>
							<div class="rsck2-readmore">
								<a href="<?php echo $item->itemLink; ?>"><?php echo JText::_('MOD_RESPONSIVE_SCROLLER_FOR_K2_READ_MORE'); ?></a>
							</div>
						<?php } ?>
                    
                    </div>
                            
                </div>
            <?php } ?>
            
            <a class="reveal_opener show_on_hover">
                <span class="openme">+</span>
                <span class="closeme">-</span>
            </a>
                        
        </div>
    
    <?php } ?>
    
</div>