<?php
/**
* @title			Responsive Scroller for K2
* @copyright   		Copyright (C) 2011-2017 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   	https://www.minitek.gr/
* @developers   	Minitek.gr
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

if(!defined('DS')){
	define('DS',DIRECTORY_SEPARATOR);
}

// Get Helper function
require_once JPATH_SITE.DS.'modules'.DS.'mod_responsive_scroller_for_k2'.DS.'helper.php';

// Load PHP Thumb Factory Library
if ($params->get('load_phpthumb', true)) {
	if( !defined('PhpThumbFactoryLoaded') ) {
		require_once dirname(__FILE__).DS.'admin'.DS.'phpthumb/ThumbLib.inc.php';
		define('PhpThumbFactoryLoaded',1);
	}
}

// Define module id
$module_id = $module->id;
if ($params->get('auto_module_id', true)) {
	$rsck2 = 'rsck2-'.$module_id;
} else {
	$rsck2 = ''.$params->get('custom_module_id', ''); 
}

// Add stylesheets
$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base().'modules/mod_responsive_scroller_for_k2/assets/css/owl.carousel.css');
$document->addStyleSheet(JURI::base().'modules/mod_responsive_scroller_for_k2/assets/css/owl.theme.default.css');
$document->addStyleSheet(JURI::base().'modules/mod_responsive_scroller_for_k2/assets/css/style.css');
if ($params->get('load_lightbox', true)) {
	$document->addStyleSheet(JURI::base().'modules/mod_responsive_scroller_for_k2/assets/lightbox/lightbox.min.css');
}
if ($params->get('load_fontawesome', true)) {
	$document->addStyleSheet("https://netdna.bootstrapcdn.com/font-awesome/4.6.0/css/font-awesome.css");
}

// Add scripts
if ($params->get('load_jquery', false)) {
	JHtml::_('jquery.framework');
}
$document->addScript(JURI::base().'modules/mod_responsive_scroller_for_k2/assets/js/owl.carousel.min.js');
if ($params->get('load_lightbox', true)) {
	$document->addScript(JURI::base().'modules/mod_responsive_scroller_for_k2/assets/lightbox/lightbox.min.js');
}

// Basic Params
$theme = $params->get('theme', 'rsck2-light');
$items_spacing = (int)$params->get('items_spacing', 10);
$show_image = $params->get('show_image', 1);
$detail_box = $params->get('detail_box', 1);
$show_title = $params->get('show_title', 1);
$show_introtext = $params->get('show_introtext', 1);
$show_date = $params->get('show_date', 1);
$show_category = $params->get('show_category', 1);
$show_author = $params->get('show_author', 1);
$show_hits = $params->get('show_hits', 0);
$show_readmore = $params->get('show_readmore', 0);
$hover_box = $params->get('hover_box', 1);
$hover_link = $params->get('hover_link', 1);
$hover_lightbox = $params->get('hover_lightbox', 1);

// Effects params
$nav_speed = (int)$params->get('nav_speed', 500);
$dots_speed = (int)$params->get('dots_speed', 500);
if ($params->get('autoplay', 0)) {
	$autoplay = 'true';
} else {
	$autoplay = 'false';
}
$autoplay_speed = (int)$params->get('autoplay_speed', 3000);
$stop_on_hover = $params->get('stop_on_hover', 0);
if ($stop_on_hover) {
	$stop_on_hover = 'true';	
} else {
	$stop_on_hover = 'false';
}
if ($params->get('autoheight', 0)) {
	$autoheight = 'true';
} else {
	$autoheight = 'false';
}

// Navigation params
$nav_arrow = $params->get('nav_arrow', 1);
if ($nav_arrow) {
	$nav_arrow = 'true';	
} else {
	$nav_arrow = 'false';
}

$dots = $params->get('dots', 0); 
if ($dots) {
	$dots = 'true';	
} else {
	$dots = 'false';
}

$drag = $params->get('drag', 0);
if ($drag) {
	$drag = 'true';	
} else {
	$drag = 'false';
}

$rewind = $params->get('rewind', 0); 
if ($rewind) {
	$rewind = 'true';	
} else {
	$rewind = 'false';
}

$loop = $params->get('loop', 0); 
if ($loop) {
	$loop = 'true';	
} else {
	$loop = 'false';
}

if ($params->get('center', 0)) {
	$center = 'true';
} else {
	$center = 'false';
}
if ($params->get('rtl', 0)) {
	$rtl = 'true';
	$navText = '["<i class=\"fa fa-angle-right\"></i>","<i class=\"fa fa-angle-left\"></i>"]';
} else {
	$rtl = 'false';
	$navText = '["<i class=\"fa fa-angle-left\"></i>","<i class=\"fa fa-angle-right\"></i>"]';
}

// Responsive params
$responsive = $params->get('responsive', 1); 
$responsive_lg_num = (int)$params->get('responsive_lg_num', 4);
$responsive_md_num = (int)$params->get('responsive_md_num', 3);
$responsive_sm_num = (int)$params->get('responsive_sm_num', 2);
$responsive_xs_num = (int)$params->get('responsive_xs_num', 1);
$responsive_xxs_num = (int)$params->get('responsive_xxs_num', 1);
$responsive_lg = (int)$params->get('responsive_lg', 1139);
$responsive_md = (int)$params->get('responsive_md', 939);
$responsive_sm = (int)$params->get('responsive_sm', 719);
$responsive_xs = (int)$params->get('responsive_xs', 479);
if ($responsive) {
	$starting_items = $responsive_xxs_num;
	$responsive = '{				
						'.$responsive_xs.'	:{
							items: '.$responsive_xs_num.'
						},
						'.$responsive_sm.'	:{
							items: '.$responsive_sm_num.'
						},
						'.$responsive_md.'	:{
							items: '.$responsive_md_num.'
						},
						'.$responsive_lg.'	:{
							items: '.$responsive_lg_num.'
						}
}';	
} else {
	$starting_items = $responsive_lg_num;
	$responsive = 'false';
}

// Module script
$document->addScriptDeclaration(
   '(function($) {
		$(function(){
			
			jQuery("#'.$rsck2.'").owlCarousel({
				
				items 					: '.$starting_items.',
				margin					: '.$items_spacing.',
				loop					: '.$loop.',
				center					: '.$center.',
				mouseDrag 				: '.$drag.',
				touchDrag 				: '.$drag.',
				pullDrag 				: true,
				freeDrag 				: false,
				stagePadding			: 0,
				merge					: false,
				mergeFit				: true,
				autoWidth				: false,
				startPosition			: 0,
				URLhashListener			: false,
				nav						: '.$nav_arrow.',
				rewind					: '.$rewind.',
				navText					: '.$navText.',
				navElement				: "div",
				slideBy					: 1,
				dots					: '.$dots.',
				dotsEach				: false,
				dotData					: false,
				lazyLoad				: false,
				lazyContent				: false,
				autoplay				: '.$autoplay.',
				autoplayTimeout			: '.$autoplay_speed.',						
				autoplayHoverPause		: '.$stop_on_hover.',
				smartSpeed				: 100,
				autoplaySpeed			: '.$nav_speed.',
				navSpeed				: '.$nav_speed.',
				dotsSpeed				: '.$dots_speed.',
				dragEndSpeed			: '.$nav_speed.',
				callbacks				: true,
				responsive				: '.$responsive.',
				responsiveRefreshRate	: 200,
				responsiveBaseElement	: window,
				video					: false,
				videoHeight				: false,
				videoWidth				: false,
				animateOut				: false,
				animateIn				: false,
				fallbackEasing			: "swing",
				info					: false,
				nestedItemSelector		: false,
				itemElement				: "div",
				stageElement			: "div",
				navContainer			: false,
				dotsContainer			: false,
				rtl						: '.$rtl.',
				refreshClass			: "owl-refresh",
				loadingClass			: "owl-loading",
				loadedClass				: "owl-loaded",
				rtlClass				: "owl-rtl",
				dragClass				: "owl-drag",
				grabClass				: "owl-grab",
				stageClass				: "owl-stage",
				stageOuterClass			: "owl-stage-outer",
				navContainerClass		: "owl-nav",
				controlsClass			: "owl-controls",
				dotClass				: "owl-dot",
				dotsClass				: "owl-dots",
				autoHeight				: '.$autoheight.',
				autoHeightClass			: "owl-height",
				responsiveClass			: false
				
			});
			
		})
	})(jQuery);'
);

if ($params->get('theme', 'rsck2-light') == 'rsck2-modern') {
	if ($params->get('show_introtext', 1)) {
		$document->addScriptDeclaration(
		   'jQuery(document).ready(function() {
				jQuery("#'.$rsck2.'.rsck2-modern .rsck2-media").on("mouseover",function(){
					var introtext_height = jQuery(this).find(".rsck2-intro").innerHeight();
					jQuery(this).find(".rsck2-intro-outer").css({"height":introtext_height+"px"});
				});
				jQuery("#'.$rsck2.'.rsck2-modern .rsck2-media").on("mouseout",function(){
					jQuery(this).find(".rsck2-intro-outer").css({"height":"0"});
				});
		   });
		   '
		); 
	}
} 

if ($params->get('theme', 'rsck2-light') == 'rsck2-caption') {	
	$document->addScriptDeclaration(
	   'jQuery(document).ready(function() {
			jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item .reveal_opener .openme").on("click",function(){
				jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item").removeClass("revactive");
				jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item .closeme").hide();
				jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item .openme").show(); 
				jQuery(this).parent().parent().addClass("revactive");
				jQuery(this).hide();
				jQuery(".closeme", jQuery(this).parent()).css({"display":"block"});
			});
			jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item .reveal_opener .closeme").on("click",function(){
				jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item").removeClass("revactive");
				jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item .closeme").hide();
				jQuery("#'.$rsck2.'.rsck2-caption .rsck2-item .openme").show(); 
			});
	   });
	   '
	);
}

// Get Helper function
$items = ResponsiveScrollerForK2Helper::getItems($params, $module_id);

require(JModuleHelper::getLayoutPath('mod_responsive_scroller_for_k2', $params->get('layout', 'default')));

