<?php
/**
* @title			Responsive Scroller for K2
* @copyright   		Copyright (C) 2011-2017 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   	https://www.minitek.gr/
* @developers   	Minitek.gr
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');

class ResponsiveScrollerForK2Helper
{
	
	public static function getItems(&$params, $module_id, $format = 'html')
	{
	  			
		jimport('joomla.filesystem.file');
		$mainframe = JFactory::getApplication();
		
		// Params
		$data_source = $params->get('data_source', 'custom_filtering');
		$cid = $params->get('category_id', NULL);
		$ordering = $params->get('items_order', '');
		$limit = $params->get('item_count', 8);
		$category_type = $params->get('category_filtering_type', true) ? 'IN' : 'NOT IN';
		$tag_type = $params->get('tag_filtering_type', true);
		$tagIds = $params->get('k2_tags', '');
		if ($tagIds)
			$tag_string = implode(',', $tagIds);
		
		// Exclude items script
		$excluded = $params->get('exclude_k2_items', '');
		if (preg_match('/^[0-9,]+$/i', $excluded)) {
		  $excluded_str = $excluded;
		} else {
		  $excluded_str = '0';
		}  
		
		// Get variables
		$componentParams = JComponentHelper::getParams('com_k2');
		$limitstart = JRequest::getInt('limitstart');
		$user = JFactory::getUser();
		$aid = $user->get('aid');
		$db = JFactory::getDBO();
		$jnow = JFactory::getDate();
		$now =  K2_JVERSION == '15'?$jnow->toMySQL():$jnow->toSql();
		$nullDate = $db->getNullDate();
    		
		// Data source = Specific Items
		if ($data_source == 'specific_items')
		{
			$value = $params->get('k2_items', '');
			$current = array();
			if (is_string($value) && !empty($value))
				$current[] = $value;
			if (is_array($value))
				$current = $value;

			$items = array();

			foreach ($current as $id)
			{

				$query = "SELECT i.*, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams
				
				FROM #__k2_items as i
				LEFT JOIN #__k2_categories c ON c.id = i.catid
				WHERE i.published = 1 ";
				if (K2_JVERSION != '15')
				{
					$query .= " AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
				}
				else
				{
					$query .= " AND i.access<={$aid} ";
				}
				$query .= " AND i.trash = 0 AND c.published = 1 ";
				if (K2_JVERSION != '15')
				{
					$query .= " AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
				}
				else
				{
					$query .= " AND c.access<={$aid} ";
				}
				$query .= " AND c.trash = 0 
				AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." ) 
				AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." ) 
				AND i.id={$id}";
				if (K2_JVERSION != '15')
				{
					if ($mainframe->getLanguageFilter())
					{
						$languageTag = JFactory::getLanguage()->getTag();
						$query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
					}
				}
				
				$db->setQuery($query);
				$item = $db->loadObject();
				if ($item)
					$items[] = $item;

			}
		}
    
		// Data source = Custom filtering
		else if ($data_source == 'custom_filtering')
		{
			$query = "SELECT i.*, CASE WHEN i.modified = 0 THEN i.created ELSE i.modified END as lastChanged, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";

			if ($ordering == 'best')
				$query .= ", (r.rating_sum/r.rating_count) AS rating";

			if ($ordering == 'comments')
				$query .= ", COUNT(comments.id) AS numOfComments";

			$query .= " FROM #__k2_items as i LEFT JOIN #__k2_categories c ON c.id = i.catid";

			if ($ordering == 'best')
				$query .= " LEFT JOIN #__k2_rating r ON r.itemID = i.id";

			if ($ordering == 'comments')
				$query .= " LEFT JOIN #__k2_comments comments ON comments.itemID = i.id";
			
			if ($tagIds)
			{	
				$query .= " LEFT JOIN #__k2_tags_xref tags_xref ON tags_xref.itemID = i.id LEFT JOIN #__k2_tags tags ON tags.id = tags_xref.tagID ";
			}
			
			if (K2_JVERSION != '15')
			{
				$query .= " WHERE i.published = 1 AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") AND i.trash = 0 AND c.published = 1 AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).")  AND c.trash = 0";
			}
			else
			{
				$query .= " WHERE i.published = 1 AND i.access <= {$aid} AND i.trash = 0 AND c.published = 1 AND c.access <= {$aid} AND c.trash = 0";
			}
			
			$query .= " AND i.id NOT IN ({$excluded_str}) ";

			$query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )";
			$query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";
			
			if ($params->get('catfilter', false))
			{
				if (!is_null($cid))
				{
					if (is_array($cid))
					{
						if ($params->get('getChildren', true))
						{
							$itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
							$categories = $itemListModel->getCategoryTree($cid);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid ".$category_type." ({$sql})";

						}
						else
						{
							JArrayHelper::toInteger($cid);
							$query .= " AND i.catid ".$category_type." (".implode(',', $cid).")";
						}
					}
					else
					{
						if ($params->get('getChildren', true))
						{
							$itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
							$categories = $itemListModel->getCategoryTree($cid);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid ".$category_type." ({$sql})";
						}
						else
						{
							$query .= " AND i.catid ".$category_type." (".(int)$cid.")";
						}

					}
				}
			}

			if ($params->get('FeaturedItems', true) == '0')
				$query .= " AND i.featured != 1";

			if ($params->get('FeaturedItems', true) == '2')
				$query .= " AND i.featured = 1";

			if ($params->get('videosOnly', false))
				$query .= " AND (i.video IS NOT NULL AND i.video!='')";

			if ($ordering == 'comments')
				$query .= " AND comments.published = 1";

			if (K2_JVERSION != '15') 
			{
				if ($mainframe->getLanguageFilter())
				{
					$languageTag = JFactory::getLanguage()->getTag();
					$query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
				}
			}
			
			if ($tagIds)
			{
				if ($tag_type)
				{
					$query .= " AND tags_xref.tagID IN (".$tag_string.")";
				} else {
					$query .= " AND (tags_xref.tagID IS NULL OR tags_xref.tagID NOT IN (".$tag_string."))";
				}
			}

			switch ($ordering)
			{
				case 'date' :
					$orderby = 'i.created ASC';
					break;

				case 'rdate' :
					$orderby = 'i.created DESC';
					break;

				case 'alpha' :
					$orderby = 'i.title';
					break;

				case 'ralpha' :
					$orderby = 'i.title DESC';
					break;

				case 'order' :
					if ($params->get('FeaturedItems', true) == '2')
						$orderby = 'i.featured_ordering';
					else
						$orderby = 'i.ordering';
					break;

				case 'rorder' :
					if ($params->get('FeaturedItems', true) == '2')
						$orderby = 'i.featured_ordering DESC';
					else
						$orderby = 'i.ordering DESC';
					break;

				case 'hits' :
					if ($params->get('popularityRange', ''))
					{
						$datenow = JFactory::getDate();
						$date =  K2_JVERSION == '15'?$datenow->toMySQL():$datenow->toSql();
						$query .= " AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange', '')." DAY) ";
					}
					$orderby = 'i.hits DESC';
					break;

				case 'rand' :
					$orderby = 'RAND()';
					break;

				case 'best' :
					$orderby = 'rating DESC';
					break;

				case 'comments' :
					if ($params->get('popularityRange', ''))
					{
						$datenow = JFactory::getDate();
						$date =  K2_JVERSION == '15'?$datenow->toMySQL():$datenow->toSql();
						$query .= " AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange', '')." DAY) ";
					}
					$query .= " GROUP BY i.id ";
					$orderby = 'numOfComments DESC';
					break;

				case 'modified' :
					$orderby = 'lastChanged DESC';
					break;

				case 'publishUp' :
					$orderby = 'i.publish_up DESC';
					break;

				default :
					$orderby = 'i.id DESC';
					break;
			}

			$query .= " GROUP BY i.id ";
			$query .= " ORDER BY ".$orderby;
			
			$db->setQuery($query, 0, $limit);
			$items = $db->loadObjectList();
		}

		$model = K2Model::getInstance('Item', 'K2Model');
		
		// Display parameters
		$show_image = $params->get('show_image', 1);
		$imageWidth = (int)$params->get('image_width', 500);
        $imageHeight = (int)$params->get('image_height', 350);
		$show_title = $params->get('show_title', 1);
		$title_limit = (int)$params->get('title_limit', 4);
		$show_introtext = $params->get('show_introtext', 1);
		$introtext_limit = (int)$params->get('introtext_limit', 15);
		$show_date = $params->get('show_date', 1);
		$date_format = $params->get('date_format', 'l F d');
		$show_category = $params->get('show_category', 1);
		$show_author = $params->get('show_author', 1);
		$author_name = $params->get('author_name', 'name');
		$show_hits = $params->get('show_hits', 0);
		
		if (count($items))
		{

			foreach ($items as $key=>$item)
			{				
				// Item link
				$item->itemLink = urldecode(JRoute::_(K2HelperRoute::getItemRoute($item->id.':'.urlencode($item->alias), $item->catid.':'.urlencode($item->categoryalias))));
				
				// Cut title
				if ($show_title) 
				{
					$item->title = JFilterOutput::ampReplace($item->title);
					$item->itemTitle = K2HelperUtilities::wordLimit($item->title, $title_limit);
				}
				
				// Introtext
				$item->itemIntrotext = $item->introtext;
				
				// Allow plugins in introtext
				if (!$params->get( 'allowplugins', 0)) 
				{
					$item->itemIntrotext = preg_replace('/\{.*\}/', '', $item->itemIntrotext);
					$item->itemIntrotext = preg_replace('/\[.*\]/', '', $item->itemIntrotext);
				}
				else
				{
					// Plugin events
					JPluginHelper::importPlugin('content');
					$item->itemIntrotext = JHtml::_('content.prepare', $item->itemIntrotext);
				}
				
				// Strip tags			
				if ($show_introtext) 
				{
					if ($params->get('strip_tags', 1)) 
					{
						$item->itemIntrotext = K2HelperUtilities::wordLimit($item->itemIntrotext, $introtext_limit);
					}
				}
								
				// Format date
				if ($show_date) 
				{
					$item->itemDate = JHTML::_('date', $item->created, $date_format);
				}
				
				// Images
				if ($show_image) 
				{
					$date = JFactory::getDate($item->modified);
					$timestamp = '?t='.$date->toUnix();
	
					// Get Image
					$imageSize = $params->get('k2_image_size', 'XL');
					$item->itemImage = false;
					
					if ($params->get('image_type', 'k2') == 'k2')
					{
						if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_'.$imageSize.'.jpg'))
						{
							$item->rawitemImage = 'media/k2/items/cache/'.md5("Image".$item->id).'_'.$imageSize.'.jpg';
							if ($componentParams->get('imageTimestamp'))
							{
								$item->rawitemImage .= $timestamp;
							}
							
							// Define new images
							$item->itemImage = $item->rawitemImage;
						}
					}
					// Get Inline Image
					else if ($params->get('image_type', 'k2') == 'inline' || !$item->itemImage)
					{
						$item_text = $item->introtext.' '.$item->fulltext;
						$introtext_temp = strip_tags($item_text, '<img>');
						preg_match('/<img[^>]+>/i', $introtext_temp, $new_image);
						$src = false;	
						if ($new_image) {
							$doc = new DOMDocument();
							$doc->loadHTML($new_image[0]);
							$xpath = new DOMXPath($doc);
							$src = $xpath->evaluate("string(//img/@src)"); 
						}
						if ($src) {
							$item->itemImage = $src;
						}
					}
					
					// Image fallback
					if (!$item->itemImage && $params->get('fallback_image', ''))
					{
						$item->itemImage = JURI::root().''.$params->get('fallback_image', '');	
					}
						
					// Crop images
					if ($params->get('crop_images', 0))
					{
						if ( $item->itemImage && $image = self::renderImages($item->itemImage, $imageWidth, $imageHeight, $item->title ) ) {
							$item->itemImage = $image;
						}
					}
				}

				// Category link
				if ($show_category) 
				{
					$item->itemCategory = $item->categoryname;
					$item->itemCategoryLink = urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($item->catid.':'.urlencode($item->categoryalias))));
				}
				
				// Author
				if ($show_author)
				{
					if (!empty($item->created_by_alias))
					{
						$item->itemAuthor = $item->created_by_alias;
						$item->itemAuthorLink = Juri::root(true);
					}
					else
					{
						$author = JFactory::getUser($item->created_by);
						
						$item->itemAuthor = $author->$author_name;
						$item->itemAuthorLink = JRoute::_(K2HelperRoute::getUserRoute($item->created_by));
					}
				}
				
				// Hits
				if ($show_hits)
				{
					$item->itemHits = $item->hits;
				}
				
				// Tags
				/*if ($params->get('tag_filter_type'))
				{
					$tags = $model->getItemTags($item->id);
					for ($i = 0; $i < sizeof($tags); $i++)
					{
						$tags[$i]->link = JRoute::_(K2HelperRoute::getTagRoute($tags[$i]->name));
					}
					$item->itemTags = $tags;
				}*/
												
				$rows[] = $item;
				
			}
			
			return $rows;

		}

	}
	
	public static function makeDir( $path ){
		$folders = explode ( '/',  ( $path ) );
		$tmppath =  JPATH_SITE.DS.'images'.DS.'rsck2'.DS;
		if( !file_exists($tmppath) ) {
			JFolder::create( $tmppath, 0755 );
		}; 
		for( $i = 0; $i < count ( $folders ) - 1; $i ++) {
			if (! file_exists ( $tmppath . $folders [$i] ) && ! JFolder::create( $tmppath . $folders [$i], 0755) ) {
				return false;
			}	
			$tmppath = $tmppath . $folders [$i] . DS;
		}		
		return true;
	}
	
	public static function renderImages( $path, $width, $height, $title='' ) 
	{	
	
	  $path = str_replace( JURI::base(), '', $path );
		$imgSource = JPATH_SITE.DS. str_replace( '/', DS,  $path );
		if ( file_exists($imgSource)  ) 
		{
		  $path =  $width."x".$height.'/'.$path;
			$thumbPath = JPATH_SITE.DS.'images'.DS.'rsck2'.DS. str_replace( '/', DS,  $path );
			if ( !file_exists($thumbPath) ) 
			{
			  $thumb = PhpThumbFactory::create( $imgSource  );  
				if( !self::makeDir( $path ) ) 
				{
					return '';
				}		
				$thumb->adaptiveResize( $width, $height);
				$thumb->save( $thumbPath  ); 
			}
			$path = JURI::base().'images/rsck2/'.$path;
		} 
		
		return $path;
	}

}
