<?php
defined('_JEXEC') or die;

$direction = JFactory::getDocument()->getDirection();
if($direction == 'rtl') {
    $classSuffix = "right";
    $reverseClassSuffix = "left";
}
else {
    $classSuffix = "left";
    $reverseClassSuffix = "right";
}

$menuItems = JBMenuHelper::getList($params);

$menuItemsIdLevel2 = array();
$menuItemsIdLevel3 = array();
$menuItemsIdLevel4 = array();
?>

<div class="setAllWindowToMenu"></div>

<nav class="navbar menuParentNavbar navbar-expand-md navbar-dark">
    <a class="navbar-brand jbMenuTitle" href="<?php echo JRoute::_(JUri::root().'?Itemid='.$params->get('menuTitleLink')); ?>">
        <?php
        if($params->get('menuTitleType') == 'text')
            echo $params->get('menuTitleText');
        else if($params->get('menuTitleType') == 'logo')
            echo "<img src='".JUri::root().$params->get('menuTitleLogo')."' height='50px' />";
        ?>
    </a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#desktopParentNavbarContent" aria-controls="desktopParentNavbarContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="desktopParentNavbarContent">
        <div class="row">
            <div class="col-xs-12">
                <?php
                if(count($menuItems)) {?>
                    <ul class="navbar-nav mr-auto">
                        <?php
                        foreach ($menuItems[1] as $item) {
                            if(isset($menuItems[$item->id])) {?>
                                <li class="parentItem level1" itemId="<?php echo $item->id; ?>" level="1">
                                    <?php
                                    $menuClass = "hasSubMenu nav-link";
                                    switch ($item->type) :
                                        case 'separator':
                                        case 'component':
                                        case 'heading':
                                        case 'url':
                                            require JModuleHelper::getLayoutPath($module->module, $layout.'_'.$item->type);
                                            break;

                                        default:
                                            require JModuleHelper::getLayoutPath($module->module, $layout.'_url');
                                            break;
                                    endswitch;
                                    ?>
                                </li>
                                <?php
                            }
                            else { ?>
                                <li>
                                    <?php
                                    $menuClass = "nav-link";
                                    switch ($item->type) :
                                        case 'separator':
                                        case 'component':
                                        case 'heading':
                                        case 'url':
                                            require JModuleHelper::getLayoutPath($module->module, $layout.'_'.$item->type);
                                            break;

                                        default:
                                            require JModuleHelper::getLayoutPath($module->module, $layout.'_url');
                                            break;
                                    endswitch;
                                    ?>
                                </li>
                                <?php
                            }
                        }
                        ?>
                    </ul>
                <?php
                } ?>
            </div>
        </div>
    </div>

    <button type="button" class="close" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</nav>

<div class="menuChildrenNavbar container">
    <div class="menuRouter container">
        <a class="back">
            <span class="fa fa-angle-<?php echo $classSuffix; ?>"></span> <?php echo JText::_('MOD_JB_MENU_BACK_LABEL'); ?>
        </a>
        <br />
        <div>
            <ul class="navbar-nav navigators">
                <li class="navigate navigate1" level="1" itemId="">&nbsp;&nbsp;&nbsp;&nbsp;</li>
                <li class="navigate navigate2" level="2" itemId="">&nbsp;&nbsp;&nbsp;&nbsp;</li>
                <li class="navigate navigate3" level="3" itemId="">&nbsp;&nbsp;&nbsp;&nbsp;</li>
                <li class="navigate navigate4" level="4" itemId="">&nbsp;&nbsp;&nbsp;&nbsp;</li>
            </ul>
        </div>
        <div class="menuRouterLine"></div>
    </div>
    <div id="mobileChildrenNavbarContent">
        <div id="mobileParentNavbarContent">
            <?php
            if(count($menuItems)) { ?>
                <ul class="navbar-nav">
                    <li class="emptyItem"></li>
                    <?php
                    foreach ($menuItems[1] as $item) {
                        if(isset($menuItems[$item->id])) {?>
                            <li class="childItem level1" itemId="<?php echo $item->id; ?>" level="1">
                                <?php
                                $menuTitle = $item->title.'<span class="fa fa-angle-'.$reverseClassSuffix.' pull-'.$reverseClassSuffix.'"></span>';
                                $menuClass = "hasSubMenu nav-link";
                                switch ($item->type) :
                                    case 'separator':
                                    case 'component':
                                    case 'heading':
                                    case 'url':
                                        require JModuleHelper::getLayoutPath($module->module, $layout.'_'.$item->type);
                                        break;

                                    default:
                                        require JModuleHelper::getLayoutPath($module->module, $layout.'_url');
                                        break;
                                endswitch;
                                ?>
                            </li>
                            <?php
                        }
                        else {?>
                            <li>
                                <?php
                                $menuClass = "nav-link";
                                switch ($item->type) :
                                    case 'separator':
                                    case 'component':
                                    case 'heading':
                                    case 'url':
                                        require JModuleHelper::getLayoutPath($module->module, $layout.'_'.$item->type);
                                        break;

                                    default:
                                        require JModuleHelper::getLayoutPath($module->module, $layout.'_url');
                                        break;
                                endswitch;
                                ?>
                            </li>
                            <?php
                        }
                    }
                    ?>
                </ul>
                <?php
            }
            ?>
        </div>
        <div id="mobileChildSection">
            <?php
            if(count($menuItems)) {
                foreach ($menuItems[1] as $item) {
                    require JModuleHelper::getLayoutPath($module->module, $layout . '_level2');
                }
            }
            ?>

            <?php
            if(count($menuItemsIdLevel3)) {
                foreach ($menuItemsIdLevel3 as $id=>$value) {
                    foreach ($menuItems[$id] as $item) {
                        require JModuleHelper::getLayoutPath($module->module, $layout . '_level3');
                    }
                }
            }
            ?>

            <?php
            if(count($menuItemsIdLevel4)) {
                foreach ($menuItemsIdLevel4 as $id=>$value) {
                    foreach ($menuItems[$id] as $item) {
                        require JModuleHelper::getLayoutPath($module->module, $layout . '_level4');
                    }
                }
            }
            ?>
        </div>
    </div>

    <div id="desktopChildrenNavbarContent">
        <div class="row">
            <div class="col-xs-12 col-sm-4 col-md-4 desktopParentSection">
                <?php
                if(count($menuItems)) {
                    foreach ($menuItems[1] as $item) {
                        require JModuleHelper::getLayoutPath($module->module, $layout . '_level2');
                    }
                }
                ?>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4 desktopChildSection">
                <?php
                if(count($menuItemsIdLevel3)) {
                    foreach ($menuItemsIdLevel3 as $id=>$value) {
                        foreach ($menuItems[$id] as $item) {
                            require JModuleHelper::getLayoutPath($module->module, $layout . '_level3');
                        }
                    }
                }
                ?>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4 desktopChildSection">
                <?php
                if(count($menuItemsIdLevel4)) {
                    foreach ($menuItemsIdLevel4 as $id=>$value) {
                        foreach ($menuItems[$id] as $item) {
                            require JModuleHelper::getLayoutPath($module->module, $layout . '_level4');
                        }
                    }
                }
                ?>
            </div>
        </div>
    </div>
</div>

<?php
require JModuleHelper::getLayoutPath($module->module, $layout.'_java_css');
?>