jQuery(document).ready(function () {
    //define body tag
    body = jQuery('body');

    //define div for cover all window
    setAllWindowToMenu = jQuery('.setAllWindowToMenu');

    //define parent navbar
    menuParentNavbar = jQuery('.menuParentNavbar');

    //define close icon for close children navbar
    closeIcon = jQuery('.menuParentNavbar .close');

    //define toggler icon for open children navbar in mobile
    toggleIcon = jQuery('.menuParentNavbar .navbar-toggler');

    //define parent navbar content for display in desktop
    desktopParentNavbarContent = jQuery('#desktopParentNavbarContent');

    //define parent navbar content for display in mobile
    mobileParentNavbarContent = jQuery('#mobileParentNavbarContent');

    //define children navbar
    menuChildrenNavbar = jQuery('.menuChildrenNavbar');

    //define children navbar content for display in desktop
    desktopChildrenNavbarContent = jQuery('#desktopChildrenNavbarContent');

    //define children navbar content for display in mobile
    mobileChildrenNavbarContent = jQuery('#mobileChildrenNavbarContent');

    //define children items content for display in mobile
    mobileChildSection = jQuery('#mobileChildSection');

    //define parent item in parent navbar
    parentItem = jQuery('.menuParentNavbar .parentItem');

    //define child item in children navbar
    childItem = jQuery('.menuChildrenNavbar .childItem');

    //define child items in children navbar content
    childItemId = jQuery('.childItemId');

    //define div for menu router content
    menuRouter = jQuery('.menuRouter');

    //define back navigate for back menu
    menuBack = jQuery('.menuRouter .back');

    //define navigate for back menu
    menuNavigate = jQuery('.menuRouter .navigate');

    //define device used, mobile or desktop
    isDesktop = window.matchMedia("only screen and (min-width: 768px)");
    if(isDesktop.matches)
        device = 'desktop';
    else
        device = 'mobile';

    collapseMenuTitle(device, 'hide');

    currentDevice = device;
    jQuery(window).resize(function () {
        isDesktop = window.matchMedia("only screen and (min-width: 768px)");
        if(isDesktop.matches)
            device = 'desktop';
        else
            device = 'mobile';

        if(device != currentDevice) {
            collapseChildrenNavbar(device, 'hide', null, null);
            collapseMenuTitle(device, 'hide');
        }

        currentDevice = device;
    });


    //prevent link to href in items that has hasSubMenu class
    jQuery('.hasSubMenu').click(function (event) {
        event.preventDefault();
    });

    //close children navbar
    closeIcon.click(function () {
        collapseChildrenNavbar(device, 'hide', 'closeIcon', this);
    });

    //open children navbar in mobile
    toggleIcon.click(function () {
        collapseChildrenNavbar(device, 'show', 'toggleIcon', this);
    });


    //open children navbar in desktop when click on parent item
    var timer;
    window.showForParentId = -1;
    parentItem.hover(function() {
            var tempObject = this;
            timer = setTimeout(function() {
                if(window.showForParentId != jQuery(tempObject).attr('itemId'))
                    collapseChildrenNavbar(device, 'show', 'parentItem', tempObject);

                window.showForParentId = jQuery(tempObject).attr('itemId');
            }, window.jbMenuDelay);
        },
        function() {
            clearTimeout(timer);
    });

    //open or expand children navbar in desktop or mobile when click on child item
    childItem.click(function () {
        collapseChildrenNavbar(device, 'show', 'childItem', this);
    });

    //when click on back navigate bar
    menuBack.click(function() {
        collapseChildrenNavbar(device, 'show', 'navigate', this);
    });

    //when click on navigate bar
    menuNavigate.click(function() {
        collapseChildrenNavbar(device, 'show', 'navigate', this);
    });
});
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function collapseMenuTitle(device, mode) {
    jbMenuTitle = jQuery('.jbMenuTitle');

    if(window.jbMenuTitleDevice == 0)
        jbMenuTitle.hide();
    else {
        if(window.jbMenuTitleDevice == 'both' || window.jbMenuTitleDevice == device) {
            if(window.jbMenuTitleDisplay == 'both')
                jbMenuTitle.show();
            else if(window.jbMenuTitleDisplay == mode)
                jbMenuTitle.show();
            else
                jbMenuTitle.hide();
        }
        else
            jbMenuTitle.hide();
    }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function collapseChildrenNavbar(device, mode, type, object) {
    if (mode == 'show') {
        if(type == 'parentItem') {
            collapseChildrenNavbar(device, 'hide', 'parentItem', null);
        }

        collapseMenuTitle(device, 'show');

        setAllWindowToMenu.css('top', parseFloat(menuParentNavbar.offset().top) - parseFloat(jQuery(window).scrollTop()));
        setAllWindowToMenu.css('height', parseFloat(menuParentNavbar.offset().top) + parseFloat(jQuery(window).outerHeight()));
        setAllWindowToMenu.fadeIn(500);

        body.addClass('menuShowBodyInactive');

        childrenNavbarTop = parseFloat(menuParentNavbar.css('height')) + parseFloat(menuParentNavbar.offset().top) - parseFloat(jQuery(window).scrollTop());
        childrenNavbarWidth = parseFloat(menuParentNavbar.css('width'));
        childrenNavbarHeight = 'calc(100vh - ' + childrenNavbarTop + 'px)';
        menuChildrenNavbar.css('top', childrenNavbarTop).css('width', childrenNavbarWidth).css('height', childrenNavbarHeight).fadeIn(200);
        if(device == 'desktop') {
            jQuery('.desktopChildSection').css('height', childrenNavbarHeight);
            //jQuery('.menuChildrenNavbar').css('overflow-y', 'auto');
        }
        else if(device == 'mobile') {
            desktopParentNavbarContent.hide();
            desktopChildrenNavbarContent.hide();

            /*childrenNavbarTop = parseFloat(menuParentNavbar.css('height')) + parseFloat(menuParentNavbar.offset().top) - parseFloat(jQuery(window).scrollTop()) + 3;
            jQuery('.menuRouterLine').css('margin-top', '-9px');*/

            mobileChildrenNavbarContent.show();
        }


        closeIcon.show();
        toggleIcon.hide();

        if(type == 'navigate') {
            //when click on navigate bar
            if(jQuery(object).hasClass('navigate')) {
                level = jQuery(object).attr('level');
                itemId = jQuery(object).attr('itemId');
            }
            //when click on back button
            else {
                level = jQuery('.backNavigate').attr('level');
                itemId = jQuery('.backNavigate').attr('itemId');
            }
            if(!isNaN(parseInt(itemId)) || level == 1) {
                for (i = parseInt(level) + 1; i <= 4; i++) {
                    jQuery('.menuRouter .navigate' + i).css('display', 'none');
                }
                menuNavigate.removeClass('navigateActive');
                menuNavigate.removeClass('backNavigate');
                jQuery('.menuRouter .navigate' + (parseInt(level) - 1)).addClass('backNavigate');
                jQuery('.menuRouter .navigate' + level).addClass('navigateActive');

                childItem.find('.nav-link').removeClass('active');

                if(level == 1) {
                    childItemId.hide();
                    menuNavigate.hide();
                    menuRouter.hide();
                    mobileParentNavbarContent.show();
                }
                else {
                    mobileParentNavbarContent.hide();
                    mobileChildSection.show();
                    childItemId.hide();
                    jQuery('#mobileChildSection, #childItemId' + itemId).show();
                }
            }
        }
        else if(type == 'parentItem') {
            itemId = jQuery(object).attr('itemId');
            childItemId.hide();
            jQuery('#desktopParentSection, #childItemId' + itemId).show();

            parentItem.removeClass('active');
            jQuery(object).addClass('active');

            childItem.find('.nav-link').removeClass('active');
        }
        else if(type == 'childItem') {
            itemId = jQuery(object).attr('itemId');
            level = jQuery(object).attr('level');

            maxLevel = jQuery(object).attr('level');

            for(i = maxLevel; i <= 4; i++) {
                jQuery('.menuChildrenNavbar .level' + i).find('.nav-link').removeClass('active');
            }
            jQuery(object).find('.nav-link').addClass('active');

            if(device == 'mobile') {
                menuRouter.show();

                menuNavigate.removeClass('navigateActive');
                menuNavigate.removeClass('backNavigate');
                for(i = 1; i <= parseInt(level) + 1; i++) {
                    jQuery('.menuRouter .navigate' + i).css('display', 'inline-block');
                }
                jQuery('.menuRouter .navigate' + level).addClass('backNavigate');
                jQuery('.menuRouter .navigate' + (parseInt(level) + 1)).attr('itemId', itemId);
                jQuery('.menuRouter .navigate' + (parseInt(level) + 1)).addClass('navigateActive');

                mobileParentNavbarContent.hide();
                jQuery('#mobileChildSection, .childItemIdLevel' + level).hide();
                jQuery('#mobileChildSection, #childItemId' + itemId).show();
            }
            else if(device == 'desktop') {
                if (level <= 3) {
                    jQuery('#desktopChildSection, .childItemIdLevel' + (parseInt(level) + 1)).hide();
                    jQuery('#desktopChildSection, .childItemIdLevel' + (parseInt(level) + 2)).hide();
                    jQuery('#desktopChildSection, #childItemId' + itemId).show();
                }
            }
        }
    }
    else if (mode == 'hide') {
        collapseMenuTitle(device, 'hide');

        window.showForParentId = -1;

        setAllWindowToMenu.hide();

        body.removeClass('menuShowBodyInactive');

        closeIcon.hide();
        menuChildrenNavbar.hide();

        childItemId.hide();

        menuRouter.hide();
        menuNavigate.hide();

        if(device == 'mobile') {
            toggleIcon.show();
            mobileParentNavbarContent.show();
            childItem.find('.nav-link').removeClass('active');
        }
        else if(device == 'desktop') {
            toggleIcon.hide();
            mobileParentNavbarContent.hide();
            mobileChildrenNavbarContent.hide();
            desktopChildrenNavbarContent.show();
            parentItem.removeClass('active');
            childItem.find('.nav-link').removeClass('active');
        }
    }
}