<?php
defined('_JEXEC') or die;

$doc = JFactory::getDocument();

$doc->addStyleSheet(JUri::root().'modules/mod_jb_languages/assets/css/template.css');

if ($params->get('dropdown', 1) && !$params->get('dropdownimage', 0))
{
	JHtml::_('formbehavior.chosen');
}

?>

<div class="mod-jb-languages<?php echo $moduleclass_sfx; ?>">
<?php if ($headerText) : ?>
	<div class="pretext"><p><?php echo $headerText; ?></p></div>
<?php endif; ?>

<?php if ($params->get('dropdown', 1) && !$params->get('dropdownimage', 0)) : ?>
	<form name="lang" method="post" action="<?php echo htmlspecialchars(JUri::current(), ENT_COMPAT, 'UTF-8'); ?>">
	<select class="inputbox advancedSelect" onchange="document.location.replace(this.value);" >
	<?php foreach ($list as $language) :
        if($userCountry != 'ir' && $language->sef == 'fa')
            continue; ?>

		<option dir=<?php echo $language->rtl ? '"rtl"' : '"ltr"'; ?> value="<?php echo $language->link; ?>" <?php echo $language->active ? 'selected="selected"' : ''; ?>>
		<?php echo $language->title_native; ?></option>
	<?php endforeach; ?>
	</select>
	</form>
<?php elseif ($params->get('dropdown', 1) && $params->get('dropdownimage', 0)) : ?>
    <div class="dropdown">
		<?php foreach ($list as $language) :
            if($userCountry != 'ir' && $language->sef == 'fa')
                continue;?>

			<?php if ($language->active) : ?>
                <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <?php if ($language->image) : ?>
                        &nbsp;<?php echo JHtml::_('image', JUri::root().'modules/mod_jb_languages/assets/images/' . $language->image . '.gif', '', null, true); ?>
                    <?php endif; ?>
                    <?php echo $language->title_native; ?>
                </button>
			<?php endif; ?>
		<?php endforeach; ?>

        <div class="<?php echo $params->get('lineheight', 1) ? 'lang-block' : 'lang-inline'; ?> dropdown-menu" aria-labelledby="dropdownMenuButton" dir="<?php echo JFactory::getLanguage()->isRtl() ? 'rtl' : 'ltr'; ?>" style="text-align: <?php echo JFactory::getLanguage()->isRtl() ? 'right' : 'left'; ?>">
		<?php foreach ($list as $language) :
            if($userCountry != 'ir' && $language->sef == 'fa')
                continue; ?>

			<?php if (!$language->active || $params->get('show_active', 0)) : ?>
                <a class="dropdown-item <?php echo $language->active ? 'lang-active' : ''; ?>" href="<?php echo $language->link; ?>">
                    <?php if ($language->image) : ?>
                        <img src="<?php echo JUri::root().'modules/mod_jb_languages/assets/images/'.$language->image.'.gif'; ?>" alt="<?php echo $language->title_native; ?>" title="<?php echo $language->title_native; ?>" />
                        <?php //echo JHtml::_('image', JUri::root().'modules/mod_jb_languages/assets/images/' . $language->image . '.gif', '', null, true); ?>
                    <?php endif; ?>
                    <?php echo $language->title_native; ?>
                </a>
			<?php endif; ?>
		<?php endforeach; ?>
		</div>
	</div>
<?php else : ?>
	<ul class="<?php echo $params->get('inline', 1) ? 'lang-inline' : 'lang-block'; ?>">
	<?php foreach ($list as $language) :
        if($userCountry != 'ir' && $language->sef == 'fa')
            continue; ?>

		<?php if (!$language->active || $params->get('show_active', 0)) : ?>
			<li<?php echo $language->active ? ' class="lang-active"' : ''; ?> dir="<?php echo $language->rtl ? 'rtl' : 'ltr'; ?>">
			<a href="<?php echo $language->link; ?>">
			<?php if ($params->get('image', 1)) : ?>
				<?php if ($language->image) : ?>
                    <img src="<?php echo JUri::root().'modules/mod_jb_languages/assets/images/'.$language->image.'.gif'; ?>" alt="<?php echo $language->title_native; ?>" title="<?php echo $language->title_native; ?>" />
					<?php //echo JHtml::_('image', 'mod_jb_languages/' . $language->image . '.gif', $language->title_native, array('title' => $language->title_native), true); ?>
				<?php else : ?>
					<span class="label"><?php echo strtoupper($language->sef); ?></span>
				<?php endif; ?>
			<?php else : ?>
				<?php echo $params->get('full_name', 1) ? $language->title_native : strtoupper($language->sef); ?>
			<?php endif; ?>
			</a>
			</li>
		<?php endif; ?>
	<?php endforeach; ?>
	</ul>
<?php endif; ?>

<?php if ($footerText) : ?>
	<div class="posttext"><p><?php echo $footerText; ?></p></div>
<?php endif; ?>
</div>
