<?php
defined('_JEXEC') or die;

JLoader::register('ModJBLanguagesHelper', __DIR__ . '/core/helper.php');

$headerText      = $params->get('header_text');
$footerText      = $params->get('footer_text');
$list            = ModJBLanguagesHelper::getList($params);
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8');
$countriesLanguage = $params->get('countriesLanguage');

$userCountry = ModJBLanguagesHelper::getUserCountry(ModJBLanguagesHelper::getRealIPAddress());
//$userCountry = ModJBLanguagesHelper::getUserCountry("83.123.197.93");
$userCountry = strtolower($userCountry);

$session = JFactory::getSession();
if($session->get('userSeveralTimesVisit', false) == true) {
    //nothing
}
else {
    $session->set('userSeveralTimesVisit', true);

    $app = JFactory::getApplication();

    $userCountryLanguage = JFactory::getLanguage()->getDefault();
    foreach($countriesLanguage as $key=>$lang) {
        if(in_array($userCountry, $lang)) {
            $userCountryLanguage = $key;
            break;
        }
    }

    $userLink = "";
    if($userCountryLanguage != "") {
        foreach ($list as $lang) {
            if($lang->lang_code == $userCountryLanguage) {
                $userLink = $lang->link;
                break;
            }
        }
    }

    if($userLink != "") {
        $app->redirect(JUri::root().trim($userLink, '/'));
    }
}

require JModuleHelper::getLayoutPath('mod_jb_languages', $params->get('layout', 'default'));
