<?php
defined('_JEXEC') or die();

error_reporting(0);

class JFormFieldCountriesLanguage extends JFormField {

    public function accessProtected($obj, $prop) {
        $reflection = new ReflectionClass($obj);
        $property = $reflection->getProperty($prop);
        $property->setAccessible(true);
        return $property->getValue($obj);
    }


    public function getInput() {
        $db    = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('*')
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('type')." = ".$db->q('language'))
            ->where($db->quoteName('client_id')." = ".$db->q('0'));

        $db->setQuery($query);
        $languages = $db->loadObjectList();

        $form = $this->accessProtected($this, 'form');
        $data1 = $this->accessProtected($form, 'data');
        $data2 = $this->accessProtected($data1, 'data');

        $elementName = $this->element[0]['name'];
        $elementValues = $data2->params->$elementName;

        foreach($languages as $key=>$language) {
            $query = $db->getQuery(true);

            $query->select('*')
                ->from($db->quoteName('#__languages'))
                ->where($db->quoteName('lang_code')." = ".$db->q($language->element));

            $db->setQuery($query);
            $languageExtraInfo = $db->loadObject();?>

                <div class="control-group">
                    <div class="control-label">
                        <label id="jform_params_countriesLanguage_<?php echo $languageExtraInfo->lang_code; ?>-lbl" for="jform_params_countriesLanguage_<?php echo $languageExtraInfo->lang_code; ?>" class="hasPopover" title="" data-content="<?php echo JText::sprintf('MOD_JB_LANGUAGES_SELECT_COUNTRIES_FOR_THIS_LANGUAGE_LABEL', $languageExtraInfo->title_native); ?>" data-placement="left" data-original-title="<?php echo $languageExtraInfo->title_native; ?>">
                            <?php echo $languageExtraInfo->title_native; ?>
                        </label>
                    </div>
                    <div class="controls">
                        <?php include 'countries.php'; ?>
                    </div>
                </div>

            <?php
        }

       /* echo
            '
                <select
                    id="'.$this->element[0]['id'].'"
                    name="'.$this->element[0]['name'].'"
                    onchange="'.$this->element[0]['onchange'].'"
                    class="'.$this->element[0]['class']. (isset($this->element[0]['required']) ? ' required' : '').'" '.(isset($this->element[0]['required']) ? 'required' : '').'
                >
                    <option
                        value=""
                        data-image="/components/com_paniz/assets/img/driver.png"
                        data-description="" >'.JText::_('COM_PANIZ_SELECT_DRIVER_LABEL').'
                    </option>
            ';

        echo "</select>";*/
    }
}
?>