<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined ('_JEXEC') or die('Restricted access');

if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

$app = JFactory::getApplication();

require_once(dirname(__FILE__).'/helper.php');
require_once(JPATH_BASE.'/components/com_djcatalog2/defines.djcatalog2.php');
require_once(JPATH_BASE.'/components/com_djcatalog2/helpers/route.php');
require_once(JPATH_BASE.'/components/com_djcatalog2/helpers/html.php');
require_once(JPATH_BASE.'/components/com_djcatalog2/helpers/theme.php');
require_once(JPATH_BASE.'/components/com_djcatalog2/helpers/price.php');
require_once(JPATH_BASE.'/administrator/components/com_djcatalog2/lib/categories.php');
require_once(JPATH_BASE.'/administrator/components/com_djcatalog2/helpers/image.php');

$option = $app->input->get('option', '', 'string');
$view = $app->input->get('view', '', 'string');
$id = $app->input->get('id', '', 'int');

/*if ($params->get('related_only') && ($option != 'com_djcatalog2' || $view != 'item' || !$id)) {
 return false;
 }*/

if ($params->get('related_only')) {
	if ($option != 'com_djcatalog2') {
		return false;
	}
	if ($view == 'item' && !$id) {
		return false;
	}
	if ($view == 'producer' && $params->get('related_source') != 'producer') {
		return false;
	}
}

$helperClass = new modDjc2ItemsHelper($params);
$data = $helperClass->getData();
$items = $data['items'];
if (empty($items)) {
	return false;
}

$document= JFactory::getDocument();
$module_id = $module->id;

DJCatalog2ThemeHelper::setThemeAssets();
Djcatalog2Helper::loadComponentLanguage();

$module_css = array();
$module_float 	= $params->get('module_float','');
$module_width 	= $params->get('module_width','');
$module_height 	= $params->get('module_height','');
$module_text_align = $params->get('module_text_align','');
$columns = (int)$params->get('bootstrap_columns', 1);

if ($columns > 1) {
	$module_float = null;
	$module_width = null;
}

if ($module_float == 'left') {
	$module_css[] = 'float: left;';
	//$module_css[] = 'clear: right;';
	$module_css[] = 'margin: auto;';
} else if ($module_float == 'right') {
	$module_css[] = 'float: right;';
	//$module_css[] = 'clear: left;';
	$module_css[] = 'margin: auto;';
}
if ($module_text_align) {
	$module_css[] = 'text-align: '.$module_text_align.';';
}
if (preg_match('#^(\d+)(px|%)?$#', $module_width, $width_matches)) {
	$unit = 'px';
	$width = $width_matches[1];
	if (count($width_matches) == 3) {
		$unit = $width_matches[2];
	}
	$module_css[] = 'width: '.$width.$unit.';';
}
if (preg_match('#^(\d+)(px|%)?$#', $module_height, $height_matches)) {
	$unit = 'px';
	$height = $height_matches[1];
	if (count($height_matches) == 3) {
		$unit = $height_matches[2];
	}
	$module_css[] = 'height: '.$height.$unit.';';
}
if (!empty($module_css)) {
	$css_style = '#mod_djc_items-'.$module_id.' .mod_djc_item {'.implode(PHP_EOL, $module_css).'}';
	$document->addStyleDeclaration($css_style);
}

$attributes = $data['attributes'];

$layout = $params->get('layout', 'default');

$enable_breakpoints = (bool) $params->get('enable_breakpoints', '0');
$breakpoints_by_size = array();
if ($enable_breakpoints) {
	$breakpoints = $params->get('breakpoints', '');
	// $breakpoints_decode = json_decode($breakpoints, true);
	if (is_object($breakpoints)) {
		foreach ($breakpoints as $k_us => $v_us){
			$breakpoints_by_size[$v_us->breakpoints_unit_size] = array(
				'size' => $v_us->breakpoints_unit_size,
				'nbr' => $v_us->breakpoints_unit_nbr
			);
			
		}
	}
	krsort($breakpoints_by_size);
}

//slider
if( $layout == '_:slider' ) {
	
	//limit slider up to 100 latest items
	if(count($items) > 100) {
		$items = array_slice($items, 0, 100);
	}
	
	$slider_items = $params->get('slider_items', 3);
	$slider_rows = $params->get('slider_rows', 1);
	$slider_dots = $params->get('slider_dots', 'true');
	$slider_arrows = $params->get('slider_arrows', 'true');
	$slider_infinite = $params->get('slider_infinite', 'true');
	$slider_autoplay = $params->get('slider_autoplay', 'false');
	$slider_autoplay_speed = $params->get('slider_autoplay_speed', 3000);
	
	$responsive_default = '[{
	"breakpoint": 767,
		"settings": {
			"slidesToShow": 1,
			"infinite": true
		}
	}]';
	
	$slider_responsive = $params->get('slider_responsive', '');
	$slider_responsive = modDjc2ItemsHelper::json_validate($slider_responsive, $responsive_default);
	
	if ($slider_responsive !== $responsive_default) {
		$slider_responsie_decoded = json_decode($slider_responsive);
		
		if (is_object($slider_responsie_decoded)) {
			$slider_responsive = '[' . $slider_responsive . ']';
		} elseif (is_array($slider_responsie_decoded)) {
			//
		} else {
			$slider_responsive = $responsive_default;
		}
		
	}
	
	if ($breakpoints_by_size) {
		$breakpoints_slider_responsive = array();
		foreach($breakpoints_by_size as $k_bbs => $v_bbs) {
			$curr_resp = new stdClass();
			$curr_resp->breakpoint = $k_bbs;
			$curr_resp->settings = new stdClass();
			$curr_resp->settings->slidesToShow = $v_bbs['nbr'];
			
			$breakpoints_slider_responsive[] = $curr_resp;
		}
		$slider_responsive = json_encode($breakpoints_slider_responsive);
	}
	
	$options = '{
		"infinite": ' . (string) $slider_infinite . ',
		"slidesToShow": ' . (int) $slider_items .',
		"rows": ' . (int) $slider_rows . ',
		"dots": '. (string) $slider_dots .',
		"arrows": ' . (string) $slider_arrows . ',
		"autoplay": ' . (string) $slider_autoplay . ',
		"autoplaySpeed": ' . (int) $slider_autoplay_speed . ',
		"slidesToScroll": 1,
		"slidesPerRow": 1,
		"prevArrow": \'<button type="button" class="slick-prev"><span>Previous</span></button>\',
		"nextArrow": \'<button type="button" class="slick-next"><span>Next</span></button>\',
		"responsive": ' . (string) $slider_responsive . '
	}';
	
	$slider_id = '#mod_djc_items-' . $module_id;
	
	$document->addScript(JURI::root(true).'/modules/' . basename(__DIR__) . '/assets/slick.min.js');
	$document->addStyleSheet(JURI::root(true).'/modules/' . basename(__DIR__) . '/assets/slick.css');
	
	$css_style = '#mod_djc_items-'.$module_id.' { display: none; } #mod_djc_items-'.$module_id.'.slick-slider { display: block; }';
	$document->addStyleDeclaration($css_style);
	
	$document->addScriptDeclaration('
		jQuery(document).ready(function(){
			jQuery("' . $slider_id . '").slick(' . $options . ');
		});
	');
} else {
	$module_html_id = 'mod_djc_items-' . $module_id;
	
	if ($breakpoints_by_size) {
		
		$breakpoints_style = '#' . $module_html_id . ' .breakpoints-span { float:left; }';
		foreach ($breakpoints_by_size as $k_bbs => $v_bbs) {
			$curr_max_width = $k_bbs - 1;
			$curr_width = 100.0 / $v_bbs['nbr'];
			$curr_width_formatted = number_format($curr_width, 8, '.', '');
			$breakpoints_style .= '
			@media only screen and (max-width: ' . $curr_max_width . 'px) {
				#' . $module_html_id . ' .breakpoints-span {
					width: ' . $curr_width_formatted . '%;';
			
			$breakpoints_style .= '
				}
			}
			';
		}
		
		$document->addStyleDeclaration(
			$breakpoints_style
			);
	}
	
}

require(JModuleHelper::getLayoutPath('mod_djc2items',$layout));
