/**
 * PageSpeed class
 * 
 * @package JSPEED::plugins::system
 * @author Joomla! Extensions Store
 * @copyright (C) 2021 Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
//'use strict';
(function($) {
	var PageSpeed = function() {
		/**
		 * Current active data sources for sitemap genaration
		 * The first async call to ajaxserver is mean to grab the full list
		 * of published data sources to process
		 * 
		 * @access private
		 * @var Array
		 */
		var sessionAPIData;
		
		/**
		 * Build the PageSpeed cards interface performing the API request
		 * 
		 * @access private
		 * @return Void
		 */
    	var buildPageSpeedInterface = function(data) {
    		$('div.pagespeed-test-url').text(data.analyzedUrl).addClass('pagespeed-test-url-populated');
    		
    		var pageSpeedScoreDesktop = data.pagespeedDesktop;
    		var pageSpeedScoreMobile = data.pagespeedMobile;
    
    		if(pageSpeedScoreDesktop >= 0 && pageSpeedScoreDesktop <= 49) {
        		var desktopColor = '#CC0000';
    			var desktopBgColor = '#ffebeb';
        	}
        	if(pageSpeedScoreDesktop >= 50 && pageSpeedScoreDesktop <= 89) {
        		var desktopColor = '#FFAA33';
    			var desktopBgColor = '#fff7eb';
        	}
        	if(pageSpeedScoreDesktop >= 90) {
        		var desktopColor = '#008000';
    			var desktopBgColor = '#e6faf0';
        	}
    
    		if(pageSpeedScoreMobile >= 0 && pageSpeedScoreMobile <= 49) {
        		var mobileColor = '#CC0000';
    			var mobileBgColor = '#ffebeb';
        	}
        	if(pageSpeedScoreMobile >= 50 && pageSpeedScoreMobile <= 89) {
        		var mobileColor = '#FFAA33';
    			var mobileBgColor = '#fff7eb';
        	}
        	if(pageSpeedScoreMobile >= 90) {
        		var mobileColor = '#008000';
    			var mobileBgColor = '#e6faf0';
        	}
    
    		// Build the PageSpeed interface
    		$('div.timeline-item').empty();
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed row-pagespeed-header pt-2 pb-2 jspeed-setting-row border-bottom"><div class="col p-0 span12 text-center"><span class="icon-mobile" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_MOBILE + '</div></div>');
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed row-pagespeed-header pt-2 pb-2 jspeed-setting-row border-bottom"><div class="col p-0 span12 text-center"><span class="icon-screen" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_DESKTOP + '</div></div>');
    		$('div.timeline-item').append('<progress-ring stroke="8" radius="60" color="#CC0000" progress="0"></progress-ring>');
    
    		var desktopRing = document.querySelector('#timeline-desktop progress-ring');
    		desktopRing.setAttribute('progress', pageSpeedScoreDesktop);
    		desktopRing.setAttribute('color', desktopColor);
    		desktopRing.setAttribute('bgcolor', desktopBgColor);
    
    		var iconSymbol = '';
    		var fcpDesktopLabel = '';
    		var fcpDesktopFloat = parseFloat(data.fcpDesktop);
    		switch(true) {
    			case (fcpDesktopFloat >= 0 && fcpDesktopFloat <= 1.8):
    				fcpDesktopLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (fcpDesktopFloat > 1.8 && fcpDesktopFloat <= 3):
    				fcpDesktopLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (fcpDesktopFloat > 3):
    				fcpDesktopLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_FCP + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + fcpDesktopLabel + '">' + fcpDesktopFloat + ' s</span></div>' +
    													  	'</div>');
    		var siDesktopLabel = '';
    		var siDesktopFloat = parseFloat(data.siDesktop);
    		switch(true) {
    			case (siDesktopFloat >= 0 && siDesktopFloat <= 3.4):
    				siDesktopLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (siDesktopFloat > 3.4 && siDesktopFloat <= 5.8):
    				siDesktopLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (siDesktopFloat > 5.8):
    				siDesktopLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_SI + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + siDesktopLabel + '">' + siDesktopFloat + ' s</span></div>' +
    													  	'</div>');
    
    		var lcpDesktopLabel = '';
    		var lcpDesktopFloat = parseFloat(data.lcpDesktop);
    		switch(true) {
    			case (lcpDesktopFloat >= 0 && lcpDesktopFloat <= 2.5):
    				lcpDesktopLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (lcpDesktopFloat > 2.5 && lcpDesktopFloat <= 4):
    				lcpDesktopLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (lcpDesktopFloat > 4):
    				lcpDesktopLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_LCP + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + lcpDesktopLabel + '">' + lcpDesktopFloat + ' s</span></div>' +
    													  	'</div>');
    
    		var interactiveDesktopLabel = '';
    		var interactiveDesktopFloat = parseFloat(data.interactiveDesktop);
    		switch(true) {
    			case (interactiveDesktopFloat >= 0 && interactiveDesktopFloat <= 3.8):
    				interactiveDesktopLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (interactiveDesktopFloat > 3.8 && interactiveDesktopFloat <= 7.3):
    				interactiveDesktopLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (interactiveDesktopFloat > 7.3):
    				interactiveDesktopLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_TTI + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + interactiveDesktopLabel + '">' + interactiveDesktopFloat + ' s</span></div>' +
    													  	'</div>');
    
    		var tbtDesktopLabel = '';
    		var tbtDesktopInt = parseInt(data.tbtDesktop);
    		switch(true) {
    			case (tbtDesktopInt >= 0 && tbtDesktopInt <= 200):
    				tbtDesktopLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (tbtDesktopInt > 200 && tbtDesktopInt <= 600):
    				tbtDesktopLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (tbtDesktopInt > 600):
    				tbtDesktopLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_TBT + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + tbtDesktopLabel + '">' + tbtDesktopInt + ' ms</span></div>' +
    													  	'</div>');
    
    		var clsDesktopLabel = '';
    		var clsDesktopFloat = parseFloat(data.clsDesktop);
    		switch(true) {
    			case (clsDesktopFloat >= 0 && clsDesktopFloat <= 0.1):
    				clsDesktopLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (clsDesktopFloat > 0.1 && clsDesktopFloat <= 0.25):
    				clsDesktopLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (clsDesktopFloat > 0.25):
    				clsDesktopLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-desktop div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_CLS + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + clsDesktopLabel + '">' + clsDesktopFloat + '</span></div>' +
    													  	'</div>');
    		
    		$('#timeline-desktop div.timeline-item').append('<img class="jspeed-screenshot" alt="' + PLG_JSPEED_AUTO_CONFIGURATION_SCREENSHOT + '" src="' + data.screenShotDesktop + '"/>');
    
    		var mobileRing = document.querySelector('#timeline-mobile progress-ring');
    		mobileRing.setAttribute('progress', pageSpeedScoreMobile);
    		mobileRing.setAttribute('color', mobileColor);
    		mobileRing.setAttribute('bgcolor', mobileBgColor);
    
    		var fcpMobileLabel = '';
    		var fcpMobileFloat = parseFloat(data.fcpMobile);
    		switch(true) {
    			case (fcpMobileFloat >= 0 && fcpMobileFloat <= 1.8):
    				fcpMobileLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (fcpMobileFloat > 1.8 && fcpMobileFloat <= 3):
    				fcpMobileLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (fcpMobileFloat > 3):
    				fcpMobileLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_FCP + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + fcpMobileLabel + '">' + fcpMobileFloat + ' s</span></div>' +
    													  	'</div>');
    
    		var siMobileLabel = '';
    		var siMobileFloat = parseFloat(data.siMobile);
    		switch(true) {
    			case (siMobileFloat >= 0 && siMobileFloat <= 3.4):
    				siMobileLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (siMobileFloat > 3.4 && siMobileFloat <= 5.8):
    				siMobileLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (siMobileFloat > 5.8):
    				siMobileLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_SI + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + siMobileLabel + '">' + siMobileFloat + ' s</span></div>' +
    													  	'</div>');
    
    		var lcpMobileLabel = '';
    		var lcpMobileFloat = parseFloat(data.lcpMobile);
    		switch(true) {
    			case (lcpMobileFloat >= 0 && lcpMobileFloat <= 2.5):
    				lcpMobileLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (lcpMobileFloat > 2.5 && lcpMobileFloat <= 4):
    				lcpMobileLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (lcpMobileFloat > 4):
    				lcpMobileLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_LCP + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + lcpMobileLabel + '">' + lcpMobileFloat + ' s</span></div>' +
    													  	'</div>');
    
    		var interactiveMobileLabel = '';
    		var interactiveMobileFloat = parseFloat(data.interactiveMobile);
    		switch(true) {
    			case (interactiveMobileFloat >= 0 && interactiveMobileFloat <= 3.8):
    				interactiveMobileLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (interactiveMobileFloat > 3.8 && interactiveMobileFloat <= 7.3):
    				interactiveMobileLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (interactiveMobileFloat > 7.3):
    				interactiveMobileLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_TTI + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + interactiveMobileLabel + '">' + data.interactiveMobile + ' s</span></div>' +
    													  	'</div>');
    
    		var tbtMobileLabel = '';
    		var tbtMobileInt = parseInt(data.tbtMobile);
    		switch(true) {
    			case (tbtMobileInt >= 0 && tbtMobileInt <= 200):
    				tbtMobileLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (tbtMobileInt > 200 && tbtMobileInt <= 600):
    				tbtMobileLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (tbtMobileInt > 600):
    				tbtMobileLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_TBT + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + tbtMobileLabel + '">' + tbtMobileInt + ' ms</span></div>' +
    													  	'</div>');
    
    		var clsMobileLabel = '';
    		var clsMobileFloat = parseFloat(data.clsMobile);
    		switch(true) {
    			case (clsMobileFloat >= 0 && clsMobileFloat <= 0.1):
    				clsMobileLabel = 'label-success';
    				iconSymbol = 'icon-circle';
    			break;
    
    			case (clsMobileFloat > 0.1 && clsMobileFloat <= 0.25):
    				clsMobileLabel = 'label-warning';
    				iconSymbol = 'icon-square';
    			break;
    
    			case (clsMobileFloat > 0.25):
    				clsMobileLabel = 'label-important';
    				iconSymbol = 'icon-warning';
    			break;
    		}
    		$('#timeline-mobile div.timeline-item').append('<div class="row row-pagespeed pt-2 pb-2 jspeed-setting-row border-bottom">' +
    														  '<div class="col p-0 span8 text-left"><span class="' + iconSymbol + '" aria-hidden="true"></span> ' + PLG_JSPEED_AUTO_CONFIGURATION_CLS + '</div>' +
    														  '<div class="col p-0 span4 text-center"><span class="label ' + clsMobileLabel + '">' + clsMobileFloat + '</span></div>' +
    													  	'</div>');
    		$('#timeline-mobile div.timeline-item').append('<img class="jspeed-screenshot" alt="' + PLG_JSPEED_AUTO_CONFIGURATION_SCREENSHOT + '" src="' + data.screenShotMobile + '"/>');
    	};
	
    	/**
    	 * Register user events for interface controls
    	 * 
    	 * @access private
    	 * @param Boolean initialize
    	 * @return Void
    	 */
    	var addListeners = function(initialize) {
    		$('#pagespeed-test').on('click', function(jqEvent){
    			$('div.pagespeed-test-url').removeClass('pagespeed-test-url-populated');
    			
    			// Replace the running status of the button
    			$('span.icon-dashboard', this).removeClass('icon-dashboard').addClass('icon-cog running');
    			
    			$('div.timeline-item > *').remove();
				$('div.timeline-item').append('<div class="static-background"> <div class="background-masker header-top"></div><div class="background-masker header-left"></div><div class="background-masker header-right"></div><div class="background-masker subheader-left"></div><div class="background-masker subheader-bottom"></div><div class="background-masker content-top"></div><div class="background-masker content-first-end"></div><div class="background-masker content-second-end"></div><div class="background-masker content-third-end"></div><div class="background-masker content-forth-line"></div><div class="background-masker content-fifth-line"></div></div>');
    			$('div.timeline-item > div').addClass('animated-background');
    			
    			// Request JSON to com_ajax
    			var dataSourcePromise = $.Deferred(function(defer) {
    				$.ajax({
    					type : "GET",
    					url : jspeedPageSpeedLink,
    					dataType : 'json'
    				}).done(function(data, textStatus, jqXHR) {
    					data.data = data.data[0];
    					
    					if(!data.success) {
    						// Error found
    						defer.reject(PLG_JSPEED_AUTO_CONFIGURATION_ERROR_RETRIEVING, textStatus);
    						return false;
    					}
    					
    					if(typeof(data.data.pagespeedDesktop) === 'undefined' || typeof(data.data.pagespeedMobile) === 'undefined') {
    						// Error found
    						defer.reject(PLG_JSPEED_AUTO_CONFIGURATION_MISSINGDATA, textStatus);
    						return false;
    					} 
    					
    					// Check response all went well
    					if(data.success) {
    						sessionAPIData = JSON.stringify(data.data);
        					sessionStorage.setItem('jspeed-google-pagespeed-data', sessionAPIData);
    						defer.resolve(data.data);
    					}
    				}).fail(function(jqXHR, textStatus, errorThrown) {
    					// Error found
    					var genericStatus = textStatus[0].toUpperCase() + textStatus.slice(1);
    					defer.reject('-' + genericStatus + '- ' + errorThrown);
    				});
    			}).promise(); 
    			
    			dataSourcePromise.then(buildPageSpeedInterface, function(errorText, error) {
    				// Do stuff and exit
    				$('#pagespeed-test').after('<span class="label label-warning" id="defer-error-message"><span class="icon-warning"></span>' + errorText + '</span>');
    				setTimeout(function(){
    					$('#defer-error-message').remove();
    				}, 5000);
    			}).always(function(){
    				$('div.timeline-item > div').removeClass('animated-background');
    				
    				// Replace the running status of the button
        			$('#pagespeed-test span.icon-cog.running', this).removeClass('icon-cog running').addClass('icon-dashboard');
    			});
    		});
    		
    		$('#jform_params_pagespeedtest_domain_url').on('change', function(jqEvent){
    			$(this).addClass('jspeed-changed-domain');
    			$('#toolbar-apply,#toolbar-save').on('click', function(){
    				sessionStorage.removeItem('jspeed-google-pagespeed-data');
    			});
    		});
    		
    	};

		/**
		 * Function dummy constructor
		 * 
		 * @access private
		 * @param String
		 *            contextSelector
		 * @method <<IIFE>>
		 * @return Void
		 */
		(function __construct() {
			// Add UI events
			addListeners.call(this, true);
			
			sessionAPIData = sessionStorage.getItem('jspeed-google-pagespeed-data');
			if(sessionAPIData) {
				buildPageSpeedInterface(JSON.parse(sessionAPIData));
			}
		}).call(this);
	}
	
	//On DOM Ready
	$(function() {
		window.JSpeedPageSpeed = new PageSpeed();
	});
})(jQuery);