jQuery(function($) {
	var timestamp = new Date().getTime();
	
	var datas = [];
	// Get all the multiple select fields and iterate through each
	$('select[multiple=multiple]').each(function(){
		var el = $(this);

		datas.push({'id': el.attr('id'),'type':el.attr('data-paramtype'), 'param': el.attr('data-paramname'), 'group': el.attr('data-filegroup')});

	});

	var xhr = jQuery.ajax({
		dataType: 'json',
		url: ajaxEndpoint + "&task=exclusionfiles&time=" + timestamp,
		data: {'data': datas},
		method: 'POST',
		timeout: 30000,
		success: function (response) {
			$.each(response.data, function(id, obj){
				$.each(obj.data, function(value, option){
					$('#' + id).append('<option value="' + value + '">' + option + '</option>');
				});
			
				$('#' + id).removeAttr('disabled');
				
				$('#' + id).prev('img.dropdown-loading').remove();
				
				$('#' + id).select2({
				    tags: true,
				    tokenSeparators: [',']
				})
			});
		},
		error: function (jqXHR, textStatus, errorThrown) {
			console.error('Error returned from ajax function \'getmultiselect\'');
			console.error('textStatus: ' + textStatus);
			console.error('errorThrown: ' + errorThrown);
			
			$('img.dropdown-loading').remove();
			$('select.select2-dropdown').select2({
			    tags: true,
			    tokenSeparators: [',']
			});
		}

	});
	
	$.fn.unchosen = function() {
		return $(this).each(function() {
			var element = $(this);
			if(element.hasClass('select2-dropdown')){
				element.next('[id*=_chzn]').remove();
			}
		});
	}
	
	setTimeout(function(){
		$(document).find("select.select2-dropdown").unchosen();
	}, 100)
	
	// Append task buttons to the toolbar if the plugin is enabled
	var isPluginEnabled = !!parseInt($('#jform_enabled').val());
	if(isPluginEnabled) {
		// Append task buttons to the toolbar
		$('#toolbar-cancel').after('<div class="btn-wrapper">' +
				'<a class="btn btn-small btn-primary hasTooltip" href="' + jSpeedClearCacheURL + '" title="' + PLG_JSPEED_CLEAR_CACHE_DESC + '">' +
				'<span class="icon-remove" aria-hidden="true"></span> ' +
				PLG_JSPEED_CLEAR_CACHE +
				'</a>' +
		'</div>');
		$('#toolbar-cancel').after('<div class="btn-wrapper">' +
				'<a class="btn btn-small btn-primary hasTooltip" href="' + jSpeedRestoreHtaccessURL + '" title="' + PLG_JSPEED_HTACCESS_RESTORE_DESC + '">' +
				'<span class="icon-refresh" aria-hidden="true"></span> ' +
				PLG_JSPEED_HTACCESS_RESTORE +
				'</a>' +
		'</div>');
		$('#toolbar-cancel').after('<div class="btn-wrapper">' +
				'<a class="btn btn-small btn-primary hasTooltip" href="' + jSpeedOptimizeHtaccessURL + '" title="' + PLG_JSPEED_HTACCESS_SETUP_DESC + '">' +
				'<span class="icon-pencil" aria-hidden="true"></span> ' +
				PLG_JSPEED_HTACCESS_SETUP +
				'</a>' +
		'</div>');
		$("a.btn-primary.hasTooltip").tooltip({"html": true,"container": "body"});
	}
});

function JSpeedUcFirst(string) {
    return string[0].toUpperCase() + string.slice(1);
}