<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array( 
		'type'=>'content', 
		'addon_name'=>'sp_process_bar',
		'title'=>JText::_('Process Bar'),
		'desc'=>JText::_('Create Process Bar'),
		'attr'=>array(

			'admin_label'=>array(
				'type'=>'text', 
				'title'=>JText::_('Admin Lable'),
				'desc'=>JText::_('Admin lable will see only admin in backend'),
				'std'=> ''
				),
			
			
			'title_position'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Position'),
				'desc'=>JText::_('Select Icon Position'),
				'values'=>array(
					'up'=>JText::_('Up'),
					'down'=>JText::_('Down'),
					),
				'std'=>'up'
				),

			
			
			'title'=>array(
				'type'=>'text', 
				'title'=>JText::_('Title'),
				'desc'=>JText::_('Add Title'),
				'std'=>  'Feature Box'
				),
				
			'eidt_title_style'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Edit Title Style'),
					'desc'=>JText::_('Select Yes If You want to Edit Title Style'),
					'std'=>0
				),
				
				
			

			'heading_selector'=>array(
				'type'=>'select', 
				'title'=>JText::_('Heading'),
				'desc'=>JText::_('Select Heading'),
				'values'=>array(
					'h1'=>JText::_('H1'),
					'h2'=>JText::_('H2'),
					'h3'=>JText::_('H3'),
					'h4'=>JText::_('H4'),
					'h5'=>JText::_('H5'),
					'h6'=>JText::_('H6'),
					),
				'std'=>'h3',
				'depends'=>array('eidt_title_style'=>'1'),
			),

			'title_fontsize'=>array(
				'type'=>'number', 
				'title'=>JText::_('Title Size'),
				'desc'=>JText::_('Add Title Size'),
				'std'=>'',
				'depends'=>array('eidt_title_style'=>'1'),
				),
			
			'title_top_margin'=>array(
				'type'=>'text', 
				'title'=>JText::_('Title Top Margin'),
				'desc'=>JText::_('Add Title Top Margin'),
				'std'=>'',
				'depends'=>array('eidt_title_style'=>'1'),
				),
			'title_bottom_margin'=>array(
				'type'=>'text', 
				'title'=>JText::_('Title Bottom Margin'),
				'desc'=>JText::_('Add Title Bottom Margin'),
				'std'=>'',
				'depends'=>array('eidt_title_style'=>'1'),
				),
				
			'title_fontweight'=>array(
				'type'=>'text', 
				'title'=>JText::_('Title Font Weight'),
				'desc'=>JText::_('Add Title Font Weight'),
				'std'=>'',
				'depends'=>array('eidt_title_style'=>'1'),
				),
			'heading_transform'=>array(
				'type'=>'select', 
				'title'=>JText::_('Text Transfrom'),
				'desc'=>JText::_('Select Text Transform'),
				'values'=>array(
					'none'=>JText::_('None'),
					'uppercase'=>JText::_('Uppercase'),
					'lowercase'=>JText::_('Lowercase'),
					),
				'depends'=>array('eidt_title_style'=>'1'),
			),

			'title_text_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Title color'),
				'desc'=>JText::_('Select Title Color'),
				'depends'=>array('eidt_title_style'=>'1'),
				),
			'title_text_hover_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Title Hover Color'),
				'desc'=>JText::_('Title Hover Color'),
				'depends'=>array('eidt_title_style'=>'1'),
				),
				
			'title_url'=>array(
				'type'=>'text',
				'title'=>JText::_('Title Url'),
				'desc'=>JText::_('Add Title Url'),
				'placeholder'=>'http://',
				'std'=>'',
				'depends'=>array('eidt_title_style'=>'1'),
				),

			
			'feature_type'=>array(
				'type'=>'select',
				'title'=>JText::_('Feature Type'),
				'desc'=>JText::_('Select Feature Type'),
				'values'=> array(
					'icon'=>JText::_('Icon'),
					'image'=>JText::_('Image'),
					),
				'std' => 'icon'
				),

			'feature_image'=>array(
				'type' => 'media',
				'title'=>JText::_('Image'),
				'desc'=>JText::_('Select Image'),
				'std' => '',
				'depends'=>array('feature_type'=>'image')
				),

			'icon_name'=>array(
				'type'=>'icon', 
				'title'=>JText::_('Icon'),
				'desc'=>JText::_('Select Icon'),
				'std'=> '',
				'depends'=>array('feature_type'=>'icon')
				),
			
			
			'eidt_icon_style'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Edit Icon Style'),
					'desc'=>JText::_('Select Yes If You want to Edit Icon Style'),
					'std'=>0,
					'depends'=>array('feature_type'=>'icon')
				),
			
			'icon_size'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Size'),
				'desc'=>JText::_('Add Icon Size'),
				'placeholder'=>36,
				'std'=>36,
				'depends'=>array('eidt_icon_style'=>'1')
				),

			'icon_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon color'),
				'desc'=>JText::_('Select Icon Color'),
				'depends'=>array('eidt_icon_style'=>'1')
				),
			
			'icon_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Hover Color'),
				'desc'=>JText::_('Select Icon Hover Color'),
				'depends'=>array('eidt_icon_style'=>'1')
				),

			'icon_background'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Background Color'),
				'desc'=>JText::_('Select Icon Background Color'),
				'depends'=>array('eidt_icon_style'=>'1')
				),
				
			'icon_background_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Hover Background Color'),
				'desc'=>JText::_('Select Icon Hover Background Color'),
				'depends'=>array('eidt_icon_style'=>'1')
				),

			'icon_border_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Border Color'),
				'desc'=>JText::_('Select Icon Border Color'),
				'depends'=>array('eidt_icon_style'=>'1')
				),
			
			'icon_border_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Hover Border Color'),
				'desc'=>JText::_('Select Icon Hover Border Color'),
				'depends'=>array('eidt_icon_style'=>'1')
				),
			
			'icon_border_width'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Border Width'),
				'desc'=>JText::_('Add Icon Border Width'),
				'depends'=>array('eidt_icon_style'=>'1'),
				'placeholder'=>'3',
				),

			'icon_border_radius'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon border radius'),
				'desc'=>JText::_('Add Icon border radius'),
				'depends'=>array('eidt_icon_style'=>'1'),
				'placeholder'=>'5',
				),
				
				
			'icon_animation_style'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'none'=>JText::_('None'),
					'animated'=>JText::_('Animated'),
					'onhover'=>JText::_('On Icon Hover'),
					'onparenthover'=>JText::_('On Parent Hover'),
					),
				'std' => 'icon',
				'depends'=>array('eidt_icon_style'=>'1'),
			),
				
			'icon_animated'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'wrench'=>JText::_('Wrench'),
					'ring'=>JText::_('Ring'),
					'horizontal'=>JText::_('Horizontal'),
					'vertical'=>JText::_('Vertical'),
					'flash'=>JText::_('Flash'),
					'bounce'=>JText::_('Bounce'),
					'spin'=>JText::_('Spin'),
					'float'=>JText::_('Float'),
					'pulse'=>JText::_('Pulse'),
					'shake'=>JText::_('Shake'),
					'tada'=>JText::_('Tada'),
					'passing'=>JText::_('Passing'),
					'passing-reverse'=>JText::_('Passing Reverse'),
					'burst'=>JText::_('Burst'),
					
					),
				'depends'=>array('icon_animation_style'=>'animated'),
				
			),
			
			'icon_onhover'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'wrench'=>JText::_('Wrench'),
					'ring'=>JText::_('Ring'),
					'horizontal'=>JText::_('Horizontal'),
					'vertical'=>JText::_('Vertical'),
					'flash'=>JText::_('Flash'),
					'bounce'=>JText::_('Bounce'),
					'spin'=>JText::_('Spin'),
					'float'=>JText::_('Float'),
					'pulse'=>JText::_('Pulse'),
					'shake'=>JText::_('Shake'),
					'tada'=>JText::_('Tada'),
					'passing'=>JText::_('Passing'),
					'passing-reverse'=>JText::_('Passing Reverse'),
					'burst'=>JText::_('Burst'),
					
					),
				'depends'=>array('icon_animation_style'=>'onhover'),
				
			),
			
			
			'icon_onparenthover'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'wrench'=>JText::_('Wrench'),
					'ring'=>JText::_('Ring'),
					'horizontal'=>JText::_('Horizontal'),
					'vertical'=>JText::_('Vertical'),
					'flash'=>JText::_('Flash'),
					'bounce'=>JText::_('Bounce'),
					'spin'=>JText::_('Spin'),
					'float'=>JText::_('Float'),
					'pulse'=>JText::_('Pulse'),
					'shake'=>JText::_('Shake'),
					'tada'=>JText::_('Tada'),
					'passing'=>JText::_('Passing'),
					'passing-reverse'=>JText::_('Passing Reverse'),
					'burst'=>JText::_('Burst'),
					
					),
				'depends'=>array('icon_animation_style'=>'onparenthover'),
				
			),
				

			'icon_margin_top'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon margin Top'),
				'desc'=>JText::_('Add Icon margin Top'),
				'placeholder'=>'10',
				'depends'=>array('eidt_icon_style'=>'1'),
				),
			'icon_margin_right'=>array(
				'type'=>'number',
				'title'=>JText::_('Margin Right'),
				'desc'=>JText::_('Add Margin Right to icon'),
				'placeholder'=>'10',
				'depends'=>array('eidt_icon_style'=>'1'),
				),
			'icon_margin_bottom'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Margin Bottom'),
				'desc'=>JText::_('Add Icon Margin Bottom'),
				'placeholder'=>'10',
				'depends'=>array('eidt_icon_style'=>'1'),
				),				
				
			'icon_margin_left'=>array(
				'type'=>'number',
				'title'=>JText::_('Margin Left'),
				'desc'=>JText::_('Add Margin left to icon'),
				'placeholder'=>'10',
				'depends'=>array('eidt_icon_style'=>'1'),
				),

			'icon_padding'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Padding'),
				'desc'=>JText::_('Add Icon Padding'),
				'placeholder'=>'20',
				'depends'=>array('eidt_icon_style'=>'1'),
				),
				
				
			'eidt_bar_style'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Edit Bar Style'),
					'desc'=>JText::_('Select Yes If You want to Edit Process Bar Style'),
					'std'=>0
				),
				
			
		
			'process_bar_height'=>array(
				'type'=>'number',
				'title'=>JText::_('Process Bar Height'),
				'desc'=>JText::_('Add Process Bar Height'),
				'placeholder'=>'20',
				'depends'=>array('eidt_bar_style'=>'1'),
			),
			
			
			
			'process_bar_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Process Bar Color'),
				'desc'=>JText::_('Select Process Bar Color'),
				'depends'=>array('eidt_bar_style'=>'1'),
			),
			
			'process_bar_hover_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Process Bar Hover Color'),
				'desc'=>JText::_('Select Process Bar Hover Color'),
				'depends'=>array('eidt_bar_style'=>'1'),
			),
			
			
			'process_bar_fl'=>array(
				'type'=>'select', 
				'title'=>JText::_('Bar Stage'),
				'desc'=>JText::_('Choose this bar First, Middle or Last'),
				'values'=>array(
					'first'=>JText::_('First'),
					'middle'=>JText::_('Middle'),
					'last'=>JText::_('Last'),
					),
				'std'=>'middle',
				'depends'=>array('eidt_bar_style'=>'1'),
				),
				
			
			'eidt_box_style'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Edit Box Style'),
					'desc'=>JText::_('Select Yes If You want to Edit Box Style'),
					'std'=>1
				),
			
			
			'box_bg_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Box Background Color'),
				'desc'=>JText::_('Select Box Background Color'),
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			'box_bg_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Box Background Hover Color'),
				'desc'=>JText::_('Select Box Background Hover Color'),
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			'box_border_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Box border Color'),
				'desc'=>JText::_('Select Box Background Color'),
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			'box_border_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Box border Hover Color'),
				'desc'=>JText::_('Select Box Background Hover Color'),
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			'box_border_width'=>array(
				'type'=>'text',
				'title'=>JText::_('Box Border Width'),
				'desc'=>JText::_('Add Box Border Width'),
				'placeholder'=>'1px 1px 2px 1px',
				'depends'=>array('eidt_box_style'=>'1'),
				),
			'box_border_radius'=>array(
				'type'=>'text',
				'title'=>JText::_('Box Border Radius'),
				'desc'=>JText::_('Add Box Border Radius'),
				'placeholder'=>'2',
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			'box_padding'=>array(
				'type'=>'text',
				'title'=>JText::_('Box Padding'),
				'desc'=>JText::_('Add padding between border and content in px. like 20px 20px 20px 20px'),
				'placeholder'=>'10px 10px 10px 10px',
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			
			
			
		
			
			'text_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Text Color'),
				'desc'=>JText::_('Select Text Color'),
				'depends'=>array('eidt_box_style'=>'1'),
				),
			'text_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Text Hover Color'),
				'desc'=>JText::_('Select Text Hover Color'),
				'depends'=>array('eidt_box_style'=>'1'),
				),
			
			'text'=>array(
				'type'=>'editor', 
				'title'=>JText::_('Text'),
				'desc'=>JText::_('Add text'),
				'std'=>'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum.'
				),

			'alignment'=>array(
				'type'=>'select',
				'title'=>JText::_('Alignment'),
				'desc'=>JText::_('Select Alignment'),
				'values'=>array(
					'sppb-text-left'=>JText::_('Left'),
					'sppb-text-center'=>JText::_('Center'),
					'sppb-text-right'=>JText::_('Right'),
					),
				'std'=>'',
				),
				
			
			//Button
			'button_text'=>array(
				'type'=>'text', 
				'title'=>JText::_('Button Text'),
				'desc'=>JText::_('Add Button Text'),
				'placeholder'=>'Button Text',
				),
			'button_url'=>array(
				'type'=>'text', 
				'title'=>JText::_('Button URL'),
				'desc'=>JText::_('Add Button Url'),
				'placeholder'=>'http://'
				),
			'button_type'=>array(
				'type'=>'select', 
				'title'=>JText::_('Button Type'),
				'desc'=>JText::_('Select Button Type'),
				'values'=>array(
					'default'=>JText::_('Default'),
					'primary'=>JText::_('Primary'),
					'success'=>JText::_('Success'),
					'info'=>JText::_('Info'),
					'warning'=>JText::_('Wargin'),
					'danger'=>JText::_('Danger'),
					'link'=>JText::_('Link'),
					),
				'std'=>'default',
				),
			'button_icon'=>array(
				'type'=>'icon', 
				'title'=>JText::_('Button Icon'),
				'desc'=>JText::_('Select Button Icon'),
				),
				
			'button_target'=>array(
				'type'=>'select', 
				'title'=>JText::_('Button Target'),
				'desc'=>JText::_('Select Button Target'),
				'values'=>array(
					''=>JText::_('Same Window'),
					'_blank'=>JText::_('New Window'),
					),
				),
			
			

			'class'=>array(
				'type'=>'text', 
				'title'=>JText::_('Class'),
				'desc'=>JText::_('Add Custom Class to addon'),
				'std'=> ''
				),
			)

		)
	);