<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array( 
		'type'=>'content', 
		'addon_name'=>'sp_feature_boxed',
		'title'=>JText::_('Complete Box'),
		'desc'=>JText::_('Create Complete Box'),
		'attr'=>array(

			'admin_label'=>array(
				'type'=>'text', 
				'title'=>JText::_('Admin Lable'),
				'desc'=>JText::_('Admin lable will see only admin in backend'),
				'std'=> ''
				),

			'title'=>array(
				'type'=>'text', 
				'title'=>JText::_('Addon Title'),
				'desc'=>JText::_('Add Title to addon'),
				'std'=>  'Complete Box'
				),

			'heading_selector'=>array(
				'type'=>'select', 
				'title'=>JText::_('Heading'),
				'desc'=>JText::_('Select Heading'),
				'values'=>array(
					'h1'=>JText::_('H1'),
					'h2'=>JText::_('H2'),
					'h3'=>JText::_('H3'),
					'h4'=>JText::_('H4'),
					'h5'=>JText::_('H5'),
					'h6'=>JText::_('H6'),
					),
				'std'=>'h3',
			),

			'title_fontsize'=>array(
				'type'=>'number', 
				'title'=>JText::_('Title Font Size'),
				'desc'=>JText::_('add Title Font Size'),
				'std'=>''
				),
			
			'title_top_margin'=>array(
				'type'=>'text', 
				'title'=>JText::_('Title Top Margin'),
				'desc'=>JText::_('Add Title Top Margin'),
				'std'=>''
				),
			'title_bottom_margin'=>array(
				'type'=>'text', 
				'title'=>JText::_('Title Bottom Margin'),
				'desc'=>JText::_('Add Title Bottom Margin'),
				'std'=>''
				),
				
			'title_fontweight'=>array(
				'type'=>'text', 
				'title'=>JText::_('Font Weight'),
				'desc'=>JText::_('Add Font Weight'),
				'std'=>''
				),
			'heading_transform'=>array(
				'type'=>'select', 
				'title'=>JText::_('Text Transfrom'),
				'desc'=>JText::_('Select Text Transform'),
				'values'=>array(
					'none'=>JText::_('None'),
					'uppercase'=>JText::_('Uppercase'),
					'lowercase'=>JText::_('Lowercase'),
					),
			),

			'title_text_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Title color'),
				'desc'=>JText::_('Select Title color'),
				),
			'title_text_hover_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Title Hover Color'),
				'desc'=>JText::_('Title Hover Color'),
				),
				
			'title_url'=>array(
				'type'=>'text',
				'title'=>JText::_('Title Url'),
				'desc'=>JText::_('Add Title Url'),
				'placeholder'=>'http://',
				'std'=>''
				),

			'title_position'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Position'),
				'desc'=>JText::_('Select Icon Position'),
				'values'=>array(
					'after'=>JText::_('Before Title'),
					'before'=>JText::_('After Title'),
					'left'=>JText::_('Left'),
					'right'=>JText::_('Right'),
					),
				'std'=>'before'
				),

			'feature_type'=>array(
				'type'=>'select',
				'title'=>JText::_('Feature Type'),
				'desc'=>JText::_('Select Feature Type'),
				'values'=> array(
					'icon'=>JText::_('Icon'),
					'image'=>JText::_('Image'),
					),
				'std' => 'icon'
				),

			'feature_image'=>array(
				'type' => 'media',
				'title'=>JText::_('Image'),
				'desc'=>JText::_('Select Image'),
				'std' => '',
				'depends'=>array('feature_type'=>'image')
				),

			'icon_name'=>array(
				'type'=>'icon', 
				'title'=>JText::_('Icon'),
				'desc'=>JText::_('Select Icon'),
				'std'=> '',
				'depends'=>array('feature_type'=>'icon')
				),

			'icon_size'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Size'),
				'desc'=>JText::_('Add Icon size'),
				'placeholder'=>36,
				'std'=>36,
				'depends'=>array('feature_type'=>'icon')
				),

			'icon_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Color'),
				'desc'=>JText::_('Add Icon Color'),
				'depends'=>array('feature_type'=>'icon')
				),
			
			'icon_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Hover Color'),
				'desc'=>JText::_('Select Icon Hover Color'),
				'depends'=>array('feature_type'=>'icon')
				),

			'icon_background'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Background'),
				'desc'=>JText::_('Select Icon Background'),
				'depends'=>array('feature_type'=>'icon')
				),
				
			'icon_background_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Hover Background Color'),
				'desc'=>JText::_('Select Icon Hover Background Color'),
				'depends'=>array('feature_type'=>'icon')
				),

			'icon_border_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Border Color'),
				'desc'=>JText::_('Select Icon Border Color'),
				'depends'=>array('feature_type'=>'icon')
				),
			
			'icon_border_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Icon Hover Border Color'),
				'desc'=>JText::_('Select Icon Hover Border Color'),
				'depends'=>array('feature_type'=>'icon')
				),
			
			'icon_border_width'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Border Width'),
				'desc'=>JText::_('Add Icon Border Width'),
				'depends'=>array('feature_type'=>'icon'),
				'placeholder'=>'3',
				),

			'icon_border_radius'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Border Radius'),
				'desc'=>JText::_('Add Icon Border Radius'),
				'depends'=>array('feature_type'=>'icon'),
				'placeholder'=>'5',
				'depends'=>array('feature_type'=>'icon')
				),
				
				
			'icon_animation_style'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'none'=>JText::_('None'),
					'animated'=>JText::_('Animated'),
					'onhover'=>JText::_('On Icon Hover'),
					'onparenthover'=>JText::_('On Parent Hover'),
					),
				'std' => 'icon',
				'depends'=>array('feature_type'=>'icon')
			),
				
			'icon_animated'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'wrench'=>JText::_('Wrench'),
					'ring'=>JText::_('Ring'),
					'horizontal'=>JText::_('Horizontal'),
					'vertical'=>JText::_('Vertical'),
					'flash'=>JText::_('Flash'),
					'bounce'=>JText::_('Bounce'),
					'spin'=>JText::_('Spin'),
					'float'=>JText::_('Float'),
					'pulse'=>JText::_('Pulse'),
					'shake'=>JText::_('Shake'),
					'tada'=>JText::_('Tada'),
					'passing'=>JText::_('Passing'),
					'passing-reverse'=>JText::_('Passing Reverse'),
					'burst'=>JText::_('Burst'),
					
					),
				'depends'=>array('icon_animation_style'=>'animated'),
				
			),
			
			'icon_onhover'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'wrench'=>JText::_('Wrench'),
					'ring'=>JText::_('Ring'),
					'horizontal'=>JText::_('Horizontal'),
					'vertical'=>JText::_('Vertical'),
					'flash'=>JText::_('Flash'),
					'bounce'=>JText::_('Bounce'),
					'spin'=>JText::_('Spin'),
					'float'=>JText::_('Float'),
					'pulse'=>JText::_('Pulse'),
					'shake'=>JText::_('Shake'),
					'tada'=>JText::_('Tada'),
					'passing'=>JText::_('Passing'),
					'passing-reverse'=>JText::_('Passing Reverse'),
					'burst'=>JText::_('Burst'),
					
					),
				'depends'=>array('icon_animation_style'=>'onhover'),
				
			),
			
			
			'icon_onparenthover'=>array(
				'type'=>'select',
				'title'=>JText::_('Icon Animation Style'),
				'desc'=>JText::_('Icon Animation Style'),
				'values'=> array(
					'wrench'=>JText::_('Wrench'),
					'ring'=>JText::_('Ring'),
					'horizontal'=>JText::_('Horizontal'),
					'vertical'=>JText::_('Vertical'),
					'flash'=>JText::_('Flash'),
					'bounce'=>JText::_('Bounce'),
					'spin'=>JText::_('Spin'),
					'float'=>JText::_('Float'),
					'pulse'=>JText::_('Pulse'),
					'shake'=>JText::_('Shake'),
					'tada'=>JText::_('Tada'),
					'passing'=>JText::_('Passing'),
					'passing-reverse'=>JText::_('Passing Reverse'),
					'burst'=>JText::_('Burst'),
					
					),
				'depends'=>array('icon_animation_style'=>'onparenthover'),
				
			),
				

			'icon_margin_main'=>array(
				'type'=>'margin',
				'title'=>JText::_('Icon Margin'),
				'desc'=>JText::_('Add Icon Margin'),
				'placeholder'=>'10px 10px 10px 10px',
				),

			'icon_padding'=>array(
				'type'=>'number',
				'title'=>JText::_('Icon Padding'),
				'desc'=>JText::_('Add Icon Padding'),
				'placeholder'=>'20',
				),
				
			
			'box_bg_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Box Background Color'),
				'desc'=>JText::_('Select Box Background Color'),
				),
			
			'box_bg_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Box Background Hover Color'),
				'desc'=>JText::_('Select Box Background Hover Color'),
				),
			
			'box_border_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Box border Color'),
				'desc'=>JText::_('Select Box Background Color'),
				),
			
			'box_border_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Box border Hover Color'),
				'desc'=>JText::_('Select Box Background Hover Color'),
				),
			
			'box_border_width'=>array(
				'type'=>'text',
				'title'=>JText::_('Box Border Width'),
				'desc'=>JText::_('Add Box Border Width'),
				'placeholder'=>'1px 1px 2px 1px',
				),
			
			'box_border_style'=>array(
				'type'=>'select', 
				'title'=>JText::_('Box Border Style'),
				'desc'=>JText::_('Select Box Border Style'),
				'values'=>array(
					'solid'=>JText::_('Solid'),
					'dotted'=>JText::_('Dotted'),
					'dashed'=>JText::_('Dashed'),
					'double'=>JText::_('Double'),
					'hidden'=>JText::_('Hidden'),
					),
				),
			
			'box_border_radius'=>array(
				'type'=>'text',
				'title'=>JText::_('Box Border Radius'),
				'desc'=>JText::_('Add Box Border Radius'),
				'placeholder'=>'10px 10px 10px 10px',
				),
			
			'box_padding'=>array(
				'type'=>'padding',
				'title'=>JText::_('Box Padding'),
				'desc'=>JText::_('Add padding between border and content in px. like 20px 20px 20px 20px'),
				'placeholder'=>'10px 10px 10px 10px',
				),
			
			'right_arrow'=>array(
				'type'=>'select', 
				'title'=>JText::_('Box Right Arrow'),
				'desc'=>JText::_('If yes it will add arrow right side of box with border color'),
				'values'=>array(
					''=>JText::_('JNO'),
					'right_arrow_yes'=>JText::_('JYES'),
					),
				),
			
			
			'box_margin'=>array(
				'type'=>'margin',
				'title'=>JText::_('Box Margin'),
				'desc'=>JText::_('Add Box Margin'),
				'placeholder'=>'10px 10px 10px 10px',
				),
			
			
			'text_color'=>array(
				'type'=>'color',
				'title'=>JText::_('Text Color'),
				'desc'=>JText::_('Select Text Color'),
				),
			'text_color_hover'=>array(
				'type'=>'color',
				'title'=>JText::_('Text Hover Color'),
				'desc'=>JText::_('Select Text Hover Color'),
				),
			
			'text'=>array(
				'type'=>'editor', 
				'title'=>JText::_('Text'),
				'desc'=>JText::_('Add TExt'),
				'std'=>'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum.'
				),

			'alignment'=>array(
				'type'=>'select',
				'title'=>JText::_('Alignment'),
				'desc'=>JText::_('Select Alignment'),
				'values'=>array(
					'sppb-text-left'=>JText::_('Left'),
					'sppb-text-center'=>JText::_('Center'),
					'sppb-text-right'=>JText::_('Right'),
					),
				'std'=>'',
				),
				
			
			//Button
			'button_text'=>array(
				'type'=>'text', 
				'title'=>JText::_('Button Text'),
				'desc'=>JText::_('Button TExt'),
				'placeholder'=>'Button Text',
				),
			'button_url'=>array(
				'type'=>'text', 
				'title'=>JText::_('Button URL'),
				'desc'=>JText::_('Button Url'),
				'placeholder'=>'http://'
				),
			'button_type'=>array(
				'type'=>'select', 
				'title'=>JText::_('Button Type'),
				'desc'=>JText::_('Button Type'),
				'values'=>array(
					'default'=>JText::_('Default'),
					'primary'=>JText::_('Primary'),
					'success'=>JText::_('Success'),
					'info'=>JText::_('Info'),
					'warning'=>JText::_('Warning'),
					'danger'=>JText::_('Danger'),
					'link'=>JText::_('Link'),
					),
				'std'=>'default',
				),
			'button_icon'=>array(
				'type'=>'icon', 
				'title'=>JText::_('Button Icon'),
				'desc'=>JText::_('Add Button Icon'),
				),
				
			'button_target'=>array(
				'type'=>'select', 
				'title'=>JText::_('Button Target'),
				'desc'=>JText::_('Select Button Target'),
				'values'=>array(
					''=>JText::_('Same Window'),
					'_blank'=>JText::_('New Window'),
					),
				),
			
			

			'class'=>array(
				'type'=>'text', 
				'title'=>JText::_('Class'),
				'desc'=>JText::_('Add Custom class to Addon'),
				'std'=> ''
				),
			)

		)
	);