<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.framework');

$app = JFactory::getApplication();
$user = JFactory::getUser();
$params = DJCatalog2Helper::getParams();

?>

<?php if($user->guest) : ?>
<div class="wishlist-msg"><?php echo JText::_('COM_DJCATALOG2_WISHILST_VIEW_NOT_LOGGED'); ?></div>
<?php endif; ?>

<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx') ?>">
    <?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>
<div id="djcatalog" class="djc_cart djc_theme_hdc">

    <?php if (!count($this->items)) : ?>
        <p class="djc_empty_wishlist"><?php echo JText::_('COM_DJCATALOG2_WISHLIST_EMPTY') ?></p>
    <?php else : ?>
        <form action="<?php echo DJCatalogHelperRoute::getWishlistRoute(); ?>" class="wishForm" method="post"
              name="adminForm" id="adminForm"  class="form-validate">
            <div class="wish-btns">
                <input type="submit" class="btn btn-danger" value="<?php echo JText::_('COM_DJCATALOG2_WISHLIST_REMOVE')?>">
                <?php if($params->get('wishlist_print_button')) : ?>
                    <a href="javascript:window.print()"  class="btn btn-primary"><?php echo JText::_('COM_DJCATALOG2_WISHLIST_PRINT')?></a>
                <?php endif; ?>
                <?php if($params->get('wishlist_pdf_button') ) : ?>
                    <a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=wish.pdf'); ?>"  class="btn btn-primary"><?php echo JText::_('COM_DJCATALOG2_WISHLIST_PDF')?></a>
                <?php endif; ?>
            </div>
            <table>
                <tr>
                    <th width="1%" class="hidden-phone">
                        <input type="checkbox" name="checkall-toggle" value=""
                               title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)"/>
                    </th>
                    <th><?php //echo JText::_('COM_DJCATALOG2_WISHLIST_ITEM_NAME'); ?></th>
                </tr>

                <?php foreach ($this->items as $i => $item) : ?>
                    <tr>
                        <td class="center">
                            <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                        </td>
                        <td>
                            <a href="<?php echo DJCatalogHelperRoute::getItemRoute($item->slug, $item->cat_slug) ?>">
                            <?php if ((int)$params->get('image_link_item', 0) != -1) { ?>
                                <?php
                                $variant = 'img';
                                $imgLink = (int)$this->params->get('image_link_item', 0);
                                if ($imgLink == 0) {
                                    $variant = 'link';
                                } else if ($imgLink == 1) {
                                    $variant = 'popup';
                                } else if ($imgLink == 2) {
                                    $variant = 'preview';
                                }
                                $layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
                                $imageData = array(	'item' => &$item,
                                    'type' => 'item',
                                    'size' => 'small',
                                    'variant' => $variant,
                                    'hover_img' => $params->get('image_hover_item', 0) == 1,
                                    'context' => 'com_djcatalog2.items.list',
                                    'params' => &$params);
                                echo $layout->render($imageData);
                                ?>
                            <?php } ?>
                            <?php echo $item->name; ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <input type="hidden" name="task" value="wish.remove"/>
            <input type="hidden" name="boxchecked" value="0"/>
            <?php echo JHtml::_('form.token'); ?>
        </form>
    <?php endif; ?>

</div>

<script>
    jQuery(document).ready(function () {


        jQuery('form.wishForm').submit(function () {

            var checked_items = jQuery(this).find('input[name=boxchecked]').val();
            if(checked_items > 0)
                return true;

            return false;
        })
    })
</script>