<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');

class DJCatalog2ViewProducers extends JViewLegacy {
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		$this->_addPath('template', JPATH_COMPONENT.  '/themes/default/views/producers');
		$theme = DJCatalog2ThemeHelper::getThemeName();
		if ($theme && $theme != 'default') {
			$this->_addPath('template', JPATH_COMPONENT.  '/themes/'.$theme.'/views/producers');
		}
	}
	
	function display($tpl = null) {
		$app = JFactory::getApplication();
		$jinput = $app->input;
		$view = $jinput->get('view');
		$document= JFactory::getDocument();
		$model = $this->getModel();
		$dispatcher	= JEventDispatcher::getInstance();
		$user	= JFactory::getUser();
		$groups	= $user->getAuthorisedViewLevels();
		
		$menus		= $app->getMenu('site');
		$menu  = $menus->getActive();
		
		$mOption = (empty($menu->query['option'])) ? null : $menu->query['option'];
    	$mCatid = (empty($menu->query['cid'])) ? null : (int)$menu->query['cid'];
    	$mProdid   = (empty($menu->query['pid'])) ? null : (int)$menu->query['pid'];
    	
    	$filter_catid		= $jinput->getInt('pcid', null);
    	if ($filter_catid === null && $mOption == 'com_djcatalog2' && $mCatid) {
    		$filter_catid = $mCatid;
    		$jinput->set('pcid', $filter_catid);
    	}
    	
    	$search				= urldecode($jinput->get( 'search','','string' ));
    	$search				= JString::strtolower( $search );
		
		$params = Djcatalog2Helper::getParams();
		
		$filter_order		= $jinput->get( 'order',$params->get('producers_default_order','i.ordering'),'cmd' );
		$filter_order_Dir	= $jinput->get( 'dir',	$params->get('producers_default_order_dir','asc'), 'word' );
		
		$lists = array();
		
		if (JString::strlen($search) > 0 && (JString::strlen($search)) < 1 || JString::strlen($search) > 40) {
			JError::raiseNotice(  E_USER_NOTICE, JText::_( 'COM_DJCATALOG2_SEARCH_RESTRICTION') );
		}
		if ($filter_order_Dir == '' || $filter_order_Dir == 'desc') {
			$lists['order_Dir'] = 'asc';
		} else {
			$lists['order_Dir'] = 'desc';
		}
		$lists['order'] = $filter_order;
		$lists['search']= $search;

		$limitstart	= $jinput->getInt('limitstart', 0);
		$limit_items_show = $params->get('producers_pagination_limit',10);
		$jinput->set('limit', $limit_items_show);
		
		$categories = Djc2ProducerCategories::getInstance(array('state'=>'1', 'access'=>$groups));
		
		// current category
		$this->category = $categories->get((int) $jinput->getInt('pcid',0));
		$subcategories = null;
		if (!empty($this->category)) {
			$subcategories = $this->category->getChildren();
		}
		
		$this->categories = $categories;
		$this->subcategories = $subcategories;
		
		$category_options = $categories->getOptionList('- '.JText::_('COM_DJCATALOG2_SELECT_CATEGORY').' -');
		$lists['categories'] = JHtml::_('select.genericlist', $category_options, 'pcid', 'class="inputbox input"', 'value', 'text', $filter_catid);

		$list = $model->getItems();
		$total = $model->getTotal();
		$pagination = $model->getPagination();
		
		$this->document = $document;
		$this->items = $list;
		$this->total = $total;
		$this->pagination = $pagination;
		$this->params = $params;
		$this->lists = $lists;
		$this->attributes = $model->getAttributes();
		$this->sortables = $model->getSortables();
		$this->_prepareDocument();
		
        parent::display($tpl);
	}
	
	protected function _prepareDocument() {
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$pathway	= $app->getPathway();
		$title		= null;
		$heading		= null;

		$menu = $menus->getActive();
		
		if ($menu) {
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		$title = $this->params->get('page_title', '');

		if ($menu && ($menu->query['option'] != 'com_djcatalog2' || $menu->query['view'] != 'producers')) {
			
			$title = JText::_('COM_DJCATALOG2_PRODUCERS_HEADING');
			
			$path = array(array('title' => $title, 'link' => ''));
			foreach ($path as $item)
			{
				$pathway->addItem($item['title'], $item['link']);
			}
		}

		if (empty($title)) {
			$title = $app->getCfg('sitename');
		}
		elseif ($app->getCfg('sitename_pagetitles', 0)) {
			if ($app->getCfg('sitename_pagetitles', 0) == '2') {
				$title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
			} else {
				$title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
			}
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description')) 
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords')) 
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}
		
		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
		
		$uri = JUri::getInstance();
		$vars = $uri->getQuery(true);
		unset($vars['order']);
		unset($vars['dir']);
		unset($vars['l']);
		
		$canonical = DJCatalogHelperRoute::getProducerCategoryRoute($this->category->catslug);
		if (!empty($vars)){
			$canonical .= '&'.$uri->buildQuery($vars);
		}
		
		$app->setHeader('X-App-DJCatalog-URI', urlencode(JRoute::_($canonical, false)));
		$app->setHeader('X-App-DJCatalog-URL', urlencode(JRoute::_($canonical, false, (JUri::getInstance()->isSSL() ? 1 : -1))));
		
		$canonical = JRoute::_($canonical, true, (JUri::getInstance()->isSSL() ? 1 : -1));
		foreach($this->document->_links as $key => $headlink) {
			if ($headlink['relation'] == 'canonical' ) {
				unset($this->document->_links[$key]);
			}
		}
		
		$this->document->addHeadLink($canonical, 'canonical');
	}

}




