<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();
?>
<table width="100%" cellpadding="0" cellspacing="0" class="djc_orders_table jlist-table category table table-condensed" id="djc_orders_table">
	<thead>
		<tr>
			<?php if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2') && (isset($this->showCheckAll) && $this->showCheckAll)) : ?>
				<th width="1%" class="hidden-phone">
					<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
				</th>
			<?php endif; ?>

			<th class="djc_thead djc_thead_order_no">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_NUMBER'); ?>
			</th>
			<th class="djc_thead djc_thead_order_date">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_DATE'); ?>
			</th>
			<th class="djc_thead djc_thead_order_status">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_STATUS'); ?>
			</th>
			<th class="djc_thead djc_thead_order_total">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_FINAL_PRICE'); ?>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php 
		$k = 1;
		$original_currency = $this->params->get('price_unit');
		foreach($this->items as $item) {
			$k = 1 - $k; 
			$order_url = JRoute::_(DJCatalogHelperRoute::getOrderRoute($item->id));
			
			$currency = Djcatalog2HelperPrice::getCurrencyByCode($item->currency);
			if ($currency) {
				$this->params->set('price_unit', $currency->symbol);
			} else {
				$this->params->set('price_unit', $item->currency);
			}
			
		?>
			<tr class="cat-list-row<?php echo $k;?> djc_row<?php echo $k;?>">
				<?php if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2') && (isset($this->showCheckAll) && $this->showCheckAll)) : ?>
					<td class="center">
						<?php echo JHtml::_('grid.id',$k, $item->id); ?>
					</td>
				<?php endif; ?>
				<td class="djc_td_order_no">
					<a href="<?php echo $order_url;?>"><strong><?php echo str_pad($item->order_number, 5, '0', STR_PAD_LEFT); ?></strong></a>
					<?php 
					$invoice = false;
					if (!empty($item->invoice_number) && $this->params->get('cart_invoices', false)) {
						$invoice = true;
					}
					if ($invoice) {?>
						<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getOrderRoute($item->id).'&task=getInvoice'); ?>" class="btn button btn-small btn-primary"><span class="icon-download"></span> <?php echo JText::_('COM_DJCATALOG2_GET_INVOICE'); ?></a>
					<?php } ?>
					<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getOrderRoute($item->id).'&task=cart.reorder'); ?>" class="btn button btn-small btn-success"><span class="icon-refresh"></span> <?php echo JText::_('COM_DJCATALOG2_REORDER'); ?></a>
				</td>
				<td class="djc_td_order_date">
					<a href="<?php echo $order_url;?>"><?php echo JHtml::_('date', $item->created_date, $this->params->get('date_format_date', JText::_('DATE_FORMAT_LC3'))); ?></a>
				</td>
				<td class="djc_td_order_status">
					<?php //echo JText::_('COM_DJCATALOG2_ORDER_STATUS_'.$item->status); ?>
					<?php echo DJCatalog2HtmlHelper::getOrderStatusName($item->status); ?>
				</td>
				<td class="djc_td_order_total">
					<?php echo DJCatalog2HtmlHelper::formatPrice($item->grand_total, $this->params); ?>
				</td>
			</tr>
		<?php } ?>
		<?php $this->params->set('price_unit', $original_currency);?>
	</tbody>
</table>