<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
?>
<h1 class="componentheading<?php echo $this->params->get( 'pageclass_sfx' ) ?>">
	<?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>

<div id="djcatalog" class="djc_order_rating<?php echo $this->params->get( 'pageclass_sfx' ).' djc_theme_'.$this->params->get('theme','default') ?>">
	<?php if ($this->rating_items == false) {?>
		<div class="alert djc_order_rating--alert">
			<?php echo JText::_('COM_DJCATALOG2_ORDER_RATING_ITEMS_ALERT')?>
		</div>
	<?php } else { ?>
	<div class="djc_order_rating--items">
		<?php foreach($this->rating_items as $item) {?>
			<div class="djc_order_rating--item row-fluid">
				<div class="djc_order_rating--item-details span6">
					<?php if ((int)$this->params->get('image_link_item', 0) != -1) { ?>
						<?php 
						$variant = 'img';
						$layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
						$imageData = array(	'item' => &$item, 
											'type' => 'item', 
											'size' => 'medium', 
											'variant' => $variant, 
											'hover_img' => false,
											'context' => 'com_djcatalog2.items.list', 
											'params' => &$this->params);
						echo $layout->render($imageData);
						?> 
					<?php } ?>
					<h3 class="djc_title">
						<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug))?>"><?php echo $item->name; ?></a>
					</h3>
				</div>
				<div class="djc_order_rating--item-rating span6">
					<?php 
					
					$canVote = Djcatalog2HelperRating::canVote($item->id);
					
					$voteData = array('item' => $item, 'params' => $this->params, 'context' => 'com_djcatalog2.order_item', 'can_vote' => $canVote, 'not_hidden'=>true);
					$layout = new JLayoutFile('com_djcatalog2.item.rating', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
					echo $layout->render($voteData);
					
					if ($canVote) {
						$layout = new JLayoutFile('com_djcatalog2.item.vote', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
						echo $layout->render($voteData);
					} else {?>
						<span class="badge djc_order_rating--item-rating-badge"><?php echo JText::_('COM_DJCATALOG2_ORDER_RATING_ALREADY_RATED');?></span>
					<?php }
					?>
				</div>
			</div>
		<?php } ?>
	</div>
	<?php } ?>
</div>