<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$app = JFactory::getApplication();
$combinationId = $app->input->getInt('combination_id', 0);

if (!isset($this->item->images) || $combinationId > 0) {
	if ($combinationId > 0) {
		$this->item->images = DJCatalog2ImageHelper::getImages('combination', $combinationId);
		if (empty($this->item->images)) {
			$this->item->images = DJCatalog2ImageHelper::getImages('item', $this->item->id);
		}
	} else {
		$this->item->images = DJCatalog2ImageHelper::getImages('item', $this->item->id);
	}
}

if (!$this->item->images && empty($this->item->videos)) {
	return;
}

$djMediaTools = ($this->params->get('djmediatools_integration', 0) == '1' && $this->params->get('djmediatools_album_item', 0) > 0) ? $this->params->get('djmediatools_album_item', 0) : false;
$djMediaToolsMinimum = (int)$this->params->get('djmediatools_minimum', 1);

$fullscreenVar = ($this->params->get('image_popup_src', 'opt') == 'opt') ? 'fullscreen' : 'original'; 

$allMedias = array();
foreach($this->item->images as $img) {
	$img->__type = 'image';
	$img->_href = $img->$fullscreenVar;
	$img->_large = $img->large;
	$img->_small = $img->small;
	$allMedias[] = $img;
}
if(isset($this->item->videos) && count($this->item->videos)) {
    foreach($this->item->videos as $vid) {
        $vid->__type = 'video';
        $vid->_href = $vid->fullpath;
        if ($vid->cover != '' && $vid->cover_path != '') {
            $vid->_large = DJCatalog2ImageHelper::getProcessedImage($vid->cover, $this->params->get('width'), $this->params->get('height'), ($this->params->get('resize') == 0), $vid->cover_path);
            $vid->_small = DJCatalog2ImageHelper::getProcessedImage($vid->cover, $this->params->get('smallth_width'), $this->params->get('smallth_height'), ($this->params->get('resize') == 0), $vid->cover_path);
        } else if ($this->params->get('image_default', false)) {
            $vid->_large = DJCatalog2ImageHelper::getDefaultImage('item', 'large');
            $vid->_small = DJCatalog2ImageHelper::getDefaultImage('item', 'small');
        } else if (($customThumb = DJCatalog2ThemeHelper::getThemeImage('default-thumbnail.jpg', 'path')) != '') {
            $vid->_large = DJCatalog2ImageHelper::getDefaultImage('item', 'large', ['custom_image' => $customThumb]);
            $vid->_small = DJCatalog2ImageHelper::getDefaultImage('item', 'small', ['custom_image' => $customThumb]);
        } else {
            continue;
        }

        $allMedias[] = $vid;
    }
}

DJCatalog2HtmlHelper::sortImagesAndVideos($allMedias, (int)$this->params->get('image_video_sort_method', 1));

?>

<?php if ($djMediaTools > 0 && count($this->item->images) >= $djMediaToolsMinimum && !$combinationId) {?>
<div class="djc_images-mediatools">
	<?php echo JHtml::_('content.prepare', '{djmedia '.(int)$djMediaTools.'}', $this->params, 'com_djcatalog2.item.djmediatools'); ?>
</div>
<?php } else { ?>
<?php 
$galleryType = $this->params->get('gallery_type', 'switcher');
$imageSwitcher = (count($allMedias) > 1 && $galleryType == 'switcher');
$showMain = $galleryType == 'small_popups' ? false : true;
?>
<div class="djc_images <?php if ($imageSwitcher) { echo 'djc_image_switcher'; }?> pull-right">
	<?php if ($showMain) {?>
		<div class="djc_mainimage">
		<?php if ($imageSwitcher) {?>
			<a data-type="<?php echo $allMedias[0]->__type; ?>" data-target="main-image-link" data-thumb="0" title="<?php echo $allMedias[0]->caption; ?>" href="<?php echo $allMedias[0]->_href; ?>">
				<img data-type="<?php echo $allMedias[0]->__type; ?>" itemprop="image" class="img-polaroid" alt="<?php echo $allMedias[0]->caption; ?>" src="<?php echo $allMedias[0]->_large; ?>" />
			</a>
		<?php } else { ?>
			<a data-type="<?php echo $allMedias[0]->__type; ?>" class="djimagebox" title="<?php echo $allMedias[0]->caption; ?>" href="<?php echo $allMedias[0]->_href; ?>">
				<img data-type="<?php echo $allMedias[0]->__type; ?>" itemprop="image" id="djc_mainimage" class="img-polaroid" alt="<?php echo $allMedias[0]->caption; ?>" src="<?php echo $allMedias[0]->_large; ?>" />
			</a>
		<?php } ?>
	</div>
	<?php } ?>
	<?php if (count($allMedias) > (($imageSwitcher || !$showMain) ? 0 : 1)) { ?>
		<div class="djc_thumbnails" id="djc_thumbnails" data-toggle="image-thumbs">
		<?php for($i = (($imageSwitcher || !$showMain) ? 0 : 1); $i < count($allMedias); $i++) { ?>
			<div class="djc_thumbnail">
				<a data-type="<?php echo $allMedias[$i]->__type; ?>" class="djimagebox <?php echo ($allMedias[$i]->__type == 'video') ? 'mfp-iframe' : 'mfp-image'; ?>" title="<?php echo $allMedias[$i]->caption; ?>" href="<?php echo $allMedias[$i]->_href; ?>" data-thumb="<?php echo $i; ?>" data-large="<?php echo $allMedias[$i]->_large; ?>">
					<img class="img-polaroid" alt="<?php echo $allMedias[$i]->caption; ?>" src="<?php echo $allMedias[$i]->_small; ?>" />
				</a>
			</div>
			<?php } ?>
		</div>
	<?php } ?>
</div>
<?php } ?>
