<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');

class DJCatalog2ViewConfigurable extends JViewLegacy {
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		$this->_addPath('template', JPATH_COMPONENT.  '/themes/default/views/configurable');
		$theme = DJCatalog2ThemeHelper::getThemeName();
		if ($theme && $theme != 'default') {
			$this->_addPath('template', JPATH_COMPONENT.  '/themes/'.$theme.'/views/configurable');
		}
	}
	
	function display($tpl = null) {
		$app = JFactory::getApplication();
		$dispatcher	= JEventDispatcher::getInstance();
		
		$this->document = JFactory::getDocument();
		$model = $this->getModel();
		$this->params = $params = Djcatalog2Helper::getParams();
		
		$this->steps_at_once = $this->params->get('configurable_at_once', false);
		$this->category_id = $app->input->getInt('cid');
		
		$layout = $this->getLayout();
		
		if ($layout == 'default') {
			if ($this->steps_at_once) {
				JFactory::getDocument()->addScript(JUri::base(true).'/components/com_djcatalog2/assets/js/configurable_atonce.js');
			} else {
				JFactory::getDocument()->addScript(JUri::base(true).'/components/com_djcatalog2/assets/js/configurable.js');
			}
			
			$currentConfig = $app->input->getBase64('configuration');
			
			if ($currentConfig) {
				$currentConfig = base64_decode($currentConfig);
			}
			
			$initOpts = array(
				'uri' => JUri::base(true),
				'viewUri' => JUri::current(),
				'configuration' => $currentConfig,
				'category_id' => $this->category_id,
				'steps_at_once' => $this->steps_at_once
			);
			$langOpts = array(
				'CONFIRM' => JText::_('COM_DJCATALOG2_CFGWIZ_CONFIRM'),
				'GO_BACK' => JText::_('COM_DJCATALOG2_CFGWIZ_GO_BACK'),
				'SELECTED' => JText::_('COM_DJCATALOG2_CFGWIZ_SELECTED'),
				'SELECTED_PRODUCT' => JText::_('COM_DJCATALOG2_CFGWIZ_SELECTED_PRODUCT'),
				'SELECTED_CATEGORY' => JText::_('COM_DJCATALOG2_CFGWIZ_SELECTED_CATEGORY'),
				'ADD_TO_CART' => JText::_('COM_DJCATALOG2_ADD_TO_CART')
			);
			$initScript = 'jQuery(document).ready(function(){new DJC2ConfigurableWizard('.json_encode($initOpts, JSON_FORCE_OBJECT).', '.json_encode($langOpts, JSON_FORCE_OBJECT).');});';
			
			JFactory::getDocument()->addScriptDeclaration($initScript);
			$this->configuration = $model->getConfiguration();
			$this->_prepareDocument();
			parent::display($tpl);
		} else {
			
			ob_start();
			
			if ($layout == 'categories') {
				$this->categories = $model->getCategories();
			} else if ($layout == 'items') {
				$this->items = $model->getItems();
			} else if ($layout == 'steps' || $layout == 'allsteps' || $layout == 'dimensions') {
				$this->item = $model->getItem();
			}
			
			parent::display();
			$output = ob_get_contents();
			ob_end_clean();
			
			echo $output;
			$app->close();
		}
		
		return;
	}
	
	protected function _prepareDocument() {
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$pathway	= $app->getPathway();
		$title		= null;
		$heading		= null;

		$menu = $menus->getActive();
		
		if ($menu) {
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		$title = $this->params->get('page_title', '');

		if ($menu && ($menu->query['option'] != 'com_djcatalog2' || $menu->query['view'] != 'configurable')) {
			
			$title = JText::_('COM_DJCATALOG2_CONFIGURABLE_HEADING');
			
			$this->params->set('page_heading', $title);
			
			$path = array(array('title' => $title, 'link' => ''));
			foreach ($path as $item)
			{
				$pathway->addItem($item['title'], $item['link']);
			}
		}

		if (empty($title)) {
			$title = $app->getCfg('sitename');
		}
		elseif ($app->getCfg('sitename_pagetitles', 0)) {
			if ($app->getCfg('sitename_pagetitles', 0) == '2') {
				$title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
			} else {
				$title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
			}
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description')) 
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords')) 
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}
		
		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}

}




