<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$current = ($this->category_id > 0) ? 1 : 2;

?>

<?php if (!empty($this->item->config_dimensions) && is_array($this->item->config_dimensions) && $this->steps_at_once == false) {?>
	<div class="djc_cfg_step_outer" data-step-no="<?php echo $current++; ?>" data-step-type="dimensions">
		<h2 class="djc_cfg_step_heading">Enter dimensions [<?php echo $this->item->config_dimensions_unit; ?>]</h2>
		<?php foreach($this->item->config_dimensions as $dimension) {?>
			<div class="control-group">
				<div class="controls">
					<label class="hide required" for="cfg_dim_<?php echo $dimension?>">
						<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>
					</label>
					
					<?php 
					$min = '';
					$max = '';
					
					$placeholder = $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)).'... ';
					
					if (isset($this->item->config_dimensions_settings['min_' . $dimension])) {
						$min = 'min="'.$this->item->config_dimensions_settings['min_' . $dimension].'"';
						$placeholder .= 'min. ' . $this->item->config_dimensions_settings['min_' . $dimension];
					}
					if (isset($this->item->config_dimensions_settings['max_' . $dimension]) && $this->item->config_dimensions_settings['max_' . $dimension] > 0.0) {
						$max = 'max="'.$this->item->config_dimensions_settings['max_' . $dimension].'"';
						if (!$min) {
							$placeholder .= 'max. ' . $this->item->config_dimensions_settings['max_' . $dimension];
						} else {
							$placeholder .= ' - ' . 'max. ' . $this->item->config_dimensions_settings['max_' . $dimension];
						}
					}
					
					?>
					
					<input type="number" name="<?php echo $dimension; ?>" 
						id="cfg_dim_<?php echo $dimension?>"
						class="input required"  
						step="1"
						<?php echo $min.' '.$max ; ?>
						placeholder="<?php echo $placeholder?>"
						required="required" aria-required="required"
						data-lbl="<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>" 
						 />
				</div>
			</div>
		<?php } ?>
		<div class="control-group">
			<div class="controls">
				<button class="djc_cfg_item djc_cfg_item-step btn validate" type="button" role="button"
					data-type="dimensions" 
					data-unit="<?php echo $this->escape($this->item->config_dimensions_unit); ?>"
					><?php echo JText::_('JSAVE');?></button>
			</div>
		</div>
	</div>
<?php } ?>

<?php if (!empty($this->item->config_conditions) && is_array($this->item->config_conditions)) {?>
	<?php foreach($this->item->config_conditions as $stepNo => $step) {?>
		<?php 
		$count = count($step['options']);
		?>
		<div class="djc_cfg_step_outer" data-step-no="<?php echo $current++; ?>" data-step-type="steps">
			<h2 class="djc_cfg_step_heading"><?php echo JText::sprintf('COM_DJCATALOG2_CFGWIZ_SELECT_ITEM', $step['name']); ?></h2>
			<?php if (trim($step['description']) != '') {?>
				<div class="djc_cfg_step_desc"><?php echo $step['description']; ?></div>
			<?php } ?>
			<?php
			foreach($step['options'] as $stepOpt) {?>
				<?php 
				$style = '';
				$description = '';
				$optionParams = $stepOpt['params'];
				if ($optionParams->get('hexcode')) {
					$style .= 'background-color: ' . $optionParams->get('hexcode').';';
				}
				if ($optionParams->get('file_name')) {
					$style .= 'background-image: url(\''.DJCATIMGURLPATH .'/colors/'. $optionParams->get('file_name').'\');';
				}
				if ($style == '') {
					//$style = 'background-color: #ccc; background-image: url(\''.JUri::base(true) .'/components/com_djcatalog2/themes/'.$this->params->get('theme', 'default').'/images/icon-no-color.png\')';
				} 
				if ($optionParams->get('description')) {
					$description = $optionParams->get('description');
				}
				?>
				<button class="djc_cfg_item djc_cfg_item-step btn" type="button" role="button"
					data-type="steps" 
					data-id="<?php echo $stepOpt['id']; ?>" 
					data-field_id="<?php echo $step['field_id']; ?>" 
					data-value="<?php echo $this->escape($stepOpt['value']); ?>" 
					data-lbl="<?php echo $this->escape($step['name']); ?>"
					data-dependancies='<?php echo $this->escape(json_encode($stepOpt['dependancies']))?>'
					data-price="<?php echo $this->escape($stepOpt['price']); ?>"
					data-pricemod="<?php echo $this->escape($stepOpt['price_mod']); ?>"
					data-info="<?php echo $this->escape($stepOpt['info']); ?>"
					data-sku="<?php echo $this->escape($stepOpt['sku']); ?>"
					>
					<?php if ($style) {?>
						<span class="djc_configurable_btn_bg" style="<?php echo $style; ?>"></span> 
					<?php } ?>
					
					<?php echo $stepOpt['value']; ?>
				</button>
		<?php } ?>
		</div>
	<?php } ?>
<?php } ?>

<?php if (!empty($this->item->config_dimensions) && is_array($this->item->config_dimensions) && $this->steps_at_once == true) {?>
	<div class="djc_cfg_step_outer" data-step-no="<?php echo $current++; ?>" data-step-type="dimensions">
		<h2 class="djc_cfg_step_heading">Enter dimensions [<?php echo $this->item->config_dimensions_unit; ?>]</h2>
		<?php foreach($this->item->config_dimensions as $dimension) {?>
			<div class="control-group">
				<div class="controls">
					<label class="hide required" for="cfg_dim_<?php echo $dimension?>">
						<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>
					</label>
					<input type="text" name="<?php echo $dimension; ?>" 
						id="cfg_dim_<?php echo $dimension?>"
						class="input required"  
						required="required" aria-required="required"
						data-lbl="<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>" 
						placeholder="<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>..." />
				</div>
			</div>
		<?php } ?>
		<div class="control-group">
			<div class="controls">
				<button class="djc_cfg_item djc_cfg_item-step btn validate" type="button" role="button"
					data-type="dimensions" 
					data-unit="<?php echo $this->escape($this->item->config_dimensions_unit); ?>"
					><?php echo JText::_('JSAVE');?></button>
			</div>
		</div>
	</div>
<?php } ?>

<?php
/*

	echo '<div class="well">';
	echo '<h4>Krok #'. $stepNo.' - ' . $step['name'] .'</h4>';
	echo '<h5>dostępne opcje</h5>';
	
	echo '<ul>';
	foreach($step['options'] as $stepOpt) {
		echo '<li>';
		
		echo $stepOpt['value'];
		if (!empty($stepOpt['dependancies'])) {
			echo '<br />';
			$stepOptDeptList = array();
			foreach($stepOpt['dependancies'] as $stepOptDept) {
				
				$op = $stepOptDept['operator'];
				if ($op == 'eq') {
					$op = '=';
				}
				if ($op == 'not') {
					$op = '!=';
				}
				
				$stepOptLine = $stepOptDept['name'].' <strong>'.$op.'</strong>';
				if (is_array($stepOptDept['match'])) {
					$stepOptLine .= ' '. implode(', ', $stepOptDept['match_values']);
				} else {
					$stepOptLine .= ' '. $stepOptDept['match'];
				}
				
				$stepOptDeptList[] = $stepOptLine;
			}
			
			echo '<ul><li>'.implode('</li><li>', $stepOptDeptList).'</li></ul>';
		}
		
		echo '</li>';
	}
	echo '</ul>';
	
	echo '</div>';

*/
?>
