<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$columns = 4;
$current = 0;
$count = count($this->items);

?>

<h2 class="djc_cfg_step_heading"><?php echo JText::_('COM_DJCATALOG2_CFGWIZ_SELECT_PRODUCT'); ?></h2>

<?php 

foreach($this->items as $item) {?>
	<?php 
	$prices = Djcatalog2HelperPrice::getPrices($item->final_price, $item->price, $item->tax_rule_id, false, $this->params);
	?>
	<?php if ($current % $columns == 0) {?>
		<div class="row-fluid">
	<?php } ?>
	<div class="span<?php echo floor(12/$columns); ?>">
		<div class="djc_cfg_item djc_cfg_item-category" 
			data-type="items" 
			data-id="<?php echo $item->id; ?>" 
			data-lbl="<?php echo $this->escape($item->name); ?>"
			data-price="<?php echo $this->escape($prices['display']); ?>"
			data-unit="<?php echo $this->escape(json_encode(DJCatalog2HelperQuantity::getUnit($item->unit_id))); ?>"
			>
			<?php 
			$variant = 'img';
			$layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
			$imageData = array(	'item' => &$item, 
								'type' => 'item', 
								'size' => 'medium', 
								'variant' => $variant, 
								'hover_img' => false,
								'context' => 'com_djcatalog2.items.list', 
								'params' => &$this->params);
			echo $layout->render($imageData);
			?> 
			<strong><?php echo $item->name; ?></strong>
		</div>
	</div>
	<?php if (($current+1) % $columns == 0 || $current+1 >= $count) { ?>
		</div>
	<?php } ?>
	<?php $current++; ?>
<?php } ?>
