<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');


$current = ($this->category_id > 0) ? 1 : 2;
if (!empty($this->item->config_conditions) && is_array($this->item->config_conditions)) {
	$current += count($this->item->config_conditions) + 1;
}

?>
<?php if (!empty($this->item->config_dimensions) && is_array($this->item->config_dimensions)) {?>
	<div class="djc_cfg_step_outer" data-step-no="<?php echo $current; ?>" data-step-type="dimensions">
		<h2 class="djc_cfg_step_heading">Enter dimensions [<?php echo $this->item->config_dimensions_unit; ?>]</h2>
		<?php foreach($this->item->config_dimensions as $dimension) {?>
			<div class="control-group">
				<div class="controls">
					<label class="hide required" for="cfg_dim_<?php echo $dimension?>">
						<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>
					</label>
					<input type="text" name="<?php echo $dimension; ?>" 
						id="cfg_dim_<?php echo $dimension?>"
						class="input required"  
						required="required" aria-required="required"
						data-lbl="<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>" 
						placeholder="<?php echo $this->escape(JText::_('COM_DJCATALOG2_' . $dimension)); ?>..." />
				</div>
			</div>
		<?php } ?>
		<div class="control-group">
			<div class="controls">
				<button class="djc_cfg_item djc_cfg_item-step btn validate" type="button" role="button"
					data-type="dimensions" 
					data-unit="<?php echo $this->escape($this->item->config_dimensions_unit); ?>"
					><?php echo JText::_('JSAVE');?></button>
			</div>
		</div>
	</div>
<?php } ?>
