<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$current = ($this->category_id > 0) ? 1 : 2;

?>

<?php if (!empty($this->item->config_conditions) && is_array($this->item->config_conditions)) {?>
	<?php foreach($this->item->config_conditions as $stepNo => $step) {?>
		<?php 
		$count = count($step['options']);
		?>
		<div class="djc_cfg_step_outer" data-choice-no="<?php echo $current++; ?>" data-step-type="steps">
			<h2 class="djc_cfg_step_heading"><?php echo JText::sprintf('COM_DJCATALOG2_CFGWIZ_SELECT_ITEM', $step['name']); ?></h2>
			<?php
			foreach($step['options'] as $stepOpt) {?>
				<?php 
				$style = '';
				$description = '';
				$optionParams = $stepOpt['params'];
				if ($optionParams->get('hexcode')) {
					$style .= 'background-color: ' . $optionParams->get('hexcode').';';
				}
				if ($optionParams->get('file_name')) {
					$style .= 'background-image: url(\''.DJCATIMGURLPATH .'/colors/'. $optionParams->get('file_name').'\');';
				}
				if ($style == '') {
					//$style = 'background-color: #ccc; background-image: url(\''.JUri::base(true) .'/components/com_djcatalog2/themes/'.$this->params->get('theme', 'default').'/images/icon-no-color.png\')';
				}
				if ($optionParams->get('description')) {
					$description = $optionParams->get('description');
				}
				?>
				<button class="djc_cfg_item djc_cfg_item-step btn" type="button" role="button"
					data-type="steps" 
					data-id="<?php echo $stepOpt['id']; ?>" 
					data-field_id="<?php echo $step['field_id']; ?>" 
					data-value="<?php echo $this->escape($stepOpt['value']); ?>" 
					data-lbl="<?php echo $this->escape($step['name']); ?>"
					data-dependancies='<?php echo $this->escape(json_encode($stepOpt['dependancies']))?>'
					data-price="<?php echo $this->escape($stepOpt['price']); ?>"
					data-pricemod="<?php echo $this->escape($stepOpt['price_mod']); ?>"
					data-info="<?php echo $this->escape($stepOpt['info']); ?>"
					data-sku="<?php echo $this->escape($stepOpt['sku']); ?>"
					>
					<?php if ($style) {?>
						<span class="djc_configurable_btn_bg" style="<?php echo $style; ?>"></span> 
					<?php } ?>
					<?php echo $stepOpt['value']; ?>
				</button>
		<?php } ?>
		</div>
	<?php } ?>
<?php } ?>

