<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();
$return_url = base64_encode(JUri::getInstance()->__toString());

$attributes = $this->basket->getAttributes();

$show_vat = $this->params->get('cart_show_vat', 1);

$tbl_class = 'djc_cart_table';

$col_span_price = 3;
/*if ($show_vat) {
 $col_span_price += 2;
 }*/

$net_prices = (bool)((int)$this->params->get('price_including_tax', 1) == 0);
$salesman = false;//$user->authorise('djcatalog2.salesman', 'com_djcatalog2');

if (count($attributes) > 0) {
	$tbl_class .= ' has_attributes';
	$col_span_price += count($attributes);
}

//$show_discount = (bool)(($this->product_old_total['gross'] > 0.0 && $this->product_total['gross'] != $this->product_old_total['gross']));
$price_components = $this->basket->getPriceComponents();
/* RESPONSIVE styles - row headings */
$colcounter = 2;
$css = '@media screen and (max-width: 979px) {
	
/*#djcatalog .djc_cart tbody td:nth-of-type('.($colcounter++).'):before { content: "'.JText::_('COM_DJCATALOG2_CART_NAME').'"; }*/
#djcatalog .djc_cart tbody td:nth-of-type('.($colcounter++).'):before { content: "'.JText::_('COM_DJCATALOG2_QUANTITY').'"; }
';

if (count($attributes) > 0) {
	$colcounter+=count($attributes);
}

if ($show_vat) {
	$css .= '#djcatalog .djc_cart tbody td:nth-of-type('.($colcounter++).'):before { content: "'.JText::_('COM_DJCATALOG2_NET_VALUE').'"; }';
	$css .= '#djcatalog .djc_cart tbody td:nth-of-type('.($colcounter++).'):before { content: "'.JText::_('COM_DJCATALOG2_TAX').'"; }';
	
	$css .= '#djcatalog .djc_cart tfoot .djc_cart_foot td:nth-of-type(2):before { content: "'.JText::_('COM_DJCATALOG2_NET_VALUE').'"; }';
	$css .= '#djcatalog .djc_cart tfoot .djc_cart_foot td:nth-of-type(3):before { content: "'.JText::_('COM_DJCATALOG2_TAX').'"; }';
	$css .= '#djcatalog .djc_cart tfoot .djc_cart_foot td:nth-of-type(4):before { content: "'.JText::_('COM_DJCATALOG2_TOTAL_VALUE').'"; }';
} else {
	$css .= '#djcatalog .djc_cart tfoot .djc_cart_foot td:nth-of-type(2):before { content: "'.JText::_('COM_DJCATALOG2_TOTAL_VALUE').'"; }';
}

$css .= '#djcatalog .djc_cart tbody td:nth-of-type('.($colcounter++).'):before { content: "'.JText::_('COM_DJCATALOG2_TOTAL_VALUE').'"; }';
$css .= '#djcatalog .djc_cart tfoot .djc_cart_foot td:nth-of-type(1):before { content: ""; }';
$css .= '}';

if ($css != '') {
	JFactory::getDocument()->addStyleDeclaration($css);
}
/* RESPONSIVE styles - end */

?>
<table width="100%" cellpadding="0" cellspacing="0" class="<?php echo $tbl_class; ?> jlist-table category table-condensed table" id="djc_cart_checkout_table">
	<thead>
		<tr>
			<th class="djc_thead djc_th_title" colspan="2">
				<?php echo JText::_('COM_DJCATALOG2_CART_NAME'); ?>
			</th>
			<th class="djc_thead djc_th_qty">
				<?php echo JText::_('COM_DJCATALOG2_QUANTITY'); ?>
			</th>
			<?php if (count($attributes) > 0) {?>
				<?php foreach ($attributes as $attribute) {?>
				<th class="djc_thead djc_attribute">
					<?php echo $attribute->name; ?>
				</th>
				<?php } ?>
			<?php } ?>
			<?php if ($show_vat) {?>
				<th class="djc_thead djc_th_price djc_th_price_net">
					<?php echo JText::_('COM_DJCATALOG2_NET_VALUE'); ?>
				</th>
				<th class="djc_thead djc_th_price djc_th_price_tax">
					<?php echo JText::_('COM_DJCATALOG2_TAX'); ?>
				</th>
			<?php } ?>
			<th class="djc_thead djc_th_price djc_th_price_gross">
				<?php echo JText::_('COM_DJCATALOG2_TOTAL_VALUE'); ?>
			</th>
		</tr>
	</thead>
	
	<tbody>
		<?php
	$k = 1;
	foreach($this->items as $basketitem){
		$item = clone $basketitem;
		$k = 1 - $k;
		$item->_customisations = $this->basket->getCustomisations($item->_sid);
		$this->item_cursor = $item;
		
		if (!empty($item->parent)) {
			if (!$item->item_image && $item->parent->item_image) {
				$item->item_image = $item->parent->item_image;
				$item->image_caption = $item->parent->image_caption;
				$item->image_path = $item->parent->image_path;
				$item->image_fullpath = $item->parent->image_fullpath;
			}
			$item->name = $item->parent->name . ' ['.$item->name.']';
			$item->slug = $item->parent_id.':'.$item->parent->alias;
		}
		
		if (!empty($item->_combination)) {
			$comboImages = DJCatalog2ImageHelper::getImages('combination', $item->_combination->id);
			if ($comboImages) {
				$item->item_image = $comboImages[0]->fullname;
				$item->image_caption = $comboImages[0]->caption;
				$item->image_path = $comboImages[0]->path;
				$item->image_fullpath = $comboImages[0]->fullpath;
			}
		}
		
		$item->_link = ($item->id > 0 && $item->slug) ? DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug) : '#';
		$item->_popuplink = ($item->id > 0 && $item->slug) ? DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug, null, 'preview').'&tmpl=component' : '#';
		
		if ($item->sku && $this->params->get('cart_display_sku', 1) == '1') {
			$item->name = $item->name . '<small class="djc_sku"> (#' . $item->sku.')</small>';
		}
		?>
		<tr class="cat-list-row<?php echo $k;?> djc_row<?php echo $k; if ($item->featured == 1) echo ' featured_item'; ?>">
			<td class="djc_td_image">
			<?php if ($item->item_image) { ?>
				<?php /*?><span class="djc_image">
					<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug)); ?>"><img class="img-polaroid" alt="<?php echo $item->image_caption; ?>" src="<?php echo DJCatalog2ImageHelper::getImageUrl($item->image_fullpath,'small'); ?>"/></a>
				</span><?php */ ?>
				<?php 
				$variant = 'link';
				$layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
				$imageData = array(	'item' => &$item, 
									'type' => 'item', 
									'size' => 'small', 
									'variant' => $variant, 
									'hover_img' => false,
									'context' => 'com_djcatalog2.items.cart', 
									'params' => &$this->params);
				echo $layout->render($imageData);
				?>
			<?php } ?>
			</td>
			<td class="djc_td_title">
				<?php if ($item->_link && $item->_link != '#') {?>
					<a href="<?php echo JRoute::_($item->_link); ?>"><?php echo $item->name; ?></a>
				<?php } else {?>
					<?php echo $item->name; ?>
				<?php } ?>
				
				<?php if (!empty($item->_combination)) {?>
					<ul class="djc_combination_info inine list-inline">
					<?php foreach($item->_combination->fields as $comboField) { ?>
						<li><?php echo $comboField->field_name.': <strong>'.$comboField->field_value.'</strong>'; ?></li>
					<?php } ?>
					</ul>
				<?php } ?>
				
				<?php $features = $this->basket->getItemFeatures($item, true, 'list');
				if (!empty($features)) { ?>
					<ul class="djc_combination_info">
					<?php foreach($features as $feature) { ?>
						<li><?php echo $feature->field_name.': <strong>'.$feature->field_value.'</strong>'; ?></li>
					<?php } ?>
					</ul>
				<?php } ?>
				
				<?php if (count($item->_customisations) > 0) { ?>
					<div class="djc_customisation_info">
					<?php foreach($item->_customisations as $customOption) { ?>
						<strong><?php echo $customOption->name; ?></strong>
							<?php if (count($customOption->data)) { ?>
								<ul class="djc_customistation_data">
									<?php foreach($customOption->data as $inputParam) {?>
										<li>
											<?php if ($inputParam['type'] == 'text' || $inputParam['type'] == 'textarea' || $inputParam['type'] == 'checkbox' || $inputParam['type'] == 'radio') {?>
												<?php echo $inputParam['name'].': <strong>'.$inputParam['value'].'</strong>'; ?>
											<?php } else if ($inputParam['type'] == 'file') {?>
												<?php echo $inputParam['name']; ?>:
												<?php if ($inputParam['value'] != '') {?>
													<?php $jsonFiles = json_decode($inputParam['value'], true); ?>
													<?php foreach ($jsonFiles as $jsonFile) {
														$ext = JFile::getExt($jsonFile['fullname']);
														if ($ext == 'jpg' || $ext == 'png' || $ext == 'svg' || $ext == 'gif') { ?>
															<br /><span class="djc_customisation_file" style="width: 64px; height: 64px; display: inline-block; background-repeat: no-repeat; background-size: cover; background-image: url('<?php echo $jsonFile['url']; ?>')"></span>
														<?php } else { ?>
															<br /><span><?php echo '['.strtoupper($ext).'] '.$jsonFile['caption']; ?></span>
														<?php } ?>
													<?php } ?>
												<?php } ?>
											<?php } else {
												$dispatcher = JEventDispatcher::getInstance();
												$results =         $dispatcher->trigger('onProductCustomisationCheckoutPrepare', [$item,  $this, $inputParam]);
												$html = '';
												foreach($results as $result) {
													if (trim($result) == '' || empty($result)) continue;
													$html .= $result;
												}
												echo $html;

                                            } ?>
										</li>
									<?php } ?>
								</ul>
							<?php } ?>
					<?php } ?>
					</div>
				<?php } ?>
			</td>
			<td class="djc_td_update_qty" nowrap="nowrap">
				<?php 
				$unit = DJCatalog2HelperQuantity::getUnit($item->unit_id); 
				echo DJCatalog2HelperQuantity::formatAmount($item->_quantity, $this->params); 
				if ($unit->show_unit) {
					echo ' '.$unit->unit;
				}
				?>
				<?php 
				/*$unit = DJCatalog2HelperQuantity::getUnit($item->unit_id); 
				$btnOpts = array(
					'name' => 'quantity['.$item->_sid.']', 
					'value' => $item->_quantity, 
					'show_box' => true, 
					'readonly' => true,
					'disabled' => true
				);
				echo DJCatalog2HelperQuantity::renderInput($unit, $item, $btnOpts);*/
				?>
			</td>
			<?php if (count($attributes) > 0) {?>
				<?php foreach ($attributes as $attribute) {?>
				<td class="djc_td_cart_attribute">
					<?php 
					$this->attribute_cursor = clone $attribute;
					$this->attribute_values = $this->basket->getItemAttributes($item, true);
					echo $this->loadTemplate('itemattribute'); 
					?>
				</td>
				<?php } ?>
			<?php } ?>
			<?php if ($show_vat) {?>
				<td class="djc_td_price djc_td_price_net" nowrap="nowrap">
					<?php echo DJCatalog2HtmlHelper::formatPrice($item->_prices['total']['net'], $this->params, false)?>
				</td>
				<td class="djc_td_price djc_td_price_tax" nowrap="nowrap">
					<?php echo DJCatalog2HtmlHelper::formatPrice($item->_prices['total']['tax'], $this->params, false)?>
				</td>
			<?php } ?>
			<td class="djc_td_price djc_td_price_gross" nowrap="nowrap">
				<?php echo DJCatalog2HtmlHelper::formatPrice($item->_prices['total']['gross'], $this->params, false)?>
				<?php if ($item->_prices['total']['gross'] < $item->_prices['total']['old_gross'] && $item->_prices['total']['old_gross'] > 0.0) {?>
					<br />
					<span class="djc_price_old">
					<?php echo DJCatalog2HtmlHelper::formatPrice($item->_prices['total']['old_gross'], $this->params); ?>
					</span>
					<br />
					<?php 
					echo JText::sprintf('COM_DJCATALOG2_CHEAPER_PC', round( 100* ($item->_prices['total']['old_gross']-$item->_prices['total']['gross'])/$item->_prices['total']['old_gross'] ));
					?>
				<?php } ?>
			</td>
		</tr>
	<?php } ?>
	
	<?php if ($cartCustoms = $this->basket->getCustomisations(0)) { ?>
		<?php foreach($cartCustoms as $customOption) { ?>
		<tr>
			<td class="djc_td_title" colspan="<?php echo $col_span_price; ?>">
				<div class="djc_customisation_info">
					<strong><?php echo $customOption->name; ?></strong>
						<?php if (count($customOption->data)) { ?>
							<ul class="djc_customistation_data">
								<?php foreach($customOption->data as $inputParam) {?>
									<li>
										<?php if ($inputParam['type'] == 'text' || $inputParam['type'] == 'checkbox' || $inputParam['type'] == 'radio') {?>
											<?php echo $inputParam['name'].': <strong>'.$inputParam['value'].'</strong>'; ?>
										<?php } else if ($inputParam['type'] == 'file') {?>
											<?php echo $inputParam['name']; ?>:
											<?php if ($inputParam['value'] != '') {?>
											<?php $jsonFiles = json_decode($inputParam['value'], true); ?>
											<?php foreach ($jsonFiles as $jsonFile) {?>
												<br /><span class="djc_customisation_file" style="width: 64px; height: 64px; display: inline-block; background-repeat: no-repeat; background-size: cover; background-image: url('<?php echo $jsonFile['url']; ?>')"></span>
											<?php } ?>
											<?php } ?>
										<?php } ?>
									</li>
								<?php } ?>
							</ul>
						<?php } ?>
				</div>
			</td>
			
			<?php if ($show_vat) {?>
				<td class="djc_td_price djc_td_price_net" nowrap="nowrap">
					<?php echo DJCatalog2HtmlHelper::formatPrice($customOption->_prices['total']['net'], $this->params, false)?>
				</td>
				<td class="djc_td_price djc_td_price_tax" nowrap="nowrap">
					<?php echo DJCatalog2HtmlHelper::formatPrice($customOption->_prices['total']['tax'], $this->params, false)?>
				</td>
			<?php } ?>
			<td class="djc_td_price djc_td_price_gross" nowrap="nowrap">
				<?php echo ($item->_prices['total']['gross'] > 0.0) ? DJCatalog2HtmlHelper::formatPrice($customOption->_prices['total']['gross'], $this->params, false) : '-';?>
			</td>
			
		</tr>
		<?php } ?>
	<?php } ?>
	
	</tbody>
	
	<tfoot>
		<?php /* if($show_discount) { ?>
			<tr class="djc_cart_foot djc_cart_foot_old_price">
				<td class="djc_ft_total_label" colspan="<?php echo $col_span_price;?>" >
					<?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_OLD_TOTAL'); ?>
				</td>
				<?php if ($show_vat) {?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['net'], $this->params)?>
				</td>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['tax'], $this->params)?>
				</td>
				<?php } ?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['net'], $this->params); ?>
				</td>
			</tr>
			<tr class="djc_cart_foot djc_cart_foot_discount">
				<td class="djc_ft_total_label" colspan="<?php echo $col_span_price;?>" >
					<?php 
					if ($this->basket->coupon) {
					    echo JText::_('COM_DJCATALOG2_CART_FOOTER_COUPON_DISCOUNT');
	                    
					    if($this->basket->coupon->type == 'percent') {
	                        echo ' ('. (float)$this->basket->coupon->value . '%)';
	                    } else {
	                        echo ' ('. DJCatalog2HtmlHelper::formatPrice($this->basket->coupon->value, $this->params) .')';
	                    }
					}
					?>
				</td>
				<?php if ($show_vat) {?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['net'] - $this->product_total['net'], $this->params)?>
				</td>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['tax'] - $this->product_total['tax'], $this->params)?>
				</td>
				<?php } ?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['net'] - $this->product_total['net'], $this->params); ?>
				</td>
			</tr>
			<?php }*/ ?>
			
			
			<?php if (is_array($price_components) && count($price_components) > 0 && $this->product_old_total['gross']) {?>
			<tr class="djc_cart_foot djc_cart_foot_old_price">
				<td class="djc_ft_total_label" colspan="<?php echo $col_span_price;?>" >
					<?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_OLD_SUBTOTAL'); ?>
				</td>
				<?php if ($show_vat) {?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['net'], $this->params)?>
				</td>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['tax'], $this->params)?>
				</td>
				<?php } ?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['gross'], $this->params); ?>
				</td>
			</tr>
			
			<?php foreach($price_components as $price_component) {?>
				<tr class="djc_cart_foot djc_cart_foot_discount">
					<td class="djc_ft_total_label" colspan="<?php echo $col_span_price;?>" >
						<?php 
						if ($price_component->type == 'coupon') {
							echo JText::_('COM_DJCATALOG2_CART_FOOTER_COUPON_DISCOUNT');
							
							if($this->basket->coupon->type == 'percent') {
								echo ' ('. (float)$this->basket->coupon->value . '%)';
							} else {
								echo ' ('. DJCatalog2HtmlHelper::formatPrice($this->basket->coupon->value, $this->params) .')';
							}
						} else {
							echo $price_component->name;
						}
						?>
					</td>
					<?php if ($show_vat) {?>
					<td>
						<?php echo DJCatalog2HtmlHelper::formatPrice(($price_component->value['net']), $this->params)?>
					</td>
					<td>
						<?php echo DJCatalog2HtmlHelper::formatPrice(($price_component->value['tax']), $this->params)?>
					</td>
					<?php } ?>
					<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice(($price_component->value['gross']), $this->params)?>
					</td>
				</tr>
			<?php } ?>
		<?php } ?>
		
		<tr class="djc_cart_foot djc_cart_foot_total">
			<td colspan="<?php echo $col_span_price; ?>" class="djc_ft_total_label">
				<?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_TOTAL'); ?>
			</td>
			<?php if ($show_vat) {?>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_total['net'], $this->params)?>
				</td>
				<td>
					<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_total['tax'], $this->params)?>
				</td>
			<?php } ?>
			<td>
				<?php echo DJCatalog2HtmlHelper::formatPrice($this->product_total['gross'], $this->params)?>
			</td>
		</tr>
	</tfoot>
</table>