<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();
$app = JFactory::getApplication();
$return_url = base64_encode(DJCatalogHelperRoute::getCheckoutRoute());

$app->setUserState('com_users.edit.profile.redirect', DJCatalogHelperRoute::getCheckoutRoute());
$editBilling = (bool)$app->input->getInt('billing', false);

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
JHtml::_('bootstrap.tooltip');

$salesman = $user->authorise('djcatalog2.salesman', 'com_djcatalog2') || $user->authorise('core.admin', 'com_djcatalog2');

$price_components = $this->basket->getPriceComponents();

?>

<div class="djc_checkout_progress djc_clearfix <?php echo (JFactory::getUser()->guest && !($this->params->get('cart_registered', '1') == '0' && $this->params->get('cart_skip_login', '0') == '1')) ? 'steps-3' : 'steps-2'; ?>">
	<div class="djc_checkout-step djc_checkout-step-1 passed">
		<a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getCartRoute()); ?>"><?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART');?></a>
	</div>
	<?php if ( !($this->params->get('cart_registered', '1') == '0' && $this->params->get('cart_skip_login', '0') == '1') ) { ?>
	<div class="djc_checkout-step djc_checkout-step-2 passed">
		<?php if (JFactory::getUser()->guest) {?>
		<a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getCartRoute().'&layout=login'); ?>"><?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART_LOGIN');?></a>
		<?php } else {?>
		<a href="<?php echo JRoute::_('index.php?option=com_users&view=profile&layout=edit&return='.$return_url); ?>"><?php echo JText::_('COM_DJCATALOG2_EDIT_PROFILE'); ?></a>
		<?php } ?>
	</div>
	<?php } ?>
	<div class="djc_checkout-step djc_checkout-step-3 active">
		<span><?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART_CHECKOUT');?></span>
	</div>
</div>

<?php //if ($this->params->get( 'show_page_heading', 1)) { ?>
<h1 class="componentheading<?php echo $this->params->get( 'pageclass_sfx' ) ?>">
	<?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>
<?php //} ?>
<div id="djcatalog" class="djc_checkout<?php echo $this->params->get( 'pageclass_sfx' ).' djc_theme_'.$this->params->get('theme','default') ?>">

<?php if (count($this->items) > 0) { ?>
	<h2><?php echo JText::_('COM_DJCATALOG2_ORDER_ITEMS'); ?></h2>
	<div class="djc_cart djc_cart_checkout djc_clearfix">
		<?php echo $this->loadTemplate('table'); ?>
	</div>
<?php }  ?>

<div class="djc_checkout_form">
<form action="<?php echo JRoute::_(DJCatalogHelperRoute::getCheckoutRoute());?>" method="post" class="form-validate form" id="djc_checkout_form">
	<fieldset class="djc_checkout_notes">
		<?php $deliveryFields = $this->form->getFieldset('delivery'); ?>
		<?php //if (!empty($deliveryFields)) {?>
		<div class="row-fluid">
			<div class="span<?php echo (!empty($deliveryFields)) ? 6: 12; ?>">
				<div class="djc_billing_details" id="djc_billing_wrapper">
					<h2 id="bilform"><?php echo JText::_('COM_DJCATALOG2_USER_BILLING_HEADING'); ?></h2>
					<?php 
					$fields = $this->form->getFieldset('basicprofile'); 
						foreach ($fields as $field) { ?>
							<?php echo $field->renderField(); ?>
					<?php } ?>
				</div>
			</div>
			<?php if (!empty($deliveryFields)) {?>
			<div class="span6">
				<div class="djc_delivery_form" id="djc_delivery_wrapper">
					<h2><?php echo JText::_('COM_DJCATALOG2_DELIVERY_DETAILS_HEADING'); ?></h2>
					<?php $deliveryToggle = $this->form->getField('delivery_to_billing', 'djcatalog2delivery');?>
					<div class="control-group">
						<div class="control-label">
							<?php echo $deliveryToggle->label; ?>
						</div>
						<div class="controls">
							<?php echo $deliveryToggle->input; ?>
						</div>
					</div>
					<div id="djc_delivery_fields">
					
						<?php if ($this->params->get('cart_addressbook', true)) {?>
						<div class="djc_address_book">
							<h4><?php echo JText::_('COM_DJCATALOG2_ADDRESS_BOOK_CHOOSE'); ?></h4>
							<?php $cleanAddress = array('id'=>0, 'name'=>'', 'name'=>'', 'firstname'=>'', 'lastname'=>'', 'company'=>'', 'address'=>'', 'country_id'=>'0', 'state_id'=>'0', 'city_id'=>'0', 'postcode'=>'', 'phone'=>''); ?>
							<select class="djc_address_book_list">
								<option value="" data-address='<?php echo json_encode($cleanAddress) ?>'><?php echo JText::_('COM_DJCATALOG2_CHOOSE_ADDRESS') ?></option>
								<?php foreach($this->addresses as $address) { ?>
									<option value="<?php echo $address->id ?>" data-address='<?php echo json_encode($address)?>'><?php echo $address->name ?></option>
								<?php } ?>
							</select>
						</div>
						<script type="text/javascript">
							jQuery(document).ready(function(){
								jQuery('.djc_address_book_list option').data();
								jQuery('.djc_address_book_list').on('change', function(e){
									var address = jQuery(this).find(':selected').data('address');
									jQuery.each(address, function(field, value) {
										jQuery("#jform_djcatalog2delivery_" + field).val(value);
									});
								});
							});
						</script>
						<?php } ?>
					
					<?php foreach ($deliveryFields as $field) { ?>
						<?php if ($field->fieldname == 'delivery_to_billing') continue; ?>
						<?php if ($field->fieldname == 'save') { 
							if($user->guest) continue;
						?>
						<div class="control-group form-inline save-address-book">
							<?php echo $field->input; ?> <?php echo $field->label; ?>
						</div>
						<?php } else { 
							echo $field->renderField();
						} ?>
					<?php } ?>
					</div>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php //} ?>
		
		<?php $deliveryPaymentFields = $this->form->getFieldset('delivery_payment'); ?>
		<?php if (!empty($deliveryPaymentFields)) {?>
		<div class="djc_orderdetails">
				<?php if ($this->form->getField('delivery_method_id', 'djcatalog2orderdetails')) {?>
				<div class="row-fluid">
					<div class="span12">
						<h2><?php echo JText::_('COM_DJCATALOG2_DELIVERY_OPTIONS_HEADING'); ?></h2>
						<?php echo $this->form->getControlGroup('delivery_method_id', 'djcatalog2orderdetails');?>
					</div>
				</div>
				
				<?php if (!empty($this->delivery_info)) { ?>
				<div class="row-fluid">
					<div class="span12">
						<div class="djc_delivery_extra_data">
						<?php if (!empty($this->delivery_info)) {
							foreach ($this->delivery_info as $deliveryId => $deliveryPlg) {
								if (!empty($deliveryPlg)) { ?>
									<div id="djc_delivery_details-<?php echo $deliveryId; ?>" data-id="<?php echo $deliveryId; ?>" class="djc_delivery_details" style="display: none">
										<?php echo implode('', $deliveryPlg); ?>
									</div>
								<?php }
							}	
						} ?>
						</div>
					</div>
				</div>
				<?php } ?>
				
				<?php } ?>
				<?php if ($this->form->getField('payment_method_id', 'djcatalog2orderdetails')) {?>
				<div class="row-fluid">
					<div class="span12">
						<h2><?php echo JText::_('COM_DJCATALOG2_PAYMENT_OPTIONS_HEADING'); ?></h2>
						<?php echo $this->form->getControlGroup('payment_method_id', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('recurring', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('repeat', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('repeat_interval', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('repeat_until', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('weekday', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('weekly_weekdays', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('monthday', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('weekno', 'djcatalog2orderdetails');?>
						<?php echo $this->form->getControlGroup('monthly_weekdays', 'djcatalog2orderdetails');?>
					</div>
				</div>
				<?php } ?>
			
			
			<?php if (!empty($this->payment_info)) { ?>
			<div class="row-fluid">
				<div class="span12">
					<div class="djc_payment_extra_data">
					<?php if (!empty($this->payment_info)) {
						foreach ($this->payment_info as $paymentId => $paymentPlg) {
							if (!empty($paymentPlg)) { ?>
								<div id="djc_payment_details-<?php echo $paymentId; ?>" data-id="<?php echo $paymentId; ?>" class="djc_payment_details" style="display: none">
									<?php echo implode('', $paymentPlg); ?>
								</div>
							<?php }
						}	
					} ?>
					</div>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php } ?>
			
		<?php /* Do not remove this container, it's used by shipping/payment plugins */ ?>
		<div class="row-fluid">
			<div class="span12">
				<div id="djcDeliveryForm"></div>
			</div>
		</div>

		<?php if ($this->params->get('cart_shipping_days_info', false) && count($this->shipping_days) > 0) : ?>
			<div class="row-fluid">
				<div class="span12">
					<p class="center text-center shipping-days-msg shipping-days-msg-1"><strong><?php echo JText::sprintf('COM_DJCATALOG2_EST_DELIVERY_DAYS', array_key_last($this->shipping_days)); ?></strong></p>
				</div>
			</div>
		<?php endif; ?>
		
		<?php if ($this->params->get('cart_shipping_days_split', false) && count($this->shipping_days) > 1) : ?>
			<div class="row-fluid">
				<div class="span12">
					<p class="center text-center shipping-days-msg shipping-days-msg-2"><strong><?php echo JText::sprintf('COM_DJCATALOG2_DELIVERY_SHIPPINGS_COUNT', count($this->shipping_days)); ?></strong></p>
					<div class="control-group">
							<div class="control-label">
								<label id="shipping-days-lbl" for="shipping-days"><?php echo JText::_('COM_DJCATALOG2_DELIVERY_PREFERD_SHIPPING_DAYS') ?></label>
							</div>
							<div class="controls">
								<select required="true" id="shipping-days" name="jform[djcatalog2delivery][shipping_days]" class="inputbox input input-large" aria-invalid="false">
									<?php for($i = 1; $i <= count($this->shipping_days); $i++) : ?>
											<option value="<?php echo $i;?>"><?php echo $i;?></option>
									<?php endfor; ?>
								</select>
							</div>
					</div>
					<table class="shipping-days-details">
							<?php $deilvery = 1; ?>
							<?php foreach ($this->shipping_days as $days => $shipping_day) : ?>
								<tr>
									<th><?php echo JText::sprintf('COM_DJCATALOG2_DELIVERY_SHIPPINGS_DAYS_DEILVERY_NUMBER', $deilvery, $days); ?></th>
								</tr>
								<?php $item_number = 1; ?>
								<?php foreach ($shipping_day as $item) : ?>
									<tr>
											<td><?php echo $item_number . '. ' . $item->name . (($item->_quantity > 1) ? ' x ' . $item->_quantity : ''); ?></td>
									</tr>
									<?php $item_number++; ?>
								<?php endforeach; ?>
								<?php $deilvery++; ?>
							<?php endforeach; ?>
					</table>
				</div>
			</div>
		<?php endif; ?>

		<div class="row-fluid">
			<div class="span12">
				<div class="djc_order_totals">
					<h2><?php echo JText::_('COM_DJCATALOG2_ORDER_SUMMARY'); ?></h2>
					<div id="djc_ordersummary">
						<table class="table">
							<thead></thead>
							
							<tbody>
								<tr>
									<td class="text-left djc_label"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_PRODUCTS'); ?></td>
									<td class="text-left value"><span id="djc_summary_gross"><?php echo DJCatalog2HtmlHelper::formatPrice($this->basket->product_total['gross'], $this->params, false); ?></span></td>
								</tr>
								<tr>
									<td class="text-left djc_label"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_DELIVERY'); ?></td>
									<td class="text-left value"><span id="djc_summary_delivery"><?php 
									if ($this->basket->delivery) {
										echo DJCatalog2HtmlHelper::formatPrice($this->basket->delivery->_prices['total']['gross'], $this->params, false);	
									} else {
										echo DJCatalog2HtmlHelper::formatPrice(0, $this->params, false);
									}
									?></span></td>
								</tr>
								<tr>
									<td class="text-left djc_label"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_PAYMENT'); ?></td>
									<td class="text-left value"><span id="djc_summary_payment"><?php 
									if ($this->basket->payment) {
										echo DJCatalog2HtmlHelper::formatPrice($this->basket->payment->_prices['total']['gross'], $this->params, false);	
									} else {
										echo DJCatalog2HtmlHelper::formatPrice(0, $this->params, false);
									}
									?></span></td>
								</tr>
								<?php if (!empty($price_components)) {
									$component_names = array();
									$component_value = 0.0;
									foreach($price_components as $component) {
										if ($component->type == 'coupon' || ($component->type == 'rule' && $component->rule->calc_type != 'grand_total')) {
											continue;
										}
										$component_names[] = $component->name;
										$component_value += $component->value['gross'];
									} ?>
									<?php if (count($component_names)) {?>
									<tr>
										<td class="text-left djc_label">
											<?php echo implode('<br />', $component_names); ?>
										</td>
										<td class="text-left value">
											<span id="djc_summary_components">
											<?php echo DJCatalog2HtmlHelper::formatPrice($component_value, $this->params, false); ?>
											</span>
										</td>
									</tr>
									<?php } ?>
								<?php } ?>
							</tbody>
							
							<tfoot>
								<tr>
									<td class="text-left djc_label"><strong><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_TOTAL'); ?></strong></td>
									<td class="text-left value"><strong><span id="djc_summary_total"><?php echo DJCatalog2HtmlHelper::formatPrice($this->basket->total['gross'], $this->params, false); ?></span></strong></td>
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
		
		<div class="row-fluid">
			<div class="span12">
				<?php foreach ($this->form->getFieldsets() as $fieldset) { ?>
					<?php if ($fieldset->name != 'basicprofile' && $fieldset->name != 'delivery' && $fieldset->name != 'delivery_payment') { ?>
						<?php $fields = $this->form->getFieldset($fieldset->name);?>
						<?php if (count($fields)>0) { ?>
							<div class="djc_order_additional form-horizontal">
							<?php if ($fieldset->label) { ?>
							<h2><?php echo JText::_($fieldset->label); ?></h2>
							<?php } ?>
							<?php foreach($fields as $field) { ?>
								<?php if ($field->hidden) { ?>
									 <?php echo $field->input;?>
								<?php } /*else if ($field->fieldname == 'customer_note') { ?>
									<div class="control-group">
										<div class="controls">
											<div style="display: none;"><?php echo $field->label; ?></div>
											<?php echo $field->input; ?>
										</div>
									</div>
								<?php }*/ else { ?>
									<?php if ($field->type == 'Checkbox') { ?>
											<div class="control-group checkbox">
												<?php echo $field->input;?> <?php echo $field->label;?>
											</div>
										<?php } else { ?>
											<?php echo $field->renderField(); ?>
										<?php } ?>
								<?php }?>
							<?php } ?>
							</div>
						<?php } ?>
					<?php } ?>
				 <?php } ?>
			</div>
		</div>
		
		<div class="row-fluid">
			<div class="span12">
				<div class="control-group djc_order_submit" id="djc_order_submit">
					<a class="button btn djc_back_to_cart_btn btn-primary" href="<?php echo JRoute::_(DJCatalogHelperRoute::getCartRoute());?>"><span><?php echo JText::_('COM_DJCATALOG2_BACK_TO_CART'); ?></span></a>
					<?php /* ?><input type="submit" value="<?php echo JText::_('COM_DJCATALOG2_CONFIRM_CHECKOUT');?>" class="btn btn-success button validate" /> <?php */ ?>
					<input type="submit" value="<?php echo JText::_('COM_DJCATALOG2_CONFIRM_CHECKOUT');?>" class="btn btn-success button validate"  onclick="return Joomla.submitbutton('cart.confirm');"/>
				</div>
			</div>
		</div>
	</fieldset>
	
	
	<input type="hidden" name="option" value="com_djcatalog2" />
	<input type="hidden" name="task" value="cart.confirm" />
	<?php echo JHtml::_( 'form.token' ); ?>
</form>
</div>
<?php 
	if ($this->params->get('show_footer')) echo DJCATFOOTER;
?>
</div>
<script type="text/javascript">
	<?php /*?>
	var DJC2Checkout = {
		init : function() {
			this.request = new Request({
				url: '<?php echo JUri::base(false).'index.php?option=com_djcatalog2&task=getUserData&format=raw'; ?>',
				link: 'cancel',
				onRequest: function(){
					},
				onSuccess: function (responseText, responseXML) {
					var jsonObj = JSON.decode(responseText);
					},
				onFailure: function(xhr) {
					}
			});
		},
		getUserData : function(user_id){
			window.location.href = '<?php echo JUri::base(false).'index.php?option=com_djcatalog2&task=cart.selectUser'; ?>' + '&user_id=' + user_id;
			//this.request.send('user_id=' + user_id);
		}
	};

	DJC2Checkout.init();
	<?php */ ?>
	Joomla.submitbutton = function(task)
	{
		if (jQuery('#djc_order_submit input[type="submit"]').attr('quasi-disabled')) {
			return false; 
		} 
		  if (document.formvalidator.isValid(document.getElementById('djc_checkout_form'))) {
			  	jQuery('#djc_order_submit input[type="submit"]').attr('quasi-disabled', 'disabled');
				return true;
		  }
		  else {
				var msgCont = jQuery('#system-message-container');
				if (msgCont.length > 0) {
					 jQuery('html, body').animate({
						  scrollTop: msgCont.offset().top - 10
					 }, 10);
				} else {
					 alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED'));?>');
				}
		  }
		  return false;
	 }
</script>

<?php if (!empty($this->delivery_methods)) {?>
	<?php JText::script('COM_DJCATALOG2_FREE_DELIVERY_MODAL_MSG'); ?>
	<script>
	jQuery(document).ready(function(){
		var delivery = jQuery('input[name="jform[djcatalog2orderdetails][delivery_method_id]"]');
		var timer;
		var currentTotal = parseFloat(<?php echo floatval($this->product_total['gross']);?>);
		var deliveries = <?php echo json_encode($this->delivery_methods); ?>;
		var modalMsg = jQuery('#djc_free_delivery_modal');
		if (modalMsg.length == 0) return;
	
		modalMsg.detach().appendTo(jQuery(document.body));
	
		delivery.change(function(){
			if (timer) clearTimeout(timer);
			timer = setTimeout(function(){
				var field = jQuery('input[name="jform[djcatalog2orderdetails][delivery_method_id]"]:checked');
				if (!field.length) return;
	
				var idx = field.val();
				if (typeof deliveries[idx] == 'undefined') return;
	
				if (parseFloat(deliveries[idx].price) == 0.0) return;
	
				var free_amount = parseFloat(deliveries[idx].free_amount);
				if (isNaN(free_amount)) return;
	
				var left_price = (free_amount - currentTotal).toFixed(2);
				var msg = Joomla.JText._('COM_DJCATALOG2_FREE_DELIVERY_MODAL_MSG');
				msg = msg.replace('%s', left_price);
				if (free_amount > currentTotal ) {
					modalMsg.find('.djc_free_delivery_modal--msg').html('').text(msg);
					modalMsg.modal();
				}
			}, 1200);
		});
	});
	</script>
	
	<?php echo JHtmlBootstrap::renderModal('djc_free_delivery_modal', array('height'=> '500px', 'title' => JText::_('COM_DJCATALOG2_FREE_DELIVERY_MODAL_HEADING'), 'footer' => ' ',), '<div class="djc_free_delivery_modal--msg"></div>' ); ?>
<?php } ?>