<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

use Joomla\Registry\Registry;

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');
jimport('joomla.html.pagination');

class DJCatalog2ViewCart extends JViewLegacy {
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		$this->_addPath('template', JPATH_COMPONENT.  '/themes/default/views/cart');
		$theme = DJCatalog2ThemeHelper::getThemeName();
		if ($theme && $theme != 'default') {
			$this->_addPath('template', JPATH_COMPONENT.  '/themes/'.$theme.'/views/cart');
		}
	}
	
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		
		$this->params = Djcatalog2Helper::getParams();
		
		if ($this->params->get('cart_one_step') && $this->getLayout() != 'onestep') {
			$this->setLayout('onestep');
		}
		
		$cart_items = $app->getUserState('com_djcatalog2.cart.items', array());
		
		$this->basket = Djcatalog2HelperCart::getInstance();
		$this->items = $this->basket->getItems();
		$this->total = $this->basket->getTotal();
		$this->product_total = $this->basket->getProductTotal();
		$this->product_old_total = $this->basket->getProductOldTotal();
		$this->related_accessories = $this->basket->getRelatedAccessoriess();
		
		$this->shipping_days = $this->basket->getShippingDays($this->items);
		
		if (count($this->items)) {
            JModelLegacy::addIncludePath(JPATH_BASE.'/components/com_djcatalog2/models', 'DJCatalog2Model');
            $itemsModel = JModelLegacy::getInstance('Items', 'Djcatalog2Model', array('ignore_request'=>true));
            $parents = array();
            foreach ($this->items as $item) {
                if ($item->parent_id > 0) {
                    $parents[] = $item->parent_id;
                }
            }
            if (count($parents) > 0) {
                $state      = $itemsModel->getState();
                $itemsModel->setState('list.start', 0);
                $itemsModel->setState('list.limit', 0);
                $itemsModel->setState('filter.catalogue',false);
                $itemsModel->setState('list.ordering', 'i.name');
                $itemsModel->setState('list.direction', 'asc');
                $itemsModel->setState('filter.parent', '*');
                $itemsModel->setState('filter.state', '3');
                
                $itemsModel->setState('filter.item_ids', $parents);
                
                $parentItems = $itemsModel->getItems();
                
                foreach ($this->items as $id=>$item) {
                    if ($item->parent_id > 0 && isset($parentItems[$item->parent_id])) {
                        $this->items[$id]->parent =  $parentItems[$item->parent_id];
                    } else {
                        $this->items[$id]->parent =  false;
                    }
                }
            }
        }
        
		$this->_prepareDocument();
		
		if ($this->getLayout() == 'login') {
			if ($user->guest == false) {
				$app->redirect(JRoute::_(DJCatalog2HelperRoute::getCheckoutRoute(), false), 303);
				return;
			}
			
			$lang = JFactory::getLanguage();
			$lang->load('com_users');
			
			/*JForm::addFormPath(JPath::clean(JPATH_ROOT.'/components/com_users/models/forms'));
			JModelLegacy::addIncludePath(JPath::clean(JPATH_ROOT.'/components/com_users/models'), 'UsersModel');
			$registration_model = JModelLegacy::getInstance('Registration', 'UsersModel');
			
			$this->reg_data   = $registration_model->getData();
			$this->reg_form   = $registration_model->getForm();
			$this->reg_state  = $registration_model->getState();
			$this->reg_params = $this->reg_state->get('params');
			*/
			
			require_once JPATH_ROOT.'/components/com_users/helpers/route.php';
			$this->params->set('page_heading', JText::_('COM_DJCATALOG2_CART_LOGIN_HEADING'));
		} else if ($this->getLayout() == 'onestep') {
			
			if (!$this->params->get('cart_query_enabled', '1') && !$this->params->get('cart_enabled', '1')) {
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
				return false;
			}
			
			$defaultSubLayout = 'checkout';
			if (!$this->params->get('cart_enabled', '1')) {
				$defaultSubLayout = 'query';
			}
			
			$subLayout = $app->input->getCmd('type', $defaultSubLayout);
			if ($subLayout != 'checkout' && $subLayout != 'query') {
				$subLayout = $defaultSubLayout;
			}

			if ($subLayout == 'checkout' && !$this->params->get('cart_enabled', '1')) {
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
				return false;
			}
			if ($subLayout == 'query' && !$this->params->get('cart_query_enabled', '1')) {
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
				return false;
			}
			
			$this->subLayout = $subLayout;
			
			if ($this->subLayout == 'checkout') {
				$this->prepareCheckoutView();
			} else if ($this->subLayout == 'query') {
				$this->prepareQueryView();
			}
			
		}
        
		parent::display($tpl);
	}
	
	protected function prepareCheckoutView(){
		$app = JFactory::getApplication();
		$user_profile = Djcatalog2Helper::getUserProfile();
		$user = Djcatalog2Helper::getUser();
		
		$model = JModelLegacy::getInstance('Order', 'Djcatalog2Model', array());
		$this->setModel($model, true);
		$this->model = $this->getModel();
		
		$this->form = $this->get('Form');
		
		$data = JArrayHelper::fromObject($user_profile, false);
		$postOrder = (array)$app->getUserState('com_djcatalog2.order.data', array());
		
		if (!empty($postOrder)) {
			foreach($postOrder as $k=>$v) {
				$data[$k] = $v;
			}
		}
		
		$this->user_valid = $this->model->validate($this->form, array('djcatalog2profile' => $data), 'djcatalog2profile');
		$this->billing_valid = $this->model->validate($this->form, array('djcatalog2billing' => $data), 'djcatalog2billing');
		
		$dispatcher = JEventDispatcher::getInstance();
		
		JPluginHelper::importPlugin('djcatalog2payment');
		JPluginHelper::importPlugin('djcatalog2delivery');
		
		$deliveryMethods = $model->getDeliveryMethods();
		$paymentMethods = $model->getPaymentMethods(($this->basket->productTypes['tangible'] > 0 ? '*' : 0));
		
		$deliveryRes = array();
		$paymentRes = array();
		
		foreach ($deliveryMethods as &$deliveryObject) {
			$params = new Registry();
			$params->loadString($deliveryObject->params, 'JSON');
			$deliveryObject->params = $params;
			$deliveryRes[$deliveryObject->id] = $dispatcher->trigger('onDJC2CheckoutDetailsDisplay', array('com_djcatalog2.checkout.delivery', $deliveryObject));
		}
		unset($deliveryObject);
		
		foreach ($paymentMethods as &$paymentObject) {
			$params = new Registry();
			$params->loadString($paymentObject->params, 'JSON');
			$paymentObject->params = $params;
			$paymentRes[$paymentObject->id] = $dispatcher->trigger('onDJC2CheckoutDetailsDisplay', array('com_djcatalog2.checkout.payment', $paymentObject));
		}
		unset($paymentObject);
		
		$addresses = JModelLegacy::getInstance('Addresses', 'Djcatalog2Model', array());
		$this->addresses = $addresses->getItems();
		
		$this->delivery_info = $deliveryRes;
		$this->payment_info = $paymentRes;
		
		$this->delivery_methods = $deliveryMethods;
		$this->payment_methods = $paymentMethods;
		
		$this->user_profile = $user_profile;
		$this->user = $user;
		$this->total = $this->basket->getTotal();
		$this->product_total = $this->basket->getProductTotal();
		$this->product_old_total = $this->basket->getProductOldTotal();
	}
	
	protected function prepareQueryView(){
		$app = JFactory::getApplication();
		
		$user_profile = Djcatalog2Helper::getUserProfile();
		$user = Djcatalog2Helper::getUser();
		
		$model = JModelLegacy::getInstance('Query', 'Djcatalog2Model', array());
		$this->setModel($model, true);
		$this->model = $this->getModel();
		
		$this->form = $this->get('Form');
		
		$data = JArrayHelper::fromObject($user_profile, false);
		$post_data = (array)$app->getUserState('com_djcatalog2.query.data', array());
		
		if (!empty($post_data)) {
			foreach($post_data as $k=>$v) {
				$data[$k] = $v;
			}
		}
		
		$this->user_valid = $this->model->validate($this->form, array('djcatalog2profile' => $data), 'djcatalog2profile');
		
		if ($user_profile) {
			$name = array();
			if (!empty($user_profile->firstname)) {
				$name[] = $user_profile->firstname;
			}
			if (!empty($user_profile->lastname)) {
				$name[] = $user_profile->lastname;
			}
			
			$user_profile->_name = (count($name) > 0) ? implode(' ', $name) : null;
		}
		
		$this->user_profile = $user_profile;
		$this->user = $user;
	}
	
	protected function _prepareDocument() {
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$pathway	= $app->getPathway();
		$title		= null;
		$heading		= null;

		$menu = $menus->getActive();
		$menu_query = (!empty($menu->query)) ? $menu->query : array();
		$option = (!empty($menu_query['option'])) ? $menu_query['option'] : null;
		$view = (!empty($menu_query['view'])) ? $menu_query['view'] : null;
		
		if ($menu && $option == 'com_djcatalog2' && $view == 'cart') {
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		} else {
			$this->params->set('page_heading', JText::_('COM_DJCATALOG2_CART_HEADING'));
		}
		
		$title = ($option == 'com_djcatalog2' && $view == 'cart') ? $this->params->get('page_title', '') : null;

		if (empty($title)) {
			$title = JText::_('COM_DJCATALOG2_CART_HEADING');
		}
		elseif ($app->getCfg('sitename_pagetitles', 0)) {
			if ($app->getCfg('sitename_pagetitles', 0) == '2') {
				$title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
			} else {
				$title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
			}
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description')) 
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords')) 
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}
		
		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}

}




