<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
JHtml::_('bootstrap.tooltip');

$app = JFactory::getApplication();
$user = JFactory::getUser();

$areas = array();
if ($this->params->get('cart_query_enabled', '1') == '1') {
	$areas['query'] = true;
}
if ($this->params->get('cart_enabled', '1') == '1') {
	$areas['checkout'] = true;
}

$displayTabs = count($areas) > 1;
$subLayout = $this->subLayout;

?>

<?php //if ($this->params->get( 'show_page_heading', 1)) { ?>
<h1 class="componentheading<?php echo $this->params->get( 'pageclass_sfx' ) ?>">
	<?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>
<?php //} ?>

<div id="djcatalog" class="djc_cart<?php echo $this->params->get( 'pageclass_sfx' ).' djc_theme_'.$this->params->get('theme','default') ?>">

<?php if (count($this->items) < 1){ ?>
	<p class="djc_empty_cart"><?php echo JText::_('COM_DJCATALOG2_CART_IS_EMPTY'); ?></p>
<?php } else { ?>
	<div class="djc_cart djc_clearfix">
		<?php echo $this->loadTemplate('table2'); ?>
	</div>
	
	<?php if (count($areas) > 0) {?>
	
	<div class="djc_onestep_checkout">
		<?php if ($this->params->get('cart_coupons', 0) && $this->params->get('cart_enabled', 1)) {?>
			<?php echo $this->loadTemplate('coupon'); ?>
		<?php } ?>

		<?php if($this->params->get('cart_related_accessories') && !empty($this->related_accessories)) : ?>
			<?php echo $this->loadTemplate('related_accessories'); ?>
		<?php endif; ?>
		
		<?php if ($displayTabs) {?>
			<ul class="djc_onestep_nav nav nav-tabs">
				<li <?php echo $subLayout == 'checkout' ? 'class="active"' : ''?>><a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getCheckoutRoute());?>#tabcheckout"><?php echo JText::_('COM_DJCATALOG2_ONESTEP_TAB_CHECKOUT');?></a></li>
				<li <?php echo $subLayout == 'query' ? 'class="active"' : ''?>><a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getQueryRoute());?>#tabquery"><?php echo JText::_('COM_DJCATALOG2_ONESTEP_TAB_QUERY');?></a></li>
			</ul>
		<?php } ?>

		<?php if ($displayTabs) {?>
			<div class="tab-content"><div class="tab-pane active">
		<?php } ?>
		<?php if ( $user->guest 
			&& ( ($subLayout == 'checkout' && $this->params->get('cart_registered', 1)) 
			|| ($subLayout == 'query' && $this->params->get('cart_query_registered', 1)) ) ) {?>
			<?php echo $this->loadTemplate('loginform'); ?>
		<?php } else {?>
			<?php echo $this->loadTemplate($subLayout); ?>
		<?php } ?>
		
		<?php if ($displayTabs) {?>
			</div></div>
		<?php } ?>
	</div>
	<?php } ?>
<?php } ?>
</div>
